package org.cloudfoundry.client.v2.featureflags;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The entity response payload for Feature Flag operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_FeatureFlagEntity"})
public final class FeatureFlagEntity extends org.cloudfoundry.client.v2.featureflags._FeatureFlagEntity {
  private final @Nullable Boolean enabled;
  private final @Nullable String errorMessage;
  private final @Nullable String name;
  private final @Nullable String url;

  private FeatureFlagEntity(FeatureFlagEntity.Builder builder) {
    this.enabled = builder.enabled;
    this.errorMessage = builder.errorMessage;
    this.name = builder.name;
    this.url = builder.url;
  }

  /**
   * The state of the feature flag
   */
  @JsonProperty("enabled")
  @Override
  public @Nullable Boolean getEnabled() {
    return enabled;
  }

  /**
   * The custom error message for the feature flag
   */
  @JsonProperty("error_message")
  @Override
  public @Nullable String getErrorMessage() {
    return errorMessage;
  }

  /**
   * The name of the feature flag
   */
  @JsonProperty("name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * The url for the feature flag
   */
  @JsonProperty("url")
  @Override
  public @Nullable String getUrl() {
    return url;
  }

  /**
   * This instance is equal to all instances of {@code FeatureFlagEntity} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof FeatureFlagEntity
        && equalTo((FeatureFlagEntity) another);
  }

  private boolean equalTo(FeatureFlagEntity another) {
    return Objects.equals(enabled, another.enabled)
        && Objects.equals(errorMessage, another.errorMessage)
        && Objects.equals(name, another.name)
        && Objects.equals(url, another.url);
  }

  /**
   * Computes a hash code from attributes: {@code enabled}, {@code errorMessage}, {@code name}, {@code url}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(enabled);
    h += (h << 5) + Objects.hashCode(errorMessage);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(url);
    return h;
  }

  /**
   * Prints the immutable value {@code FeatureFlagEntity} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "FeatureFlagEntity{"
        + "enabled=" + enabled
        + ", errorMessage=" + errorMessage
        + ", name=" + name
        + ", url=" + url
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.featureflags._FeatureFlagEntity {
    Boolean enabled;
    String errorMessage;
    String name;
    String url;
    @JsonProperty("enabled")
    public void setEnabled(@Nullable Boolean enabled) {
      this.enabled = enabled;
    }
    @JsonProperty("error_message")
    public void setErrorMessage(@Nullable String errorMessage) {
      this.errorMessage = errorMessage;
    }
    @JsonProperty("name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty("url")
    public void setUrl(@Nullable String url) {
      this.url = url;
    }
    @Override
    public Boolean getEnabled() { throw new UnsupportedOperationException(); }
    @Override
    public String getErrorMessage() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getUrl() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static FeatureFlagEntity fromJson(Json json) {
    FeatureFlagEntity.Builder builder = FeatureFlagEntity.builder();
    if (json.enabled != null) {
      builder.enabled(json.enabled);
    }
    if (json.errorMessage != null) {
      builder.errorMessage(json.errorMessage);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.url != null) {
      builder.url(json.url);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link FeatureFlagEntity FeatureFlagEntity}.
   * @return A new FeatureFlagEntity builder
   */
  public static FeatureFlagEntity.Builder builder() {
    return new FeatureFlagEntity.Builder();
  }

  /**
   * Builds instances of type {@link FeatureFlagEntity FeatureFlagEntity}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private Boolean enabled;
    private String errorMessage;
    private String name;
    private String url;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v2.featureflags.AbstractFeatureFlag} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractFeatureFlag instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code FeatureFlagEntity} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(FeatureFlagEntity instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _FeatureFlagEntity} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_FeatureFlagEntity instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof AbstractFeatureFlag) {
        AbstractFeatureFlag instance = (AbstractFeatureFlag) object;
        String errorMessageValue = instance.getErrorMessage();
        if (errorMessageValue != null) {
          errorMessage(errorMessageValue);
        }
        String nameValue = instance.getName();
        if (nameValue != null) {
          name(nameValue);
        }
        Boolean enabledValue = instance.getEnabled();
        if (enabledValue != null) {
          enabled(enabledValue);
        }
        String urlValue = instance.getUrl();
        if (urlValue != null) {
          url(urlValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link _FeatureFlagEntity#getEnabled() enabled} attribute.
     * @param enabled The value for enabled (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("enabled")
    public final Builder enabled(@Nullable Boolean enabled) {
      this.enabled = enabled;
      return this;
    }

    /**
     * Initializes the value for the {@link _FeatureFlagEntity#getErrorMessage() errorMessage} attribute.
     * @param errorMessage The value for errorMessage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("error_message")
    public final Builder errorMessage(@Nullable String errorMessage) {
      this.errorMessage = errorMessage;
      return this;
    }

    /**
     * Initializes the value for the {@link _FeatureFlagEntity#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link _FeatureFlagEntity#getUrl() url} attribute.
     * @param url The value for url (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("url")
    public final Builder url(@Nullable String url) {
      this.url = url;
      return this;
    }

    /**
     * Builds a new {@link FeatureFlagEntity FeatureFlagEntity}.
     * @return An immutable instance of FeatureFlagEntity
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public FeatureFlagEntity build() {
      return new FeatureFlagEntity(this);
    }
  }
}
