package org.cloudfoundry.client.v3.applications;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Lifecycle;

/**
 * The request payload for the Create Application operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_CreateApplicationRequest"})
public final class CreateApplicationRequest
    extends org.cloudfoundry.client.v3.applications._CreateApplicationRequest {
  private final @Nullable Map<String, String> environmentVariables;
  private final @Nullable Lifecycle lifecycle;
  private final String name;
  private final ApplicationRelationships relationships;

  private CreateApplicationRequest(CreateApplicationRequest.Builder builder) {
    this.environmentVariables = builder.environmentVariables == null ? null : createUnmodifiableMap(false, false, builder.environmentVariables);
    this.lifecycle = builder.lifecycle;
    this.name = builder.name;
    this.relationships = builder.relationships;
  }

  /**
   * The environment variables
   */
  @Override
  public @Nullable Map<String, String> getEnvironmentVariables() {
    return environmentVariables;
  }

  /**
   * The lifecycle
   */
  @Override
  public @Nullable Lifecycle getLifecycle() {
    return lifecycle;
  }

  /**
   * The name
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * The relationships
   */
  @Override
  public ApplicationRelationships getRelationships() {
    return relationships;
  }

  /**
   * This instance is equal to all instances of {@code CreateApplicationRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CreateApplicationRequest
        && equalTo((CreateApplicationRequest) another);
  }

  private boolean equalTo(CreateApplicationRequest another) {
    return Objects.equals(environmentVariables, another.environmentVariables)
        && Objects.equals(lifecycle, another.lifecycle)
        && name.equals(another.name)
        && relationships.equals(another.relationships);
  }

  /**
   * Computes a hash code from attributes: {@code environmentVariables}, {@code lifecycle}, {@code name}, {@code relationships}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(environmentVariables);
    h += (h << 5) + Objects.hashCode(lifecycle);
    h += (h << 5) + name.hashCode();
    h += (h << 5) + relationships.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CreateApplicationRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CreateApplicationRequest{"
        + "environmentVariables=" + environmentVariables
        + ", lifecycle=" + lifecycle
        + ", name=" + name
        + ", relationships=" + relationships
        + "}";
  }

  /**
   * Creates a builder for {@link CreateApplicationRequest CreateApplicationRequest}.
   * @return A new CreateApplicationRequest builder
   */
  public static CreateApplicationRequest.Builder builder() {
    return new CreateApplicationRequest.Builder();
  }

  /**
   * Builds instances of type {@link CreateApplicationRequest CreateApplicationRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_RELATIONSHIPS = 0x2L;
    private long initBits = 0x3L;

    private Map<String, String> environmentVariables = null;
    private Lifecycle lifecycle;
    private String name;
    private ApplicationRelationships relationships;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateApplicationRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CreateApplicationRequest instance) {
      return from((_CreateApplicationRequest) instance);
    }

    /**
     * Copy abstract value type {@code _CreateApplicationRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CreateApplicationRequest instance) {
      Objects.requireNonNull(instance, "instance");
      Map<String, String> environmentVariablesValue = instance.getEnvironmentVariables();
      if (environmentVariablesValue != null) {
        putAllEnvironmentVariables(environmentVariablesValue);
      }
      Lifecycle lifecycleValue = instance.getLifecycle();
      if (lifecycleValue != null) {
        lifecycle(lifecycleValue);
      }
      name(instance.getName());
      relationships(instance.getRelationships());
      return this;
    }

    /**
     * Put one entry to the {@link _CreateApplicationRequest#getEnvironmentVariables() environmentVariables} map.
     * @param key The key in the environmentVariables map
     * @param value The associated value in the environmentVariables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder environmentVariable(String key, String value) {
      if (this.environmentVariables == null) {
        this.environmentVariables = new LinkedHashMap<String, String>();
      }
      this.environmentVariables.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link _CreateApplicationRequest#getEnvironmentVariables() environmentVariables} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder environmentVariable(Map.Entry<String, ? extends String> entry) {
      if (this.environmentVariables == null) {
        this.environmentVariables = new LinkedHashMap<String, String>();
      }
      String k = entry.getKey();
      String v = entry.getValue();
      this.environmentVariables.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link _CreateApplicationRequest#getEnvironmentVariables() environmentVariables} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param environmentVariables The entries that will be added to the environmentVariables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder environmentVariables(@Nullable Map<String, ? extends String> environmentVariables) {
      if (environmentVariables == null) {
        this.environmentVariables = null;
        return this;
      }
      this.environmentVariables = new LinkedHashMap<String, String>();
      return putAllEnvironmentVariables(environmentVariables);
    }

    /**
     * Put all mappings from the specified map as entries to {@link _CreateApplicationRequest#getEnvironmentVariables() environmentVariables} map. Nulls are not permitted
     * @param environmentVariables The entries that will be added to the environmentVariables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllEnvironmentVariables(Map<String, ? extends String> environmentVariables) {
      if (this.environmentVariables == null) {
        this.environmentVariables = new LinkedHashMap<String, String>();
      }
      for (Map.Entry<String, ? extends String> entry : environmentVariables.entrySet()) {
        String k = entry.getKey();
        String v = entry.getValue();
        this.environmentVariables.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateApplicationRequest#getLifecycle() lifecycle} attribute.
     * @param lifecycle The value for lifecycle (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder lifecycle(@Nullable Lifecycle lifecycle) {
      this.lifecycle = lifecycle;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateApplicationRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateApplicationRequest#getRelationships() relationships} attribute.
     * @param relationships The value for relationships 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder relationships(ApplicationRelationships relationships) {
      this.relationships = Objects.requireNonNull(relationships, "relationships");
      initBits &= ~INIT_BIT_RELATIONSHIPS;
      return this;
    }

    /**
     * Builds a new {@link CreateApplicationRequest CreateApplicationRequest}.
     * @return An immutable instance of CreateApplicationRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CreateApplicationRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CreateApplicationRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_RELATIONSHIPS) != 0) attributes.add("relationships");
      return "Cannot build CreateApplicationRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
