package org.cloudfoundry.client.v3.applications;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.client.v3.Link;

/**
 * The response payload for the Get Application Environment Variables operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_GetApplicationEnvironmentVariablesResponse"})
public final class GetApplicationEnvironmentVariablesResponse
    extends org.cloudfoundry.client.v3.applications._GetApplicationEnvironmentVariablesResponse {
  private final Map<String, Link> links;
  private final Map<String, String> vars;

  private GetApplicationEnvironmentVariablesResponse(GetApplicationEnvironmentVariablesResponse.Builder builder) {
    this.links = createUnmodifiableMap(false, false, builder.links);
    this.vars = createUnmodifiableMap(false, false, builder.vars);
  }

  /**
   * The links
   */
  @JsonProperty("links")
  @Override
  public Map<String, Link> getLinks() {
    return links;
  }

  /**
   * The application's environment variables
   */
  @JsonProperty("var")
  @Override
  public Map<String, String> getVars() {
    return vars;
  }

  /**
   * This instance is equal to all instances of {@code GetApplicationEnvironmentVariablesResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetApplicationEnvironmentVariablesResponse
        && equalTo((GetApplicationEnvironmentVariablesResponse) another);
  }

  private boolean equalTo(GetApplicationEnvironmentVariablesResponse another) {
    return links.equals(another.links)
        && vars.equals(another.vars);
  }

  /**
   * Computes a hash code from attributes: {@code links}, {@code vars}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + links.hashCode();
    h += (h << 5) + vars.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetApplicationEnvironmentVariablesResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetApplicationEnvironmentVariablesResponse{"
        + "links=" + links
        + ", vars=" + vars
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      extends org.cloudfoundry.client.v3.applications._GetApplicationEnvironmentVariablesResponse {
    Map<String, Link> links = Collections.emptyMap();
    Map<String, String> vars = Collections.emptyMap();
    @JsonProperty("links")
    public void setLinks(Map<String, Link> links) {
      this.links = links;
    }
    @JsonProperty("var")
    public void setVars(Map<String, String> vars) {
      this.vars = vars;
    }
    @Override
    public Map<String, Link> getLinks() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, String> getVars() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static GetApplicationEnvironmentVariablesResponse fromJson(Json json) {
    GetApplicationEnvironmentVariablesResponse.Builder builder = GetApplicationEnvironmentVariablesResponse.builder();
    if (json.links != null) {
      builder.putAllLinks(json.links);
    }
    if (json.vars != null) {
      builder.putAllVars(json.vars);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link GetApplicationEnvironmentVariablesResponse GetApplicationEnvironmentVariablesResponse}.
   * @return A new GetApplicationEnvironmentVariablesResponse builder
   */
  public static GetApplicationEnvironmentVariablesResponse.Builder builder() {
    return new GetApplicationEnvironmentVariablesResponse.Builder();
  }

  /**
   * Builds instances of type {@link GetApplicationEnvironmentVariablesResponse GetApplicationEnvironmentVariablesResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private Map<String, Link> links = new LinkedHashMap<String, Link>();
    private Map<String, String> vars = new LinkedHashMap<String, String>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.applications.EnvironmentVariables} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(EnvironmentVariables instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetApplicationEnvironmentVariablesResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetApplicationEnvironmentVariablesResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _GetApplicationEnvironmentVariablesResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetApplicationEnvironmentVariablesResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof EnvironmentVariables) {
        EnvironmentVariables instance = (EnvironmentVariables) object;
        putAllLinks(instance.getLinks());
        putAllVars(instance.getVars());
      }
    }

    /**
     * Put one entry to the {@link _GetApplicationEnvironmentVariablesResponse#getLinks() links} map.
     * @param key The key in the links map
     * @param value The associated value in the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(String key, Link value) {
      this.links.put(
          Objects.requireNonNull(key, "links key"),
          Objects.requireNonNull(value, "links value"));
      return this;
    }

    /**
     * Put one entry to the {@link _GetApplicationEnvironmentVariablesResponse#getLinks() links} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(Map.Entry<String, ? extends Link> entry) {
      String k = entry.getKey();
      Link v = entry.getValue();
      this.links.put(
          Objects.requireNonNull(k, "links key"),
          Objects.requireNonNull(v, "links value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link _GetApplicationEnvironmentVariablesResponse#getLinks() links} map. Nulls are not permitted
     * @param links The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("links")
    public final Builder links(Map<String, ? extends Link> links) {
      this.links.clear();
      return putAllLinks(links);
    }

    /**
     * Put all mappings from the specified map as entries to {@link _GetApplicationEnvironmentVariablesResponse#getLinks() links} map. Nulls are not permitted
     * @param links The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllLinks(Map<String, ? extends Link> links) {
      for (Map.Entry<String, ? extends Link> entry : links.entrySet()) {
        String k = entry.getKey();
        Link v = entry.getValue();
        this.links.put(
            Objects.requireNonNull(k, "links key"),
            Objects.requireNonNull(v, "links value"));
      }
      return this;
    }

    /**
     * Put one entry to the {@link _GetApplicationEnvironmentVariablesResponse#getVars() vars} map.
     * @param key The key in the vars map
     * @param value The associated value in the vars map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder var(String key, String value) {
      this.vars.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link _GetApplicationEnvironmentVariablesResponse#getVars() vars} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder var(Map.Entry<String, ? extends String> entry) {
      String k = entry.getKey();
      String v = entry.getValue();
      this.vars.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link _GetApplicationEnvironmentVariablesResponse#getVars() vars} map. Nulls are not permitted
     * @param vars The entries that will be added to the vars map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("var")
    public final Builder vars(Map<String, ? extends String> vars) {
      this.vars.clear();
      return putAllVars(vars);
    }

    /**
     * Put all mappings from the specified map as entries to {@link _GetApplicationEnvironmentVariablesResponse#getVars() vars} map. Nulls are not permitted
     * @param vars The entries that will be added to the vars map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllVars(Map<String, ? extends String> vars) {
      for (Map.Entry<String, ? extends String> entry : vars.entrySet()) {
        String k = entry.getKey();
        String v = entry.getValue();
        this.vars.put(k, v);
      }
      return this;
    }

    /**
     * Builds a new {@link GetApplicationEnvironmentVariablesResponse GetApplicationEnvironmentVariablesResponse}.
     * @return An immutable instance of GetApplicationEnvironmentVariablesResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetApplicationEnvironmentVariablesResponse build() {
      return new GetApplicationEnvironmentVariablesResponse(this);
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
