package org.cloudfoundry.client.v3.applications;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.client.v3.*;
import org.cloudfoundry.client.v3.Lifecycle;
import org.cloudfoundry.client.v3.Resource;

/**
 * The response payload for the Update Application operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_UpdateApplicationResponse"})
public final class UpdateApplicationResponse
    extends org.cloudfoundry.client.v3.applications._UpdateApplicationResponse {
  private final Lifecycle lifecycle;
  private final String name;
  private final ApplicationState state;
  private final String createdAt;
  private final String id;
  private final Map<String, Link> links;
  private final String updatedAt;

  private UpdateApplicationResponse(UpdateApplicationResponse.Builder builder) {
    this.lifecycle = builder.lifecycle;
    this.name = builder.name;
    this.state = builder.state;
    this.createdAt = builder.createdAt;
    this.id = builder.id;
    this.links = createUnmodifiableMap(false, false, builder.links);
    this.updatedAt = builder.updatedAt;
  }

  /**
   * The lifecycle
   */
  @JsonProperty("lifecycle")
  @Override
  public Lifecycle getLifecycle() {
    return lifecycle;
  }

  /**
   * The name
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * The state
   */
  @JsonProperty("state")
  @Override
  public ApplicationState getState() {
    return state;
  }

  /**
   * When the resource was created
   */
  @JsonProperty("created_at")
  @Override
  public String getCreatedAt() {
    return createdAt;
  }

  /**
   * The resource's id
   */
  @JsonProperty("guid")
  @Override
  public String getId() {
    return id;
  }

  /**
   * Links to related resources and actions for the resource
   */
  @JsonProperty("links")
  @Override
  public Map<String, Link> getLinks() {
    return links;
  }

  /**
   * When the resource was last updated
   */
  @JsonProperty("updated_at")
  @Override
  public String getUpdatedAt() {
    return updatedAt;
  }

  /**
   * This instance is equal to all instances of {@code UpdateApplicationResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateApplicationResponse
        && equalTo((UpdateApplicationResponse) another);
  }

  private boolean equalTo(UpdateApplicationResponse another) {
    return lifecycle.equals(another.lifecycle)
        && name.equals(another.name)
        && state.equals(another.state)
        && createdAt.equals(another.createdAt)
        && id.equals(another.id)
        && links.equals(another.links)
        && updatedAt.equals(another.updatedAt);
  }

  /**
   * Computes a hash code from attributes: {@code lifecycle}, {@code name}, {@code state}, {@code createdAt}, {@code id}, {@code links}, {@code updatedAt}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + lifecycle.hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + state.hashCode();
    h += (h << 5) + createdAt.hashCode();
    h += (h << 5) + id.hashCode();
    h += (h << 5) + links.hashCode();
    h += (h << 5) + updatedAt.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateApplicationResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateApplicationResponse{"
        + "lifecycle=" + lifecycle
        + ", name=" + name
        + ", state=" + state
        + ", createdAt=" + createdAt
        + ", id=" + id
        + ", links=" + links
        + ", updatedAt=" + updatedAt
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.applications._UpdateApplicationResponse {
    Lifecycle lifecycle;
    String name;
    ApplicationState state;
    String createdAt;
    String id;
    Map<String, Link> links = Collections.emptyMap();
    String updatedAt;
    @JsonProperty("lifecycle")
    public void setLifecycle(Lifecycle lifecycle) {
      this.lifecycle = lifecycle;
    }
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("state")
    public void setState(ApplicationState state) {
      this.state = state;
    }
    @JsonProperty("created_at")
    public void setCreatedAt(String createdAt) {
      this.createdAt = createdAt;
    }
    @JsonProperty("guid")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("links")
    public void setLinks(Map<String, Link> links) {
      this.links = links;
    }
    @JsonProperty("updated_at")
    public void setUpdatedAt(String updatedAt) {
      this.updatedAt = updatedAt;
    }
    @Override
    public Lifecycle getLifecycle() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public ApplicationState getState() { throw new UnsupportedOperationException(); }
    @Override
    public String getCreatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Link> getLinks() { throw new UnsupportedOperationException(); }
    @Override
    public String getUpdatedAt() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static UpdateApplicationResponse fromJson(Json json) {
    UpdateApplicationResponse.Builder builder = UpdateApplicationResponse.builder();
    if (json.lifecycle != null) {
      builder.lifecycle(json.lifecycle);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.state != null) {
      builder.state(json.state);
    }
    if (json.createdAt != null) {
      builder.createdAt(json.createdAt);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.links != null) {
      builder.putAllLinks(json.links);
    }
    if (json.updatedAt != null) {
      builder.updatedAt(json.updatedAt);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link UpdateApplicationResponse UpdateApplicationResponse}.
   * @return A new UpdateApplicationResponse builder
   */
  public static UpdateApplicationResponse.Builder builder() {
    return new UpdateApplicationResponse.Builder();
  }

  /**
   * Builds instances of type {@link UpdateApplicationResponse UpdateApplicationResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_LIFECYCLE = 0x1L;
    private static final long INIT_BIT_NAME = 0x2L;
    private static final long INIT_BIT_STATE = 0x4L;
    private static final long INIT_BIT_CREATED_AT = 0x8L;
    private static final long INIT_BIT_ID = 0x10L;
    private static final long INIT_BIT_UPDATED_AT = 0x20L;
    private long initBits = 0x3fL;

    private Lifecycle lifecycle;
    private String name;
    private ApplicationState state;
    private String createdAt;
    private String id;
    private Map<String, Link> links = new LinkedHashMap<String, Link>();
    private String updatedAt;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.Resource} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Resource instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.applications.Application} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Application instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateApplicationResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateApplicationResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _UpdateApplicationResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UpdateApplicationResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof Resource) {
        Resource instance = (Resource) object;
        createdAt(instance.getCreatedAt());
        putAllLinks(instance.getLinks());
        id(instance.getId());
        updatedAt(instance.getUpdatedAt());
      }
      if (object instanceof Application) {
        Application instance = (Application) object;
        lifecycle(instance.getLifecycle());
        name(instance.getName());
        state(instance.getState());
      }
    }

    /**
     * Initializes the value for the {@link _UpdateApplicationResponse#getLifecycle() lifecycle} attribute.
     * @param lifecycle The value for lifecycle 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("lifecycle")
    public final Builder lifecycle(Lifecycle lifecycle) {
      this.lifecycle = Objects.requireNonNull(lifecycle, "lifecycle");
      initBits &= ~INIT_BIT_LIFECYCLE;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateApplicationResponse#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateApplicationResponse#getState() state} attribute.
     * @param state The value for state 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("state")
    public final Builder state(ApplicationState state) {
      this.state = Objects.requireNonNull(state, "state");
      initBits &= ~INIT_BIT_STATE;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateApplicationResponse#getCreatedAt() createdAt} attribute.
     * @param createdAt The value for createdAt 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("created_at")
    public final Builder createdAt(String createdAt) {
      this.createdAt = Objects.requireNonNull(createdAt, "createdAt");
      initBits &= ~INIT_BIT_CREATED_AT;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateApplicationResponse#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("guid")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Put one entry to the {@link _UpdateApplicationResponse#getLinks() links} map.
     * @param key The key in the links map
     * @param value The associated value in the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(String key, Link value) {
      this.links.put(
          Objects.requireNonNull(key, "links key"),
          Objects.requireNonNull(value, "links value"));
      return this;
    }

    /**
     * Put one entry to the {@link _UpdateApplicationResponse#getLinks() links} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(Map.Entry<String, ? extends Link> entry) {
      String k = entry.getKey();
      Link v = entry.getValue();
      this.links.put(
          Objects.requireNonNull(k, "links key"),
          Objects.requireNonNull(v, "links value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link _UpdateApplicationResponse#getLinks() links} map. Nulls are not permitted
     * @param links The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("links")
    public final Builder links(Map<String, ? extends Link> links) {
      this.links.clear();
      return putAllLinks(links);
    }

    /**
     * Put all mappings from the specified map as entries to {@link _UpdateApplicationResponse#getLinks() links} map. Nulls are not permitted
     * @param links The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllLinks(Map<String, ? extends Link> links) {
      for (Map.Entry<String, ? extends Link> entry : links.entrySet()) {
        String k = entry.getKey();
        Link v = entry.getValue();
        this.links.put(
            Objects.requireNonNull(k, "links key"),
            Objects.requireNonNull(v, "links value"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateApplicationResponse#getUpdatedAt() updatedAt} attribute.
     * @param updatedAt The value for updatedAt 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("updated_at")
    public final Builder updatedAt(String updatedAt) {
      this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt");
      initBits &= ~INIT_BIT_UPDATED_AT;
      return this;
    }

    /**
     * Builds a new {@link UpdateApplicationResponse UpdateApplicationResponse}.
     * @return An immutable instance of UpdateApplicationResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateApplicationResponse build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UpdateApplicationResponse(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_LIFECYCLE) != 0) attributes.add("lifecycle");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_STATE) != 0) attributes.add("state");
      if ((initBits & INIT_BIT_CREATED_AT) != 0) attributes.add("createdAt");
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_UPDATED_AT) != 0) attributes.add("updatedAt");
      return "Cannot build UpdateApplicationResponse, some of required attributes are not set " + attributes;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
