package org.cloudfoundry.client.v3.builds;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request payload for the Get Build operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_GetBuildRequest"})
public final class GetBuildRequest extends org.cloudfoundry.client.v3.builds._GetBuildRequest {
  private final String buildId;

  private GetBuildRequest(GetBuildRequest.Builder builder) {
    this.buildId = builder.buildId;
  }

  /**
   * The build id
   */
  @Override
  public String getBuildId() {
    return buildId;
  }

  /**
   * This instance is equal to all instances of {@code GetBuildRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetBuildRequest
        && equalTo((GetBuildRequest) another);
  }

  private boolean equalTo(GetBuildRequest another) {
    return buildId.equals(another.buildId);
  }

  /**
   * Computes a hash code from attributes: {@code buildId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + buildId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetBuildRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetBuildRequest{"
        + "buildId=" + buildId
        + "}";
  }

  /**
   * Creates a builder for {@link GetBuildRequest GetBuildRequest}.
   * @return A new GetBuildRequest builder
   */
  public static GetBuildRequest.Builder builder() {
    return new GetBuildRequest.Builder();
  }

  /**
   * Builds instances of type {@link GetBuildRequest GetBuildRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_BUILD_ID = 0x1L;
    private long initBits = 0x1L;

    private String buildId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetBuildRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetBuildRequest instance) {
      return from((_GetBuildRequest) instance);
    }

    /**
     * Copy abstract value type {@code _GetBuildRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetBuildRequest instance) {
      Objects.requireNonNull(instance, "instance");
      buildId(instance.getBuildId());
      return this;
    }

    /**
     * Initializes the value for the {@link _GetBuildRequest#getBuildId() buildId} attribute.
     * @param buildId The value for buildId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder buildId(String buildId) {
      this.buildId = Objects.requireNonNull(buildId, "buildId");
      initBits &= ~INIT_BIT_BUILD_ID;
      return this;
    }

    /**
     * Builds a new {@link GetBuildRequest GetBuildRequest}.
     * @return An immutable instance of GetBuildRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetBuildRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetBuildRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_BUILD_ID) != 0) attributes.add("buildId");
      return "Cannot build GetBuildRequest, some of required attributes are not set " + attributes;
    }
  }
}
