package org.cloudfoundry.client.v3.isolationsegments;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.client.v3.Relationship;

/**
 * The request payload for the Entitle one or more Organizations for an Isolation Segment operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_AddIsolationSegmentOrganizationEntitlementRequest"})
public final class AddIsolationSegmentOrganizationEntitlementRequest
    extends org.cloudfoundry.client.v3.isolationsegments._AddIsolationSegmentOrganizationEntitlementRequest {
  private final List<Relationship> data;
  private final String isolationSegmentId;

  private AddIsolationSegmentOrganizationEntitlementRequest(AddIsolationSegmentOrganizationEntitlementRequest.Builder builder) {
    this.data = createUnmodifiableList(true, builder.data);
    this.isolationSegmentId = builder.isolationSegmentId;
  }

  /**
   * The organizations to add entitlement to
   */
  @Override
  public List<Relationship> getData() {
    return data;
  }

  /**
   * The isolation segment id
   */
  @Override
  public String getIsolationSegmentId() {
    return isolationSegmentId;
  }

  /**
   * This instance is equal to all instances of {@code AddIsolationSegmentOrganizationEntitlementRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof AddIsolationSegmentOrganizationEntitlementRequest
        && equalTo((AddIsolationSegmentOrganizationEntitlementRequest) another);
  }

  private boolean equalTo(AddIsolationSegmentOrganizationEntitlementRequest another) {
    return data.equals(another.data)
        && isolationSegmentId.equals(another.isolationSegmentId);
  }

  /**
   * Computes a hash code from attributes: {@code data}, {@code isolationSegmentId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + data.hashCode();
    h += (h << 5) + isolationSegmentId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code AddIsolationSegmentOrganizationEntitlementRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "AddIsolationSegmentOrganizationEntitlementRequest{"
        + "data=" + data
        + ", isolationSegmentId=" + isolationSegmentId
        + "}";
  }

  /**
   * Creates a builder for {@link AddIsolationSegmentOrganizationEntitlementRequest AddIsolationSegmentOrganizationEntitlementRequest}.
   * @return A new AddIsolationSegmentOrganizationEntitlementRequest builder
   */
  public static AddIsolationSegmentOrganizationEntitlementRequest.Builder builder() {
    return new AddIsolationSegmentOrganizationEntitlementRequest.Builder();
  }

  /**
   * Builds instances of type {@link AddIsolationSegmentOrganizationEntitlementRequest AddIsolationSegmentOrganizationEntitlementRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_ISOLATION_SEGMENT_ID = 0x1L;
    private long initBits = 0x1L;

    private List<Relationship> data = new ArrayList<Relationship>();
    private String isolationSegmentId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AddIsolationSegmentOrganizationEntitlementRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AddIsolationSegmentOrganizationEntitlementRequest instance) {
      return from((_AddIsolationSegmentOrganizationEntitlementRequest) instance);
    }

    /**
     * Copy abstract value type {@code _AddIsolationSegmentOrganizationEntitlementRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_AddIsolationSegmentOrganizationEntitlementRequest instance) {
      Objects.requireNonNull(instance, "instance");
      addAllData(instance.getData());
      isolationSegmentId(instance.getIsolationSegmentId());
      return this;
    }

    /**
     * Adds one element to {@link _AddIsolationSegmentOrganizationEntitlementRequest#getData() data} list.
     * @param element A data element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder data(Relationship element) {
      this.data.add(Objects.requireNonNull(element, "data element"));
      return this;
    }

    /**
     * Adds elements to {@link _AddIsolationSegmentOrganizationEntitlementRequest#getData() data} list.
     * @param elements An array of data elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder data(Relationship... elements) {
      for (Relationship element : elements) {
        this.data.add(Objects.requireNonNull(element, "data element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _AddIsolationSegmentOrganizationEntitlementRequest#getData() data} list.
     * @param elements An iterable of data elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder data(Iterable<? extends Relationship> elements) {
      this.data.clear();
      return addAllData(elements);
    }

    /**
     * Adds elements to {@link _AddIsolationSegmentOrganizationEntitlementRequest#getData() data} list.
     * @param elements An iterable of data elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllData(Iterable<? extends Relationship> elements) {
      for (Relationship element : elements) {
        this.data.add(Objects.requireNonNull(element, "data element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _AddIsolationSegmentOrganizationEntitlementRequest#getIsolationSegmentId() isolationSegmentId} attribute.
     * @param isolationSegmentId The value for isolationSegmentId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder isolationSegmentId(String isolationSegmentId) {
      this.isolationSegmentId = Objects.requireNonNull(isolationSegmentId, "isolationSegmentId");
      initBits &= ~INIT_BIT_ISOLATION_SEGMENT_ID;
      return this;
    }

    /**
     * Builds a new {@link AddIsolationSegmentOrganizationEntitlementRequest AddIsolationSegmentOrganizationEntitlementRequest}.
     * @return An immutable instance of AddIsolationSegmentOrganizationEntitlementRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public AddIsolationSegmentOrganizationEntitlementRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new AddIsolationSegmentOrganizationEntitlementRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_ISOLATION_SEGMENT_ID) != 0) attributes.add("isolationSegmentId");
      return "Cannot build AddIsolationSegmentOrganizationEntitlementRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
