package org.cloudfoundry.client.v3.organizations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.*;
import org.cloudfoundry.client.v3.Relationship;
import org.cloudfoundry.client.v3.RelationshipResponse;

/**
 * The response payload for the Assign Default Isolation Segment operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_AssignOrganizationDefaultIsolationSegmentResponse"})
public final class AssignOrganizationDefaultIsolationSegmentResponse
    extends org.cloudfoundry.client.v3.organizations._AssignOrganizationDefaultIsolationSegmentResponse {
  private final @Nullable Relationship data;
  private final Map<String, Link> links;

  private AssignOrganizationDefaultIsolationSegmentResponse(AssignOrganizationDefaultIsolationSegmentResponse.Builder builder) {
    this.data = builder.data;
    this.links = createUnmodifiableMap(false, false, builder.links);
  }

  /**
   * The relationship
   */
  @JsonProperty("data")
  @Override
  public @Nullable Relationship getData() {
    return data;
  }

  /**
   * The links
   */
  @JsonProperty("links")
  @Override
  public Map<String, Link> getLinks() {
    return links;
  }

  /**
   * This instance is equal to all instances of {@code AssignOrganizationDefaultIsolationSegmentResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof AssignOrganizationDefaultIsolationSegmentResponse
        && equalTo((AssignOrganizationDefaultIsolationSegmentResponse) another);
  }

  private boolean equalTo(AssignOrganizationDefaultIsolationSegmentResponse another) {
    return Objects.equals(data, another.data)
        && links.equals(another.links);
  }

  /**
   * Computes a hash code from attributes: {@code data}, {@code links}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(data);
    h += (h << 5) + links.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code AssignOrganizationDefaultIsolationSegmentResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "AssignOrganizationDefaultIsolationSegmentResponse{"
        + "data=" + data
        + ", links=" + links
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      extends org.cloudfoundry.client.v3.organizations._AssignOrganizationDefaultIsolationSegmentResponse {
    Relationship data;
    Map<String, Link> links = Collections.emptyMap();
    @JsonProperty("data")
    public void setData(@Nullable Relationship data) {
      this.data = data;
    }
    @JsonProperty("links")
    public void setLinks(Map<String, Link> links) {
      this.links = links;
    }
    @Override
    public Relationship getData() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Link> getLinks() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static AssignOrganizationDefaultIsolationSegmentResponse fromJson(Json json) {
    AssignOrganizationDefaultIsolationSegmentResponse.Builder builder = AssignOrganizationDefaultIsolationSegmentResponse.builder();
    if (json.data != null) {
      builder.data(json.data);
    }
    if (json.links != null) {
      builder.putAllLinks(json.links);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link AssignOrganizationDefaultIsolationSegmentResponse AssignOrganizationDefaultIsolationSegmentResponse}.
   * @return A new AssignOrganizationDefaultIsolationSegmentResponse builder
   */
  public static AssignOrganizationDefaultIsolationSegmentResponse.Builder builder() {
    return new AssignOrganizationDefaultIsolationSegmentResponse.Builder();
  }

  /**
   * Builds instances of type {@link AssignOrganizationDefaultIsolationSegmentResponse AssignOrganizationDefaultIsolationSegmentResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private Relationship data;
    private Map<String, Link> links = new LinkedHashMap<String, Link>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.RelationshipResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RelationshipResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code AssignOrganizationDefaultIsolationSegmentResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AssignOrganizationDefaultIsolationSegmentResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _AssignOrganizationDefaultIsolationSegmentResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_AssignOrganizationDefaultIsolationSegmentResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof RelationshipResponse) {
        RelationshipResponse instance = (RelationshipResponse) object;
        Relationship dataValue = instance.getData();
        if (dataValue != null) {
          data(dataValue);
        }
        putAllLinks(instance.getLinks());
      }
    }

    /**
     * Initializes the value for the {@link _AssignOrganizationDefaultIsolationSegmentResponse#getData() data} attribute.
     * @param data The value for data (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("data")
    public final Builder data(@Nullable Relationship data) {
      this.data = data;
      return this;
    }

    /**
     * Put one entry to the {@link _AssignOrganizationDefaultIsolationSegmentResponse#getLinks() links} map.
     * @param key The key in the links map
     * @param value The associated value in the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(String key, Link value) {
      this.links.put(
          Objects.requireNonNull(key, "links key"),
          Objects.requireNonNull(value, "links value"));
      return this;
    }

    /**
     * Put one entry to the {@link _AssignOrganizationDefaultIsolationSegmentResponse#getLinks() links} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(Map.Entry<String, ? extends Link> entry) {
      String k = entry.getKey();
      Link v = entry.getValue();
      this.links.put(
          Objects.requireNonNull(k, "links key"),
          Objects.requireNonNull(v, "links value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link _AssignOrganizationDefaultIsolationSegmentResponse#getLinks() links} map. Nulls are not permitted
     * @param links The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("links")
    public final Builder links(Map<String, ? extends Link> links) {
      this.links.clear();
      return putAllLinks(links);
    }

    /**
     * Put all mappings from the specified map as entries to {@link _AssignOrganizationDefaultIsolationSegmentResponse#getLinks() links} map. Nulls are not permitted
     * @param links The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllLinks(Map<String, ? extends Link> links) {
      for (Map.Entry<String, ? extends Link> entry : links.entrySet()) {
        String k = entry.getKey();
        Link v = entry.getValue();
        this.links.put(
            Objects.requireNonNull(k, "links key"),
            Objects.requireNonNull(v, "links value"));
      }
      return this;
    }

    /**
     * Builds a new {@link AssignOrganizationDefaultIsolationSegmentResponse AssignOrganizationDefaultIsolationSegmentResponse}.
     * @return An immutable instance of AssignOrganizationDefaultIsolationSegmentResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public AssignOrganizationDefaultIsolationSegmentResponse build() {
      return new AssignOrganizationDefaultIsolationSegmentResponse(this);
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
