package org.cloudfoundry.client.v3.packages;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The request payload for the Create Package operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_CreatePackageRequest"})
public final class CreatePackageRequest extends org.cloudfoundry.client.v3.packages._CreatePackageRequest {
  private final @Nullable PackageData data;
  private final PackageRelationships relationships;
  private final PackageType type;

  private CreatePackageRequest(CreatePackageRequest.Builder builder) {
    this.data = builder.data;
    this.relationships = builder.relationships;
    this.type = builder.type;
  }

  /**
   * The datas
   */
  @Override
  public @Nullable PackageData getData() {
    return data;
  }

  /**
   * The relationships
   */
  @Override
  public PackageRelationships getRelationships() {
    return relationships;
  }

  /**
   * The type
   */
  @Override
  public PackageType getType() {
    return type;
  }

  /**
   * This instance is equal to all instances of {@code CreatePackageRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CreatePackageRequest
        && equalTo((CreatePackageRequest) another);
  }

  private boolean equalTo(CreatePackageRequest another) {
    return Objects.equals(data, another.data)
        && relationships.equals(another.relationships)
        && type.equals(another.type);
  }

  /**
   * Computes a hash code from attributes: {@code data}, {@code relationships}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(data);
    h += (h << 5) + relationships.hashCode();
    h += (h << 5) + type.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CreatePackageRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CreatePackageRequest{"
        + "data=" + data
        + ", relationships=" + relationships
        + ", type=" + type
        + "}";
  }

  /**
   * Creates a builder for {@link CreatePackageRequest CreatePackageRequest}.
   * @return A new CreatePackageRequest builder
   */
  public static CreatePackageRequest.Builder builder() {
    return new CreatePackageRequest.Builder();
  }

  /**
   * Builds instances of type {@link CreatePackageRequest CreatePackageRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_RELATIONSHIPS = 0x1L;
    private static final long INIT_BIT_TYPE = 0x2L;
    private long initBits = 0x3L;

    private PackageData data;
    private PackageRelationships relationships;
    private PackageType type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreatePackageRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CreatePackageRequest instance) {
      return from((_CreatePackageRequest) instance);
    }

    /**
     * Copy abstract value type {@code _CreatePackageRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CreatePackageRequest instance) {
      Objects.requireNonNull(instance, "instance");
      PackageData dataValue = instance.getData();
      if (dataValue != null) {
        data(dataValue);
      }
      relationships(instance.getRelationships());
      type(instance.getType());
      return this;
    }

    /**
     * Initializes the value for the {@link _CreatePackageRequest#getData() data} attribute.
     * @param data The value for data (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder data(@Nullable PackageData data) {
      this.data = data;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreatePackageRequest#getRelationships() relationships} attribute.
     * @param relationships The value for relationships 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder relationships(PackageRelationships relationships) {
      this.relationships = Objects.requireNonNull(relationships, "relationships");
      initBits &= ~INIT_BIT_RELATIONSHIPS;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreatePackageRequest#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder type(PackageType type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Builds a new {@link CreatePackageRequest CreatePackageRequest}.
     * @return An immutable instance of CreatePackageRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CreatePackageRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CreatePackageRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_RELATIONSHIPS) != 0) attributes.add("relationships");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build CreatePackageRequest, some of required attributes are not set " + attributes;
    }
  }
}
