package org.cloudfoundry.client.v3.processes;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.client.v3.*;
import org.cloudfoundry.client.v3.Resource;

/**
 * The response payload for the Update Process operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_UpdateProcessResponse"})
public final class UpdateProcessResponse extends org.cloudfoundry.client.v3.processes._UpdateProcessResponse {
  private final String type;
  private final String command;
  private final Integer instances;
  private final Integer memoryInMb;
  private final Integer diskInMb;
  private final HealthCheck healthCheck;
  private final String createdAt;
  private final String id;
  private final Map<String, Link> links;
  private final String updatedAt;

  private UpdateProcessResponse(UpdateProcessResponse.Builder builder) {
    this.type = builder.type;
    this.command = builder.command;
    this.instances = builder.instances;
    this.memoryInMb = builder.memoryInMb;
    this.diskInMb = builder.diskInMb;
    this.healthCheck = builder.healthCheck;
    this.createdAt = builder.createdAt;
    this.id = builder.id;
    this.links = createUnmodifiableMap(false, false, builder.links);
    this.updatedAt = builder.updatedAt;
  }

  /**
   * The type
   */
  @JsonProperty("type")
  @Override
  public String getType() {
    return type;
  }

  /**
   * The command
   */
  @JsonProperty("command")
  @Override
  public String getCommand() {
    return command;
  }

  /**
   * The instances
   */
  @JsonProperty("instances")
  @Override
  public Integer getInstances() {
    return instances;
  }

  /**
   * The memory in megabytes
   */
  @JsonProperty("memory_in_mb")
  @Override
  public Integer getMemoryInMb() {
    return memoryInMb;
  }

  /**
   * The disk in megabytes
   */
  @JsonProperty("disk_in_mb")
  @Override
  public Integer getDiskInMb() {
    return diskInMb;
  }

  /**
   * The health check
   */
  @JsonProperty("health_check")
  @Override
  public HealthCheck getHealthCheck() {
    return healthCheck;
  }

  /**
   * When the resource was created
   */
  @JsonProperty("created_at")
  @Override
  public String getCreatedAt() {
    return createdAt;
  }

  /**
   * The resource's id
   */
  @JsonProperty("guid")
  @Override
  public String getId() {
    return id;
  }

  /**
   * Links to related resources and actions for the resource
   */
  @JsonProperty("links")
  @Override
  public Map<String, Link> getLinks() {
    return links;
  }

  /**
   * When the resource was last updated
   */
  @JsonProperty("updated_at")
  @Override
  public String getUpdatedAt() {
    return updatedAt;
  }

  /**
   * This instance is equal to all instances of {@code UpdateProcessResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateProcessResponse
        && equalTo((UpdateProcessResponse) another);
  }

  private boolean equalTo(UpdateProcessResponse another) {
    return type.equals(another.type)
        && command.equals(another.command)
        && instances.equals(another.instances)
        && memoryInMb.equals(another.memoryInMb)
        && diskInMb.equals(another.diskInMb)
        && healthCheck.equals(another.healthCheck)
        && createdAt.equals(another.createdAt)
        && id.equals(another.id)
        && links.equals(another.links)
        && updatedAt.equals(another.updatedAt);
  }

  /**
   * Computes a hash code from attributes: {@code type}, {@code command}, {@code instances}, {@code memoryInMb}, {@code diskInMb}, {@code healthCheck}, {@code createdAt}, {@code id}, {@code links}, {@code updatedAt}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + type.hashCode();
    h += (h << 5) + command.hashCode();
    h += (h << 5) + instances.hashCode();
    h += (h << 5) + memoryInMb.hashCode();
    h += (h << 5) + diskInMb.hashCode();
    h += (h << 5) + healthCheck.hashCode();
    h += (h << 5) + createdAt.hashCode();
    h += (h << 5) + id.hashCode();
    h += (h << 5) + links.hashCode();
    h += (h << 5) + updatedAt.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateProcessResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateProcessResponse{"
        + "type=" + type
        + ", command=" + command
        + ", instances=" + instances
        + ", memoryInMb=" + memoryInMb
        + ", diskInMb=" + diskInMb
        + ", healthCheck=" + healthCheck
        + ", createdAt=" + createdAt
        + ", id=" + id
        + ", links=" + links
        + ", updatedAt=" + updatedAt
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.processes._UpdateProcessResponse {
    String type;
    String command;
    Integer instances;
    Integer memoryInMb;
    Integer diskInMb;
    HealthCheck healthCheck;
    String createdAt;
    String id;
    Map<String, Link> links = Collections.emptyMap();
    String updatedAt;
    @JsonProperty("type")
    public void setType(String type) {
      this.type = type;
    }
    @JsonProperty("command")
    public void setCommand(String command) {
      this.command = command;
    }
    @JsonProperty("instances")
    public void setInstances(Integer instances) {
      this.instances = instances;
    }
    @JsonProperty("memory_in_mb")
    public void setMemoryInMb(Integer memoryInMb) {
      this.memoryInMb = memoryInMb;
    }
    @JsonProperty("disk_in_mb")
    public void setDiskInMb(Integer diskInMb) {
      this.diskInMb = diskInMb;
    }
    @JsonProperty("health_check")
    public void setHealthCheck(HealthCheck healthCheck) {
      this.healthCheck = healthCheck;
    }
    @JsonProperty("created_at")
    public void setCreatedAt(String createdAt) {
      this.createdAt = createdAt;
    }
    @JsonProperty("guid")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("links")
    public void setLinks(Map<String, Link> links) {
      this.links = links;
    }
    @JsonProperty("updated_at")
    public void setUpdatedAt(String updatedAt) {
      this.updatedAt = updatedAt;
    }
    @Override
    public String getType() { throw new UnsupportedOperationException(); }
    @Override
    public String getCommand() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getInstances() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getMemoryInMb() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getDiskInMb() { throw new UnsupportedOperationException(); }
    @Override
    public HealthCheck getHealthCheck() { throw new UnsupportedOperationException(); }
    @Override
    public String getCreatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Link> getLinks() { throw new UnsupportedOperationException(); }
    @Override
    public String getUpdatedAt() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static UpdateProcessResponse fromJson(Json json) {
    UpdateProcessResponse.Builder builder = UpdateProcessResponse.builder();
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.command != null) {
      builder.command(json.command);
    }
    if (json.instances != null) {
      builder.instances(json.instances);
    }
    if (json.memoryInMb != null) {
      builder.memoryInMb(json.memoryInMb);
    }
    if (json.diskInMb != null) {
      builder.diskInMb(json.diskInMb);
    }
    if (json.healthCheck != null) {
      builder.healthCheck(json.healthCheck);
    }
    if (json.createdAt != null) {
      builder.createdAt(json.createdAt);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.links != null) {
      builder.putAllLinks(json.links);
    }
    if (json.updatedAt != null) {
      builder.updatedAt(json.updatedAt);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link UpdateProcessResponse UpdateProcessResponse}.
   * @return A new UpdateProcessResponse builder
   */
  public static UpdateProcessResponse.Builder builder() {
    return new UpdateProcessResponse.Builder();
  }

  /**
   * Builds instances of type {@link UpdateProcessResponse UpdateProcessResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_TYPE = 0x1L;
    private static final long INIT_BIT_COMMAND = 0x2L;
    private static final long INIT_BIT_INSTANCES = 0x4L;
    private static final long INIT_BIT_MEMORY_IN_MB = 0x8L;
    private static final long INIT_BIT_DISK_IN_MB = 0x10L;
    private static final long INIT_BIT_HEALTH_CHECK = 0x20L;
    private static final long INIT_BIT_CREATED_AT = 0x40L;
    private static final long INIT_BIT_ID = 0x80L;
    private static final long INIT_BIT_UPDATED_AT = 0x100L;
    private long initBits = 0x1ffL;

    private String type;
    private String command;
    private Integer instances;
    private Integer memoryInMb;
    private Integer diskInMb;
    private HealthCheck healthCheck;
    private String createdAt;
    private String id;
    private Map<String, Link> links = new LinkedHashMap<String, Link>();
    private String updatedAt;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.processes.Process} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Process instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.Resource} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Resource instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateProcessResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateProcessResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _UpdateProcessResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UpdateProcessResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof Process) {
        Process instance = (Process) object;
        diskInMb(instance.getDiskInMb());
        type(instance.getType());
        instances(instance.getInstances());
        memoryInMb(instance.getMemoryInMb());
        command(instance.getCommand());
        healthCheck(instance.getHealthCheck());
      }
      if (object instanceof Resource) {
        Resource instance = (Resource) object;
        createdAt(instance.getCreatedAt());
        putAllLinks(instance.getLinks());
        id(instance.getId());
        updatedAt(instance.getUpdatedAt());
      }
    }

    /**
     * Initializes the value for the {@link _UpdateProcessResponse#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type")
    public final Builder type(String type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateProcessResponse#getCommand() command} attribute.
     * @param command The value for command 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("command")
    public final Builder command(String command) {
      this.command = Objects.requireNonNull(command, "command");
      initBits &= ~INIT_BIT_COMMAND;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateProcessResponse#getInstances() instances} attribute.
     * @param instances The value for instances 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("instances")
    public final Builder instances(Integer instances) {
      this.instances = Objects.requireNonNull(instances, "instances");
      initBits &= ~INIT_BIT_INSTANCES;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateProcessResponse#getMemoryInMb() memoryInMb} attribute.
     * @param memoryInMb The value for memoryInMb 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("memory_in_mb")
    public final Builder memoryInMb(Integer memoryInMb) {
      this.memoryInMb = Objects.requireNonNull(memoryInMb, "memoryInMb");
      initBits &= ~INIT_BIT_MEMORY_IN_MB;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateProcessResponse#getDiskInMb() diskInMb} attribute.
     * @param diskInMb The value for diskInMb 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("disk_in_mb")
    public final Builder diskInMb(Integer diskInMb) {
      this.diskInMb = Objects.requireNonNull(diskInMb, "diskInMb");
      initBits &= ~INIT_BIT_DISK_IN_MB;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateProcessResponse#getHealthCheck() healthCheck} attribute.
     * @param healthCheck The value for healthCheck 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("health_check")
    public final Builder healthCheck(HealthCheck healthCheck) {
      this.healthCheck = Objects.requireNonNull(healthCheck, "healthCheck");
      initBits &= ~INIT_BIT_HEALTH_CHECK;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateProcessResponse#getCreatedAt() createdAt} attribute.
     * @param createdAt The value for createdAt 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("created_at")
    public final Builder createdAt(String createdAt) {
      this.createdAt = Objects.requireNonNull(createdAt, "createdAt");
      initBits &= ~INIT_BIT_CREATED_AT;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateProcessResponse#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("guid")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Put one entry to the {@link _UpdateProcessResponse#getLinks() links} map.
     * @param key The key in the links map
     * @param value The associated value in the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(String key, Link value) {
      this.links.put(
          Objects.requireNonNull(key, "links key"),
          Objects.requireNonNull(value, "links value"));
      return this;
    }

    /**
     * Put one entry to the {@link _UpdateProcessResponse#getLinks() links} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(Map.Entry<String, ? extends Link> entry) {
      String k = entry.getKey();
      Link v = entry.getValue();
      this.links.put(
          Objects.requireNonNull(k, "links key"),
          Objects.requireNonNull(v, "links value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link _UpdateProcessResponse#getLinks() links} map. Nulls are not permitted
     * @param links The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("links")
    public final Builder links(Map<String, ? extends Link> links) {
      this.links.clear();
      return putAllLinks(links);
    }

    /**
     * Put all mappings from the specified map as entries to {@link _UpdateProcessResponse#getLinks() links} map. Nulls are not permitted
     * @param links The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllLinks(Map<String, ? extends Link> links) {
      for (Map.Entry<String, ? extends Link> entry : links.entrySet()) {
        String k = entry.getKey();
        Link v = entry.getValue();
        this.links.put(
            Objects.requireNonNull(k, "links key"),
            Objects.requireNonNull(v, "links value"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateProcessResponse#getUpdatedAt() updatedAt} attribute.
     * @param updatedAt The value for updatedAt 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("updated_at")
    public final Builder updatedAt(String updatedAt) {
      this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt");
      initBits &= ~INIT_BIT_UPDATED_AT;
      return this;
    }

    /**
     * Builds a new {@link UpdateProcessResponse UpdateProcessResponse}.
     * @return An immutable instance of UpdateProcessResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateProcessResponse build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UpdateProcessResponse(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      if ((initBits & INIT_BIT_COMMAND) != 0) attributes.add("command");
      if ((initBits & INIT_BIT_INSTANCES) != 0) attributes.add("instances");
      if ((initBits & INIT_BIT_MEMORY_IN_MB) != 0) attributes.add("memoryInMb");
      if ((initBits & INIT_BIT_DISK_IN_MB) != 0) attributes.add("diskInMb");
      if ((initBits & INIT_BIT_HEALTH_CHECK) != 0) attributes.add("healthCheck");
      if ((initBits & INIT_BIT_CREATED_AT) != 0) attributes.add("createdAt");
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_UPDATED_AT) != 0) attributes.add("updatedAt");
      return "Cannot build UpdateProcessResponse, some of required attributes are not set " + attributes;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
