package org.cloudfoundry.uaa.users;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The name for a user
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_Name"})
public final class Name extends org.cloudfoundry.uaa.users._Name {
  private final @Nullable String familyName;
  private final @Nullable String givenName;

  private Name(Name.Builder builder) {
    this.familyName = builder.familyName;
    this.givenName = builder.givenName;
  }

  /**
   * The family name
   */
  @JsonProperty("familyName")
  @Override
  public @Nullable String getFamilyName() {
    return familyName;
  }

  /**
   * The given name
   */
  @JsonProperty("givenName")
  @Override
  public @Nullable String getGivenName() {
    return givenName;
  }

  /**
   * This instance is equal to all instances of {@code Name} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Name
        && equalTo((Name) another);
  }

  private boolean equalTo(Name another) {
    return Objects.equals(familyName, another.familyName)
        && Objects.equals(givenName, another.givenName);
  }

  /**
   * Computes a hash code from attributes: {@code familyName}, {@code givenName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(familyName);
    h += (h << 5) + Objects.hashCode(givenName);
    return h;
  }

  /**
   * Prints the immutable value {@code Name} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Name{"
        + "familyName=" + familyName
        + ", givenName=" + givenName
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.users._Name {
    String familyName;
    String givenName;
    @JsonProperty("familyName")
    public void setFamilyName(@Nullable String familyName) {
      this.familyName = familyName;
    }
    @JsonProperty("givenName")
    public void setGivenName(@Nullable String givenName) {
      this.givenName = givenName;
    }
    @Override
    public String getFamilyName() { throw new UnsupportedOperationException(); }
    @Override
    public String getGivenName() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static Name fromJson(Json json) {
    Name.Builder builder = Name.builder();
    if (json.familyName != null) {
      builder.familyName(json.familyName);
    }
    if (json.givenName != null) {
      builder.givenName(json.givenName);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Name Name}.
   * @return A new Name builder
   */
  public static Name.Builder builder() {
    return new Name.Builder();
  }

  /**
   * Builds instances of type {@link Name Name}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private String familyName;
    private String givenName;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Name} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Name instance) {
      return from((_Name) instance);
    }

    /**
     * Copy abstract value type {@code _Name} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Name instance) {
      Objects.requireNonNull(instance, "instance");
      String familyNameValue = instance.getFamilyName();
      if (familyNameValue != null) {
        familyName(familyNameValue);
      }
      String givenNameValue = instance.getGivenName();
      if (givenNameValue != null) {
        givenName(givenNameValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _Name#getFamilyName() familyName} attribute.
     * @param familyName The value for familyName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("familyName")
    public final Builder familyName(@Nullable String familyName) {
      this.familyName = familyName;
      return this;
    }

    /**
     * Initializes the value for the {@link _Name#getGivenName() givenName} attribute.
     * @param givenName The value for givenName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("givenName")
    public final Builder givenName(@Nullable String givenName) {
      this.givenName = givenName;
      return this;
    }

    /**
     * Builds a new {@link Name Name}.
     * @return An immutable instance of Name
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Name build() {
      return new Name(this);
    }
  }
}
