package org.cloudfoundry.client.v2.applications;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The request payload for the v2 Create Application request
 */
@SuppressWarnings({"all", "deprecation"})
@Generated({"Immutables.generator", "_CreateApplicationRequest"})
public final class CreateApplicationRequest
    extends org.cloudfoundry.client.v2.applications._CreateApplicationRequest {
  private final @Nullable String buildpack;
  private final @Nullable String command;
  private final @Nullable Boolean console;
  private final @Nullable String debug;
  private final @Nullable String detectedStartCommand;
  private final @Nullable Boolean diego;
  private final @Nullable Integer diskQuota;
  private final @Nullable Map<String, Object> dockerCredentialsJsons;
  private final @Nullable String dockerImage;
  private final @Nullable Boolean enableSsh;
  private final @Nullable Map<String, Object> environmentJsons;
  private final @Nullable String healthCheckHttpEndpoint;
  private final @Nullable Integer healthCheckTimeout;
  private final @Nullable String healthCheckType;
  private final @Nullable Integer instances;
  private final @Nullable Integer memory;
  private final String name;
  private final @Nullable List<Integer> ports;
  private final @Nullable Boolean production;
  private final String spaceId;
  private final @Nullable String stackId;
  private final @Nullable String state;

  private CreateApplicationRequest(CreateApplicationRequest.Builder builder) {
    this.buildpack = builder.buildpack;
    this.command = builder.command;
    this.console = builder.console;
    this.debug = builder.debug;
    this.detectedStartCommand = builder.detectedStartCommand;
    this.diego = builder.diego;
    this.diskQuota = builder.diskQuota;
    this.dockerCredentialsJsons = builder.dockerCredentialsJsons == null ? null : createUnmodifiableMap(false, false, builder.dockerCredentialsJsons);
    this.dockerImage = builder.dockerImage;
    this.enableSsh = builder.enableSsh;
    this.environmentJsons = builder.environmentJsons == null ? null : createUnmodifiableMap(false, false, builder.environmentJsons);
    this.healthCheckHttpEndpoint = builder.healthCheckHttpEndpoint;
    this.healthCheckTimeout = builder.healthCheckTimeout;
    this.healthCheckType = builder.healthCheckType;
    this.instances = builder.instances;
    this.memory = builder.memory;
    this.name = builder.name;
    this.ports = builder.ports == null ? null : createUnmodifiableList(true, builder.ports);
    this.production = builder.production;
    this.spaceId = builder.spaceId;
    this.stackId = builder.stackId;
    this.state = builder.state;
  }

  /**
   * Buildpack to build the application
   */
  @Override
  public @Nullable String getBuildpack() {
    return buildpack;
  }

  /**
   * The command to start the application after it is staged
   */
  @Override
  public @Nullable String getCommand() {
    return command;
  }

  /**
   * Open the console port for the application (at $CONSOLE_PORT)
   */
  @Deprecated
  @Override
  public @Nullable Boolean getConsole() {
    return console;
  }

  /**
   * Open the debug port for the application (at $DEBUG_PORT)
   */
  @Deprecated
  @Override
  public @Nullable String getDebug() {
    return debug;
  }

  /**
   * The command detected by the buildpack during staging
   */
  @Override
  public @Nullable String getDetectedStartCommand() {
    return detectedStartCommand;
  }

  /**
   * Use diego to stage and to run when available
   */
  @Override
  public @Nullable Boolean getDiego() {
    return diego;
  }

  /**
   * The maximum amount of disk available to an instance of an application. In megabytes.
   */
  @Override
  public @Nullable Integer getDiskQuota() {
    return diskQuota;
  }

  /**
   * Docker credentials for pulling docker image
   */
  @Override
  public @Nullable Map<String, Object> getDockerCredentialsJsons() {
    return dockerCredentialsJsons;
  }

  /**
   * Name of the Docker image containing the application
   */
  @Override
  public @Nullable String getDockerImage() {
    return dockerImage;
  }

  /**
   * Enable SSHing into the application
   */
  @Override
  public @Nullable Boolean getEnableSsh() {
    return enableSsh;
  }

  /**
   * Key/value pairs of all the environment variables to run in your application. Does not include any system or service variables.
   */
  @Override
  public @Nullable Map<String, Object> getEnvironmentJsons() {
    return environmentJsons;
  }

  /**
   * The HTTP endpoint to check for health
   */
  @Override
  public @Nullable String getHealthCheckHttpEndpoint() {
    return healthCheckHttpEndpoint;
  }

  /**
   * Timeout for health checking of an staged applcation when starting up
   */
  @Override
  public @Nullable Integer getHealthCheckTimeout() {
    return healthCheckTimeout;
  }

  /**
   * Type of health check to perform
   */
  @Override
  public @Nullable String getHealthCheckType() {
    return healthCheckType;
  }

  /**
   * The number of instances of the application to run. To ensure optimal availability, ensure there are at least 2 instances.
   */
  @Override
  public @Nullable Integer getInstances() {
    return instances;
  }

  /**
   * The amount of memory each instance should have. In megabytes.
   */
  @Override
  public @Nullable Integer getMemory() {
    return memory;
  }

  /**
   * The name of the application
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * The ports on which application may listen
   */
  @Override
  public @Nullable List<Integer> getPorts() {
    return ports;
  }

  /**
   * Whether to open the production port
   */
  @Deprecated
  @Override
  public @Nullable Boolean getProduction() {
    return production;
  }

  /**
   * The id of the associated space
   */
  @Override
  public String getSpaceId() {
    return spaceId;
  }

  /**
   * The id of the associated stack
   */
  @Override
  public @Nullable String getStackId() {
    return stackId;
  }

  /**
   * The current desired state of the application
   */
  @Override
  public @Nullable String getState() {
    return state;
  }

  /**
   * This instance is equal to all instances of {@code CreateApplicationRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CreateApplicationRequest
        && equalTo((CreateApplicationRequest) another);
  }

  private boolean equalTo(CreateApplicationRequest another) {
    return Objects.equals(buildpack, another.buildpack)
        && Objects.equals(command, another.command)
        && Objects.equals(console, another.console)
        && Objects.equals(debug, another.debug)
        && Objects.equals(detectedStartCommand, another.detectedStartCommand)
        && Objects.equals(diego, another.diego)
        && Objects.equals(diskQuota, another.diskQuota)
        && Objects.equals(dockerCredentialsJsons, another.dockerCredentialsJsons)
        && Objects.equals(dockerImage, another.dockerImage)
        && Objects.equals(enableSsh, another.enableSsh)
        && Objects.equals(environmentJsons, another.environmentJsons)
        && Objects.equals(healthCheckHttpEndpoint, another.healthCheckHttpEndpoint)
        && Objects.equals(healthCheckTimeout, another.healthCheckTimeout)
        && Objects.equals(healthCheckType, another.healthCheckType)
        && Objects.equals(instances, another.instances)
        && Objects.equals(memory, another.memory)
        && name.equals(another.name)
        && Objects.equals(ports, another.ports)
        && Objects.equals(production, another.production)
        && spaceId.equals(another.spaceId)
        && Objects.equals(stackId, another.stackId)
        && Objects.equals(state, another.state);
  }

  /**
   * Computes a hash code from attributes: {@code buildpack}, {@code command}, {@code console}, {@code debug}, {@code detectedStartCommand}, {@code diego}, {@code diskQuota}, {@code dockerCredentialsJsons}, {@code dockerImage}, {@code enableSsh}, {@code environmentJsons}, {@code healthCheckHttpEndpoint}, {@code healthCheckTimeout}, {@code healthCheckType}, {@code instances}, {@code memory}, {@code name}, {@code ports}, {@code production}, {@code spaceId}, {@code stackId}, {@code state}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(buildpack);
    h += (h << 5) + Objects.hashCode(command);
    h += (h << 5) + Objects.hashCode(console);
    h += (h << 5) + Objects.hashCode(debug);
    h += (h << 5) + Objects.hashCode(detectedStartCommand);
    h += (h << 5) + Objects.hashCode(diego);
    h += (h << 5) + Objects.hashCode(diskQuota);
    h += (h << 5) + Objects.hashCode(dockerCredentialsJsons);
    h += (h << 5) + Objects.hashCode(dockerImage);
    h += (h << 5) + Objects.hashCode(enableSsh);
    h += (h << 5) + Objects.hashCode(environmentJsons);
    h += (h << 5) + Objects.hashCode(healthCheckHttpEndpoint);
    h += (h << 5) + Objects.hashCode(healthCheckTimeout);
    h += (h << 5) + Objects.hashCode(healthCheckType);
    h += (h << 5) + Objects.hashCode(instances);
    h += (h << 5) + Objects.hashCode(memory);
    h += (h << 5) + name.hashCode();
    h += (h << 5) + Objects.hashCode(ports);
    h += (h << 5) + Objects.hashCode(production);
    h += (h << 5) + spaceId.hashCode();
    h += (h << 5) + Objects.hashCode(stackId);
    h += (h << 5) + Objects.hashCode(state);
    return h;
  }

  /**
   * Prints the immutable value {@code CreateApplicationRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CreateApplicationRequest{"
        + "buildpack=" + buildpack
        + ", command=" + command
        + ", console=" + console
        + ", debug=" + debug
        + ", detectedStartCommand=" + detectedStartCommand
        + ", diego=" + diego
        + ", diskQuota=" + diskQuota
        + ", dockerCredentialsJsons=" + dockerCredentialsJsons
        + ", dockerImage=" + dockerImage
        + ", enableSsh=" + enableSsh
        + ", environmentJsons=" + environmentJsons
        + ", healthCheckHttpEndpoint=" + healthCheckHttpEndpoint
        + ", healthCheckTimeout=" + healthCheckTimeout
        + ", healthCheckType=" + healthCheckType
        + ", instances=" + instances
        + ", memory=" + memory
        + ", name=" + name
        + ", ports=" + ports
        + ", production=" + production
        + ", spaceId=" + spaceId
        + ", stackId=" + stackId
        + ", state=" + state
        + "}";
  }

  /**
   * Creates a builder for {@link CreateApplicationRequest CreateApplicationRequest}.
   * @return A new CreateApplicationRequest builder
   */
  public static CreateApplicationRequest.Builder builder() {
    return new CreateApplicationRequest.Builder();
  }

  /**
   * Builds instances of type {@link CreateApplicationRequest CreateApplicationRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_SPACE_ID = 0x2L;
    private long initBits = 0x3L;

    private String buildpack;
    private String command;
    private Boolean console;
    private String debug;
    private String detectedStartCommand;
    private Boolean diego;
    private Integer diskQuota;
    private Map<String, Object> dockerCredentialsJsons = null;
    private String dockerImage;
    private Boolean enableSsh;
    private Map<String, Object> environmentJsons = null;
    private String healthCheckHttpEndpoint;
    private Integer healthCheckTimeout;
    private String healthCheckType;
    private Integer instances;
    private Integer memory;
    private String name;
    private List<Integer> ports = null;
    private Boolean production;
    private String spaceId;
    private String stackId;
    private String state;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateApplicationRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CreateApplicationRequest instance) {
      return from((_CreateApplicationRequest) instance);
    }

    /**
     * Copy abstract value type {@code _CreateApplicationRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CreateApplicationRequest instance) {
      Objects.requireNonNull(instance, "instance");
      String buildpackValue = instance.getBuildpack();
      if (buildpackValue != null) {
        buildpack(buildpackValue);
      }
      String commandValue = instance.getCommand();
      if (commandValue != null) {
        command(commandValue);
      }
      Boolean consoleValue = instance.getConsole();
      if (consoleValue != null) {
        console(consoleValue);
      }
      String debugValue = instance.getDebug();
      if (debugValue != null) {
        debug(debugValue);
      }
      String detectedStartCommandValue = instance.getDetectedStartCommand();
      if (detectedStartCommandValue != null) {
        detectedStartCommand(detectedStartCommandValue);
      }
      Boolean diegoValue = instance.getDiego();
      if (diegoValue != null) {
        diego(diegoValue);
      }
      Integer diskQuotaValue = instance.getDiskQuota();
      if (diskQuotaValue != null) {
        diskQuota(diskQuotaValue);
      }
      Map<String, Object> dockerCredentialsJsonsValue = instance.getDockerCredentialsJsons();
      if (dockerCredentialsJsonsValue != null) {
        putAllDockerCredentialsJsons(dockerCredentialsJsonsValue);
      }
      String dockerImageValue = instance.getDockerImage();
      if (dockerImageValue != null) {
        dockerImage(dockerImageValue);
      }
      Boolean enableSshValue = instance.getEnableSsh();
      if (enableSshValue != null) {
        enableSsh(enableSshValue);
      }
      Map<String, Object> environmentJsonsValue = instance.getEnvironmentJsons();
      if (environmentJsonsValue != null) {
        putAllEnvironmentJsons(environmentJsonsValue);
      }
      String healthCheckHttpEndpointValue = instance.getHealthCheckHttpEndpoint();
      if (healthCheckHttpEndpointValue != null) {
        healthCheckHttpEndpoint(healthCheckHttpEndpointValue);
      }
      Integer healthCheckTimeoutValue = instance.getHealthCheckTimeout();
      if (healthCheckTimeoutValue != null) {
        healthCheckTimeout(healthCheckTimeoutValue);
      }
      String healthCheckTypeValue = instance.getHealthCheckType();
      if (healthCheckTypeValue != null) {
        healthCheckType(healthCheckTypeValue);
      }
      Integer instancesValue = instance.getInstances();
      if (instancesValue != null) {
        instances(instancesValue);
      }
      Integer memoryValue = instance.getMemory();
      if (memoryValue != null) {
        memory(memoryValue);
      }
      name(instance.getName());
      List<Integer> portsValue = instance.getPorts();
      if (portsValue != null) {
        addAllPorts(portsValue);
      }
      Boolean productionValue = instance.getProduction();
      if (productionValue != null) {
        production(productionValue);
      }
      spaceId(instance.getSpaceId());
      String stackIdValue = instance.getStackId();
      if (stackIdValue != null) {
        stackId(stackIdValue);
      }
      String stateValue = instance.getState();
      if (stateValue != null) {
        state(stateValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateApplicationRequest#getBuildpack() buildpack} attribute.
     * @param buildpack The value for buildpack (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder buildpack(@Nullable String buildpack) {
      this.buildpack = buildpack;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateApplicationRequest#getCommand() command} attribute.
     * @param command The value for command (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder command(@Nullable String command) {
      this.command = command;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateApplicationRequest#getConsole() console} attribute.
     * @param console The value for console (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @Deprecated
    public final Builder console(@Nullable Boolean console) {
      this.console = console;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateApplicationRequest#getDebug() debug} attribute.
     * @param debug The value for debug (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @Deprecated
    public final Builder debug(@Nullable String debug) {
      this.debug = debug;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateApplicationRequest#getDetectedStartCommand() detectedStartCommand} attribute.
     * @param detectedStartCommand The value for detectedStartCommand (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder detectedStartCommand(@Nullable String detectedStartCommand) {
      this.detectedStartCommand = detectedStartCommand;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateApplicationRequest#getDiego() diego} attribute.
     * @param diego The value for diego (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder diego(@Nullable Boolean diego) {
      this.diego = diego;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateApplicationRequest#getDiskQuota() diskQuota} attribute.
     * @param diskQuota The value for diskQuota (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder diskQuota(@Nullable Integer diskQuota) {
      this.diskQuota = diskQuota;
      return this;
    }

    /**
     * Put one entry to the {@link _CreateApplicationRequest#getDockerCredentialsJsons() dockerCredentialsJsons} map.
     * @param key The key in the dockerCredentialsJsons map
     * @param value The associated value in the dockerCredentialsJsons map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder dockerCredentialsJson(String key, Object value) {
      if (this.dockerCredentialsJsons == null) {
        this.dockerCredentialsJsons = new LinkedHashMap<String, Object>();
      }
      this.dockerCredentialsJsons.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link _CreateApplicationRequest#getDockerCredentialsJsons() dockerCredentialsJsons} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder dockerCredentialsJson(Map.Entry<String, ? extends Object> entry) {
      if (this.dockerCredentialsJsons == null) {
        this.dockerCredentialsJsons = new LinkedHashMap<String, Object>();
      }
      String k = entry.getKey();
      Object v = entry.getValue();
      this.dockerCredentialsJsons.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link _CreateApplicationRequest#getDockerCredentialsJsons() dockerCredentialsJsons} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param dockerCredentialsJsons The entries that will be added to the dockerCredentialsJsons map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder dockerCredentialsJsons(@Nullable Map<String, ? extends Object> dockerCredentialsJsons) {
      if (dockerCredentialsJsons == null) {
        this.dockerCredentialsJsons = null;
        return this;
      }
      this.dockerCredentialsJsons = new LinkedHashMap<String, Object>();
      return putAllDockerCredentialsJsons(dockerCredentialsJsons);
    }

    /**
     * Put all mappings from the specified map as entries to {@link _CreateApplicationRequest#getDockerCredentialsJsons() dockerCredentialsJsons} map. Nulls are not permitted
     * @param dockerCredentialsJsons The entries that will be added to the dockerCredentialsJsons map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllDockerCredentialsJsons(Map<String, ? extends Object> dockerCredentialsJsons) {
      if (this.dockerCredentialsJsons == null) {
        this.dockerCredentialsJsons = new LinkedHashMap<String, Object>();
      }
      for (Map.Entry<String, ? extends Object> entry : dockerCredentialsJsons.entrySet()) {
        String k = entry.getKey();
        Object v = entry.getValue();
        this.dockerCredentialsJsons.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateApplicationRequest#getDockerImage() dockerImage} attribute.
     * @param dockerImage The value for dockerImage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder dockerImage(@Nullable String dockerImage) {
      this.dockerImage = dockerImage;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateApplicationRequest#getEnableSsh() enableSsh} attribute.
     * @param enableSsh The value for enableSsh (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder enableSsh(@Nullable Boolean enableSsh) {
      this.enableSsh = enableSsh;
      return this;
    }

    /**
     * Put one entry to the {@link _CreateApplicationRequest#getEnvironmentJsons() environmentJsons} map.
     * @param key The key in the environmentJsons map
     * @param value The associated value in the environmentJsons map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder environmentJson(String key, Object value) {
      if (this.environmentJsons == null) {
        this.environmentJsons = new LinkedHashMap<String, Object>();
      }
      this.environmentJsons.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link _CreateApplicationRequest#getEnvironmentJsons() environmentJsons} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder environmentJson(Map.Entry<String, ? extends Object> entry) {
      if (this.environmentJsons == null) {
        this.environmentJsons = new LinkedHashMap<String, Object>();
      }
      String k = entry.getKey();
      Object v = entry.getValue();
      this.environmentJsons.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link _CreateApplicationRequest#getEnvironmentJsons() environmentJsons} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param environmentJsons The entries that will be added to the environmentJsons map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder environmentJsons(@Nullable Map<String, ? extends Object> environmentJsons) {
      if (environmentJsons == null) {
        this.environmentJsons = null;
        return this;
      }
      this.environmentJsons = new LinkedHashMap<String, Object>();
      return putAllEnvironmentJsons(environmentJsons);
    }

    /**
     * Put all mappings from the specified map as entries to {@link _CreateApplicationRequest#getEnvironmentJsons() environmentJsons} map. Nulls are not permitted
     * @param environmentJsons The entries that will be added to the environmentJsons map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllEnvironmentJsons(Map<String, ? extends Object> environmentJsons) {
      if (this.environmentJsons == null) {
        this.environmentJsons = new LinkedHashMap<String, Object>();
      }
      for (Map.Entry<String, ? extends Object> entry : environmentJsons.entrySet()) {
        String k = entry.getKey();
        Object v = entry.getValue();
        this.environmentJsons.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateApplicationRequest#getHealthCheckHttpEndpoint() healthCheckHttpEndpoint} attribute.
     * @param healthCheckHttpEndpoint The value for healthCheckHttpEndpoint (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder healthCheckHttpEndpoint(@Nullable String healthCheckHttpEndpoint) {
      this.healthCheckHttpEndpoint = healthCheckHttpEndpoint;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateApplicationRequest#getHealthCheckTimeout() healthCheckTimeout} attribute.
     * @param healthCheckTimeout The value for healthCheckTimeout (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder healthCheckTimeout(@Nullable Integer healthCheckTimeout) {
      this.healthCheckTimeout = healthCheckTimeout;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateApplicationRequest#getHealthCheckType() healthCheckType} attribute.
     * @param healthCheckType The value for healthCheckType (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder healthCheckType(@Nullable String healthCheckType) {
      this.healthCheckType = healthCheckType;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateApplicationRequest#getInstances() instances} attribute.
     * @param instances The value for instances (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder instances(@Nullable Integer instances) {
      this.instances = instances;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateApplicationRequest#getMemory() memory} attribute.
     * @param memory The value for memory (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder memory(@Nullable Integer memory) {
      this.memory = memory;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateApplicationRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Adds one element to {@link _CreateApplicationRequest#getPorts() ports} list.
     * @param element A ports element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder port(int element) {
      if (this.ports == null) {
        this.ports = new ArrayList<Integer>();
      }
      this.ports.add(element);
      return this;
    }

    /**
     * Adds elements to {@link _CreateApplicationRequest#getPorts() ports} list.
     * @param elements An array of ports elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder port(int... elements) {
      if (this.ports == null) {
        this.ports = new ArrayList<Integer>();
      }
      for (int element : elements) {
        this.ports.add(element);
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _CreateApplicationRequest#getPorts() ports} list.
     * @param elements An iterable of ports elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder ports(@Nullable Iterable<Integer> elements) {
      if (elements == null) {
        this.ports = null;
        return this;
      }
      this.ports = new ArrayList<Integer>();
      return addAllPorts(elements);
    }

    /**
     * Adds elements to {@link _CreateApplicationRequest#getPorts() ports} list.
     * @param elements An iterable of ports elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllPorts(Iterable<Integer> elements) {
      Objects.requireNonNull(elements, "ports element");
      if (this.ports == null) {
        this.ports = new ArrayList<Integer>();
      }
      for (int element : elements) {
        this.ports.add(Objects.requireNonNull(element, "ports element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateApplicationRequest#getProduction() production} attribute.
     * @param production The value for production (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @Deprecated
    public final Builder production(@Nullable Boolean production) {
      this.production = production;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateApplicationRequest#getSpaceId() spaceId} attribute.
     * @param spaceId The value for spaceId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(String spaceId) {
      this.spaceId = Objects.requireNonNull(spaceId, "spaceId");
      initBits &= ~INIT_BIT_SPACE_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateApplicationRequest#getStackId() stackId} attribute.
     * @param stackId The value for stackId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder stackId(@Nullable String stackId) {
      this.stackId = stackId;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateApplicationRequest#getState() state} attribute.
     * @param state The value for state (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder state(@Nullable String state) {
      this.state = state;
      return this;
    }

    /**
     * Builds a new {@link CreateApplicationRequest CreateApplicationRequest}.
     * @return An immutable instance of CreateApplicationRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CreateApplicationRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CreateApplicationRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_SPACE_ID) != 0) attributes.add("spaceId");
      return "Cannot build CreateApplicationRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
