package org.cloudfoundry.client.v2.organizations;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The request payload for the Creating an Organization operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_CreateOrganizationRequest"})
public final class CreateOrganizationRequest
    extends org.cloudfoundry.client.v2.organizations._CreateOrganizationRequest {
  private final String name;
  private final @Nullable String quotaDefinitionId;
  private final @Nullable String status;

  private CreateOrganizationRequest(CreateOrganizationRequest.Builder builder) {
    this.name = builder.name;
    this.quotaDefinitionId = builder.quotaDefinitionId;
    this.status = builder.status;
  }

  /**
   * The name
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * The quota definition id
   */
  @Override
  public @Nullable String getQuotaDefinitionId() {
    return quotaDefinitionId;
  }

  /**
   * The status
   */
  @Override
  public @Nullable String getStatus() {
    return status;
  }

  /**
   * This instance is equal to all instances of {@code CreateOrganizationRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CreateOrganizationRequest
        && equalTo((CreateOrganizationRequest) another);
  }

  private boolean equalTo(CreateOrganizationRequest another) {
    return name.equals(another.name)
        && Objects.equals(quotaDefinitionId, another.quotaDefinitionId)
        && Objects.equals(status, another.status);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code quotaDefinitionId}, {@code status}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + Objects.hashCode(quotaDefinitionId);
    h += (h << 5) + Objects.hashCode(status);
    return h;
  }

  /**
   * Prints the immutable value {@code CreateOrganizationRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CreateOrganizationRequest{"
        + "name=" + name
        + ", quotaDefinitionId=" + quotaDefinitionId
        + ", status=" + status
        + "}";
  }

  /**
   * Creates a builder for {@link CreateOrganizationRequest CreateOrganizationRequest}.
   * @return A new CreateOrganizationRequest builder
   */
  public static CreateOrganizationRequest.Builder builder() {
    return new CreateOrganizationRequest.Builder();
  }

  /**
   * Builds instances of type {@link CreateOrganizationRequest CreateOrganizationRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private String name;
    private String quotaDefinitionId;
    private String status;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateOrganizationRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CreateOrganizationRequest instance) {
      return from((_CreateOrganizationRequest) instance);
    }

    /**
     * Copy abstract value type {@code _CreateOrganizationRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CreateOrganizationRequest instance) {
      Objects.requireNonNull(instance, "instance");
      name(instance.getName());
      String quotaDefinitionIdValue = instance.getQuotaDefinitionId();
      if (quotaDefinitionIdValue != null) {
        quotaDefinitionId(quotaDefinitionIdValue);
      }
      String statusValue = instance.getStatus();
      if (statusValue != null) {
        status(statusValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateOrganizationRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateOrganizationRequest#getQuotaDefinitionId() quotaDefinitionId} attribute.
     * @param quotaDefinitionId The value for quotaDefinitionId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder quotaDefinitionId(@Nullable String quotaDefinitionId) {
      this.quotaDefinitionId = quotaDefinitionId;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateOrganizationRequest#getStatus() status} attribute.
     * @param status The value for status (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder status(@Nullable String status) {
      this.status = status;
      return this;
    }

    /**
     * Builds a new {@link CreateOrganizationRequest CreateOrganizationRequest}.
     * @return An immutable instance of CreateOrganizationRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CreateOrganizationRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CreateOrganizationRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build CreateOrganizationRequest, some of required attributes are not set " + attributes;
    }
  }
}
