package org.cloudfoundry.client.v2.organizations;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The request payload for the Update an Organization operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_UpdateOrganizationRequest"})
public final class UpdateOrganizationRequest
    extends org.cloudfoundry.client.v2.organizations._UpdateOrganizationRequest {
  private final @Nullable String name;
  private final String organizationId;
  private final @Nullable String quotaDefinitionId;
  private final @Nullable String status;

  private UpdateOrganizationRequest(UpdateOrganizationRequest.Builder builder) {
    this.name = builder.name;
    this.organizationId = builder.organizationId;
    this.quotaDefinitionId = builder.quotaDefinitionId;
    this.status = builder.status;
  }

  /**
   * The name
   */
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * The organization id
   */
  @Override
  public String getOrganizationId() {
    return organizationId;
  }

  /**
   * The quota definition id
   */
  @Override
  public @Nullable String getQuotaDefinitionId() {
    return quotaDefinitionId;
  }

  /**
   * The status
   */
  @Override
  public @Nullable String getStatus() {
    return status;
  }

  /**
   * This instance is equal to all instances of {@code UpdateOrganizationRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateOrganizationRequest
        && equalTo((UpdateOrganizationRequest) another);
  }

  private boolean equalTo(UpdateOrganizationRequest another) {
    return Objects.equals(name, another.name)
        && organizationId.equals(another.organizationId)
        && Objects.equals(quotaDefinitionId, another.quotaDefinitionId)
        && Objects.equals(status, another.status);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code organizationId}, {@code quotaDefinitionId}, {@code status}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + organizationId.hashCode();
    h += (h << 5) + Objects.hashCode(quotaDefinitionId);
    h += (h << 5) + Objects.hashCode(status);
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateOrganizationRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateOrganizationRequest{"
        + "name=" + name
        + ", organizationId=" + organizationId
        + ", quotaDefinitionId=" + quotaDefinitionId
        + ", status=" + status
        + "}";
  }

  /**
   * Creates a builder for {@link UpdateOrganizationRequest UpdateOrganizationRequest}.
   * @return A new UpdateOrganizationRequest builder
   */
  public static UpdateOrganizationRequest.Builder builder() {
    return new UpdateOrganizationRequest.Builder();
  }

  /**
   * Builds instances of type {@link UpdateOrganizationRequest UpdateOrganizationRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_ORGANIZATION_ID = 0x1L;
    private long initBits = 0x1L;

    private String name;
    private String organizationId;
    private String quotaDefinitionId;
    private String status;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateOrganizationRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateOrganizationRequest instance) {
      return from((_UpdateOrganizationRequest) instance);
    }

    /**
     * Copy abstract value type {@code _UpdateOrganizationRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UpdateOrganizationRequest instance) {
      Objects.requireNonNull(instance, "instance");
      String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      organizationId(instance.getOrganizationId());
      String quotaDefinitionIdValue = instance.getQuotaDefinitionId();
      if (quotaDefinitionIdValue != null) {
        quotaDefinitionId(quotaDefinitionIdValue);
      }
      String statusValue = instance.getStatus();
      if (statusValue != null) {
        status(statusValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateOrganizationRequest#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateOrganizationRequest#getOrganizationId() organizationId} attribute.
     * @param organizationId The value for organizationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(String organizationId) {
      this.organizationId = Objects.requireNonNull(organizationId, "organizationId");
      initBits &= ~INIT_BIT_ORGANIZATION_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateOrganizationRequest#getQuotaDefinitionId() quotaDefinitionId} attribute.
     * @param quotaDefinitionId The value for quotaDefinitionId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder quotaDefinitionId(@Nullable String quotaDefinitionId) {
      this.quotaDefinitionId = quotaDefinitionId;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateOrganizationRequest#getStatus() status} attribute.
     * @param status The value for status (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder status(@Nullable String status) {
      this.status = status;
      return this;
    }

    /**
     * Builds a new {@link UpdateOrganizationRequest UpdateOrganizationRequest}.
     * @return An immutable instance of UpdateOrganizationRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateOrganizationRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UpdateOrganizationRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_ORGANIZATION_ID) != 0) attributes.add("organizationId");
      return "Cannot build UpdateOrganizationRequest, some of required attributes are not set " + attributes;
    }
  }
}
