package org.cloudfoundry.client.v2.serviceinstances;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request payload for the Get Service Instance operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_GetServiceInstanceRequest"})
public final class GetServiceInstanceRequest
    extends org.cloudfoundry.client.v2.serviceinstances._GetServiceInstanceRequest {
  private final String serviceInstanceId;

  private GetServiceInstanceRequest(GetServiceInstanceRequest.Builder builder) {
    this.serviceInstanceId = builder.serviceInstanceId;
  }

  /**
   * The service instance id
   */
  @Override
  public String getServiceInstanceId() {
    return serviceInstanceId;
  }

  /**
   * This instance is equal to all instances of {@code GetServiceInstanceRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetServiceInstanceRequest
        && equalTo((GetServiceInstanceRequest) another);
  }

  private boolean equalTo(GetServiceInstanceRequest another) {
    return serviceInstanceId.equals(another.serviceInstanceId);
  }

  /**
   * Computes a hash code from attributes: {@code serviceInstanceId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + serviceInstanceId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetServiceInstanceRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetServiceInstanceRequest{"
        + "serviceInstanceId=" + serviceInstanceId
        + "}";
  }

  /**
   * Creates a builder for {@link GetServiceInstanceRequest GetServiceInstanceRequest}.
   * @return A new GetServiceInstanceRequest builder
   */
  public static GetServiceInstanceRequest.Builder builder() {
    return new GetServiceInstanceRequest.Builder();
  }

  /**
   * Builds instances of type {@link GetServiceInstanceRequest GetServiceInstanceRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_SERVICE_INSTANCE_ID = 0x1L;
    private long initBits = 0x1L;

    private String serviceInstanceId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetServiceInstanceRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetServiceInstanceRequest instance) {
      return from((_GetServiceInstanceRequest) instance);
    }

    /**
     * Copy abstract value type {@code _GetServiceInstanceRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetServiceInstanceRequest instance) {
      Objects.requireNonNull(instance, "instance");
      serviceInstanceId(instance.getServiceInstanceId());
      return this;
    }

    /**
     * Initializes the value for the {@link _GetServiceInstanceRequest#getServiceInstanceId() serviceInstanceId} attribute.
     * @param serviceInstanceId The value for serviceInstanceId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceInstanceId(String serviceInstanceId) {
      this.serviceInstanceId = Objects.requireNonNull(serviceInstanceId, "serviceInstanceId");
      initBits &= ~INIT_BIT_SERVICE_INSTANCE_ID;
      return this;
    }

    /**
     * Builds a new {@link GetServiceInstanceRequest GetServiceInstanceRequest}.
     * @return An immutable instance of GetServiceInstanceRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetServiceInstanceRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetServiceInstanceRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_SERVICE_INSTANCE_ID) != 0) attributes.add("serviceInstanceId");
      return "Cannot build GetServiceInstanceRequest, some of required attributes are not set " + attributes;
    }
  }
}
