package org.cloudfoundry.client.v2.serviceplans;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request payload for the Get Service Plan operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_GetServicePlanRequest"})
public final class GetServicePlanRequest
    extends org.cloudfoundry.client.v2.serviceplans._GetServicePlanRequest {
  private final String servicePlanId;

  private GetServicePlanRequest(GetServicePlanRequest.Builder builder) {
    this.servicePlanId = builder.servicePlanId;
  }

  /**
   * The service plan id
   */
  @Override
  public String getServicePlanId() {
    return servicePlanId;
  }

  /**
   * This instance is equal to all instances of {@code GetServicePlanRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetServicePlanRequest
        && equalTo((GetServicePlanRequest) another);
  }

  private boolean equalTo(GetServicePlanRequest another) {
    return servicePlanId.equals(another.servicePlanId);
  }

  /**
   * Computes a hash code from attributes: {@code servicePlanId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + servicePlanId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetServicePlanRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetServicePlanRequest{"
        + "servicePlanId=" + servicePlanId
        + "}";
  }

  /**
   * Creates a builder for {@link GetServicePlanRequest GetServicePlanRequest}.
   * @return A new GetServicePlanRequest builder
   */
  public static GetServicePlanRequest.Builder builder() {
    return new GetServicePlanRequest.Builder();
  }

  /**
   * Builds instances of type {@link GetServicePlanRequest GetServicePlanRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_SERVICE_PLAN_ID = 0x1L;
    private long initBits = 0x1L;

    private String servicePlanId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetServicePlanRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetServicePlanRequest instance) {
      return from((_GetServicePlanRequest) instance);
    }

    /**
     * Copy abstract value type {@code _GetServicePlanRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetServicePlanRequest instance) {
      Objects.requireNonNull(instance, "instance");
      servicePlanId(instance.getServicePlanId());
      return this;
    }

    /**
     * Initializes the value for the {@link _GetServicePlanRequest#getServicePlanId() servicePlanId} attribute.
     * @param servicePlanId The value for servicePlanId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder servicePlanId(String servicePlanId) {
      this.servicePlanId = Objects.requireNonNull(servicePlanId, "servicePlanId");
      initBits &= ~INIT_BIT_SERVICE_PLAN_ID;
      return this;
    }

    /**
     * Builds a new {@link GetServicePlanRequest GetServicePlanRequest}.
     * @return An immutable instance of GetServicePlanRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetServicePlanRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetServicePlanRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_SERVICE_PLAN_ID) != 0) attributes.add("servicePlanId");
      return "Cannot build GetServicePlanRequest, some of required attributes are not set " + attributes;
    }
  }
}
