package org.cloudfoundry.client.v2.serviceplans;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The request payload for the update service plan operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_UpdateServicePlanRequest"})
public final class UpdateServicePlanRequest
    extends org.cloudfoundry.client.v2.serviceplans._UpdateServicePlanRequest {
  private final @Nullable Boolean publiclyVisible;
  private final String servicePlanId;

  private UpdateServicePlanRequest(UpdateServicePlanRequest.Builder builder) {
    this.publiclyVisible = builder.publiclyVisible;
    this.servicePlanId = builder.servicePlanId;
  }

  /**
   * Make the plan visible to all users
   */
  @Override
  public @Nullable Boolean getPubliclyVisible() {
    return publiclyVisible;
  }

  /**
   * The service plan id
   */
  @Override
  public String getServicePlanId() {
    return servicePlanId;
  }

  /**
   * This instance is equal to all instances of {@code UpdateServicePlanRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateServicePlanRequest
        && equalTo((UpdateServicePlanRequest) another);
  }

  private boolean equalTo(UpdateServicePlanRequest another) {
    return Objects.equals(publiclyVisible, another.publiclyVisible)
        && servicePlanId.equals(another.servicePlanId);
  }

  /**
   * Computes a hash code from attributes: {@code publiclyVisible}, {@code servicePlanId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(publiclyVisible);
    h += (h << 5) + servicePlanId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateServicePlanRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateServicePlanRequest{"
        + "publiclyVisible=" + publiclyVisible
        + ", servicePlanId=" + servicePlanId
        + "}";
  }

  /**
   * Creates a builder for {@link UpdateServicePlanRequest UpdateServicePlanRequest}.
   * @return A new UpdateServicePlanRequest builder
   */
  public static UpdateServicePlanRequest.Builder builder() {
    return new UpdateServicePlanRequest.Builder();
  }

  /**
   * Builds instances of type {@link UpdateServicePlanRequest UpdateServicePlanRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_SERVICE_PLAN_ID = 0x1L;
    private long initBits = 0x1L;

    private Boolean publiclyVisible;
    private String servicePlanId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateServicePlanRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateServicePlanRequest instance) {
      return from((_UpdateServicePlanRequest) instance);
    }

    /**
     * Copy abstract value type {@code _UpdateServicePlanRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UpdateServicePlanRequest instance) {
      Objects.requireNonNull(instance, "instance");
      Boolean publiclyVisibleValue = instance.getPubliclyVisible();
      if (publiclyVisibleValue != null) {
        publiclyVisible(publiclyVisibleValue);
      }
      servicePlanId(instance.getServicePlanId());
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateServicePlanRequest#getPubliclyVisible() publiclyVisible} attribute.
     * @param publiclyVisible The value for publiclyVisible (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder publiclyVisible(@Nullable Boolean publiclyVisible) {
      this.publiclyVisible = publiclyVisible;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateServicePlanRequest#getServicePlanId() servicePlanId} attribute.
     * @param servicePlanId The value for servicePlanId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder servicePlanId(String servicePlanId) {
      this.servicePlanId = Objects.requireNonNull(servicePlanId, "servicePlanId");
      initBits &= ~INIT_BIT_SERVICE_PLAN_ID;
      return this;
    }

    /**
     * Builds a new {@link UpdateServicePlanRequest UpdateServicePlanRequest}.
     * @return An immutable instance of UpdateServicePlanRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateServicePlanRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UpdateServicePlanRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_SERVICE_PLAN_ID) != 0) attributes.add("servicePlanId");
      return "Cannot build UpdateServicePlanRequest, some of required attributes are not set " + attributes;
    }
  }
}
