package org.cloudfoundry.client.v2.shareddomains;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.OrderDirection;
import org.cloudfoundry.client.v2.PaginatedRequest;

/**
 * The request payload for the List all Shared Domains operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_ListSharedDomainsRequest"})
public final class ListSharedDomainsRequest
    extends org.cloudfoundry.client.v2.shareddomains._ListSharedDomainsRequest {
  private final @Nullable List<String> names;
  private final @Nullable OrderDirection orderDirection;
  private final @Nullable Integer page;
  private final @Nullable Integer resultsPerPage;

  private ListSharedDomainsRequest(ListSharedDomainsRequest.Builder builder) {
    this.names = builder.names == null ? null : createUnmodifiableList(true, builder.names);
    this.orderDirection = builder.orderDirection;
    this.page = builder.page;
    this.resultsPerPage = builder.resultsPerPage;
  }

  /**
   * The names
   */
  @Override
  public @Nullable List<String> getNames() {
    return names;
  }

  /**
   * The order direction
   */
  @Override
  public @Nullable OrderDirection getOrderDirection() {
    return orderDirection;
  }

  /**
   * The page
   */
  @Override
  public @Nullable Integer getPage() {
    return page;
  }

  /**
   * The results per page
   */
  @Override
  public @Nullable Integer getResultsPerPage() {
    return resultsPerPage;
  }

  /**
   * This instance is equal to all instances of {@code ListSharedDomainsRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListSharedDomainsRequest
        && equalTo((ListSharedDomainsRequest) another);
  }

  private boolean equalTo(ListSharedDomainsRequest another) {
    return Objects.equals(names, another.names)
        && Objects.equals(orderDirection, another.orderDirection)
        && Objects.equals(page, another.page)
        && Objects.equals(resultsPerPage, another.resultsPerPage);
  }

  /**
   * Computes a hash code from attributes: {@code names}, {@code orderDirection}, {@code page}, {@code resultsPerPage}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(names);
    h += (h << 5) + Objects.hashCode(orderDirection);
    h += (h << 5) + Objects.hashCode(page);
    h += (h << 5) + Objects.hashCode(resultsPerPage);
    return h;
  }

  /**
   * Prints the immutable value {@code ListSharedDomainsRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListSharedDomainsRequest{"
        + "names=" + names
        + ", orderDirection=" + orderDirection
        + ", page=" + page
        + ", resultsPerPage=" + resultsPerPage
        + "}";
  }

  /**
   * Creates a builder for {@link ListSharedDomainsRequest ListSharedDomainsRequest}.
   * @return A new ListSharedDomainsRequest builder
   */
  public static ListSharedDomainsRequest.Builder builder() {
    return new ListSharedDomainsRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListSharedDomainsRequest ListSharedDomainsRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private List<String> names = null;
    private OrderDirection orderDirection;
    private Integer page;
    private Integer resultsPerPage;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v2.PaginatedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListSharedDomainsRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListSharedDomainsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListSharedDomainsRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ListSharedDomainsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof PaginatedRequest) {
        PaginatedRequest instance = (PaginatedRequest) object;
        OrderDirection orderDirectionValue = instance.getOrderDirection();
        if (orderDirectionValue != null) {
          orderDirection(orderDirectionValue);
        }
        Integer resultsPerPageValue = instance.getResultsPerPage();
        if (resultsPerPageValue != null) {
          resultsPerPage(resultsPerPageValue);
        }
        Integer pageValue = instance.getPage();
        if (pageValue != null) {
          page(pageValue);
        }
      }
      if (object instanceof org.cloudfoundry.client.v2.shareddomains._ListSharedDomainsRequest) {
        org.cloudfoundry.client.v2.shareddomains._ListSharedDomainsRequest instance = (org.cloudfoundry.client.v2.shareddomains._ListSharedDomainsRequest) object;
        List<String> namesValue = instance.getNames();
        if (namesValue != null) {
          addAllNames(namesValue);
        }
      }
    }

    /**
     * Adds one element to {@link _ListSharedDomainsRequest#getNames() names} list.
     * @param element A names element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String element) {
      if (this.names == null) {
        this.names = new ArrayList<String>();
      }
      this.names.add(Objects.requireNonNull(element, "names element"));
      return this;
    }

    /**
     * Adds elements to {@link _ListSharedDomainsRequest#getNames() names} list.
     * @param elements An array of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String... elements) {
      if (this.names == null) {
        this.names = new ArrayList<String>();
      }
      for (String element : elements) {
        this.names.add(Objects.requireNonNull(element, "names element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _ListSharedDomainsRequest#getNames() names} list.
     * @param elements An iterable of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder names(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.names = null;
        return this;
      }
      this.names = new ArrayList<String>();
      return addAllNames(elements);
    }

    /**
     * Adds elements to {@link _ListSharedDomainsRequest#getNames() names} list.
     * @param elements An iterable of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllNames(Iterable<String> elements) {
      Objects.requireNonNull(elements, "names element");
      if (this.names == null) {
        this.names = new ArrayList<String>();
      }
      for (String element : elements) {
        this.names.add(Objects.requireNonNull(element, "names element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _ListSharedDomainsRequest#getOrderDirection() orderDirection} attribute.
     * @param orderDirection The value for orderDirection (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder orderDirection(@Nullable OrderDirection orderDirection) {
      this.orderDirection = orderDirection;
      return this;
    }

    /**
     * Initializes the value for the {@link _ListSharedDomainsRequest#getPage() page} attribute.
     * @param page The value for page (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder page(@Nullable Integer page) {
      this.page = page;
      return this;
    }

    /**
     * Initializes the value for the {@link _ListSharedDomainsRequest#getResultsPerPage() resultsPerPage} attribute.
     * @param resultsPerPage The value for resultsPerPage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder resultsPerPage(@Nullable Integer resultsPerPage) {
      this.resultsPerPage = resultsPerPage;
      return this;
    }

    /**
     * Builds a new {@link ListSharedDomainsRequest ListSharedDomainsRequest}.
     * @return An immutable instance of ListSharedDomainsRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListSharedDomainsRequest build() {
      return new ListSharedDomainsRequest(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
