package org.cloudfoundry.client.v2.users;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request payload for the Remove Audited Organization from the User operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_RemoveUserAuditedOrganizationRequest"})
public final class RemoveUserAuditedOrganizationRequest
    extends org.cloudfoundry.client.v2.users._RemoveUserAuditedOrganizationRequest {
  private final String auditedOrganizationId;
  private final String userId;

  private RemoveUserAuditedOrganizationRequest(RemoveUserAuditedOrganizationRequest.Builder builder) {
    this.auditedOrganizationId = builder.auditedOrganizationId;
    this.userId = builder.userId;
  }

  /**
   * The id of the audited organization
   */
  @Override
  public String getAuditedOrganizationId() {
    return auditedOrganizationId;
  }

  /**
   * The id of the user
   */
  @Override
  public String getUserId() {
    return userId;
  }

  /**
   * This instance is equal to all instances of {@code RemoveUserAuditedOrganizationRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof RemoveUserAuditedOrganizationRequest
        && equalTo((RemoveUserAuditedOrganizationRequest) another);
  }

  private boolean equalTo(RemoveUserAuditedOrganizationRequest another) {
    return auditedOrganizationId.equals(another.auditedOrganizationId)
        && userId.equals(another.userId);
  }

  /**
   * Computes a hash code from attributes: {@code auditedOrganizationId}, {@code userId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + auditedOrganizationId.hashCode();
    h += (h << 5) + userId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RemoveUserAuditedOrganizationRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RemoveUserAuditedOrganizationRequest{"
        + "auditedOrganizationId=" + auditedOrganizationId
        + ", userId=" + userId
        + "}";
  }

  /**
   * Creates a builder for {@link RemoveUserAuditedOrganizationRequest RemoveUserAuditedOrganizationRequest}.
   * @return A new RemoveUserAuditedOrganizationRequest builder
   */
  public static RemoveUserAuditedOrganizationRequest.Builder builder() {
    return new RemoveUserAuditedOrganizationRequest.Builder();
  }

  /**
   * Builds instances of type {@link RemoveUserAuditedOrganizationRequest RemoveUserAuditedOrganizationRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_AUDITED_ORGANIZATION_ID = 0x1L;
    private static final long INIT_BIT_USER_ID = 0x2L;
    private long initBits = 0x3L;

    private String auditedOrganizationId;
    private String userId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RemoveUserAuditedOrganizationRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RemoveUserAuditedOrganizationRequest instance) {
      return from((_RemoveUserAuditedOrganizationRequest) instance);
    }

    /**
     * Copy abstract value type {@code _RemoveUserAuditedOrganizationRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_RemoveUserAuditedOrganizationRequest instance) {
      Objects.requireNonNull(instance, "instance");
      auditedOrganizationId(instance.getAuditedOrganizationId());
      userId(instance.getUserId());
      return this;
    }

    /**
     * Initializes the value for the {@link _RemoveUserAuditedOrganizationRequest#getAuditedOrganizationId() auditedOrganizationId} attribute.
     * @param auditedOrganizationId The value for auditedOrganizationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder auditedOrganizationId(String auditedOrganizationId) {
      this.auditedOrganizationId = Objects.requireNonNull(auditedOrganizationId, "auditedOrganizationId");
      initBits &= ~INIT_BIT_AUDITED_ORGANIZATION_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _RemoveUserAuditedOrganizationRequest#getUserId() userId} attribute.
     * @param userId The value for userId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder userId(String userId) {
      this.userId = Objects.requireNonNull(userId, "userId");
      initBits &= ~INIT_BIT_USER_ID;
      return this;
    }

    /**
     * Builds a new {@link RemoveUserAuditedOrganizationRequest RemoveUserAuditedOrganizationRequest}.
     * @return An immutable instance of RemoveUserAuditedOrganizationRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public RemoveUserAuditedOrganizationRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new RemoveUserAuditedOrganizationRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_AUDITED_ORGANIZATION_ID) != 0) attributes.add("auditedOrganizationId");
      if ((initBits & INIT_BIT_USER_ID) != 0) attributes.add("userId");
      return "Cannot build RemoveUserAuditedOrganizationRequest, some of required attributes are not set " + attributes;
    }
  }
}
