package org.cloudfoundry.client.v3.applications;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.PaginatedRequest;
import org.cloudfoundry.client.v3.packages.PackageState;
import org.cloudfoundry.client.v3.packages.PackageType;

/**
 * The request payload for the List Application Packages operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_ListApplicationPackagesRequest"})
public final class ListApplicationPackagesRequest
    extends org.cloudfoundry.client.v3.applications._ListApplicationPackagesRequest {
  private final String applicationId;
  private final List<String> packageIds;
  private final List<PackageState> states;
  private final List<PackageType> types;
  private final @Nullable String orderBy;
  private final @Nullable Integer page;
  private final @Nullable Integer perPage;

  private ListApplicationPackagesRequest(ListApplicationPackagesRequest.Builder builder) {
    this.applicationId = builder.applicationId;
    this.packageIds = createUnmodifiableList(true, builder.packageIds);
    this.states = createUnmodifiableList(true, builder.states);
    this.types = createUnmodifiableList(true, builder.types);
    this.orderBy = builder.orderBy;
    this.page = builder.page;
    this.perPage = builder.perPage;
  }

  /**
   * The application id
   */
  @Override
  public String getApplicationId() {
    return applicationId;
  }

  /**
   * Package ids to filter by
   */
  @Override
  public List<String> getPackageIds() {
    return packageIds;
  }

  /**
   * Package states to filter by
   */
  @Override
  public List<PackageState> getStates() {
    return states;
  }

  /**
   * Package types to filter by
   */
  @Override
  public List<PackageType> getTypes() {
    return types;
  }

  /**
   * The order by
   */
  @Override
  public @Nullable String getOrderBy() {
    return orderBy;
  }

  /**
   * The page
   */
  @Override
  public @Nullable Integer getPage() {
    return page;
  }

  /**
   * The results per page
   */
  @Override
  public @Nullable Integer getPerPage() {
    return perPage;
  }

  /**
   * This instance is equal to all instances of {@code ListApplicationPackagesRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListApplicationPackagesRequest
        && equalTo((ListApplicationPackagesRequest) another);
  }

  private boolean equalTo(ListApplicationPackagesRequest another) {
    return applicationId.equals(another.applicationId)
        && packageIds.equals(another.packageIds)
        && states.equals(another.states)
        && types.equals(another.types)
        && Objects.equals(orderBy, another.orderBy)
        && Objects.equals(page, another.page)
        && Objects.equals(perPage, another.perPage);
  }

  /**
   * Computes a hash code from attributes: {@code applicationId}, {@code packageIds}, {@code states}, {@code types}, {@code orderBy}, {@code page}, {@code perPage}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + applicationId.hashCode();
    h += (h << 5) + packageIds.hashCode();
    h += (h << 5) + states.hashCode();
    h += (h << 5) + types.hashCode();
    h += (h << 5) + Objects.hashCode(orderBy);
    h += (h << 5) + Objects.hashCode(page);
    h += (h << 5) + Objects.hashCode(perPage);
    return h;
  }

  /**
   * Prints the immutable value {@code ListApplicationPackagesRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListApplicationPackagesRequest{"
        + "applicationId=" + applicationId
        + ", packageIds=" + packageIds
        + ", states=" + states
        + ", types=" + types
        + ", orderBy=" + orderBy
        + ", page=" + page
        + ", perPage=" + perPage
        + "}";
  }

  /**
   * Creates a builder for {@link ListApplicationPackagesRequest ListApplicationPackagesRequest}.
   * @return A new ListApplicationPackagesRequest builder
   */
  public static ListApplicationPackagesRequest.Builder builder() {
    return new ListApplicationPackagesRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListApplicationPackagesRequest ListApplicationPackagesRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_APPLICATION_ID = 0x1L;
    private long initBits = 0x1L;

    private String applicationId;
    private List<String> packageIds = new ArrayList<String>();
    private List<PackageState> states = new ArrayList<PackageState>();
    private List<PackageType> types = new ArrayList<PackageType>();
    private String orderBy;
    private Integer page;
    private Integer perPage;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListApplicationPackagesRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListApplicationPackagesRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListApplicationPackagesRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ListApplicationPackagesRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.PaginatedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof org.cloudfoundry.client.v3.applications._ListApplicationPackagesRequest) {
        org.cloudfoundry.client.v3.applications._ListApplicationPackagesRequest instance = (org.cloudfoundry.client.v3.applications._ListApplicationPackagesRequest) object;
        addAllTypes(instance.getTypes());
        applicationId(instance.getApplicationId());
        addAllPackageIds(instance.getPackageIds());
        addAllStates(instance.getStates());
      }
      if (object instanceof PaginatedRequest) {
        PaginatedRequest instance = (PaginatedRequest) object;
        String orderByValue = instance.getOrderBy();
        if (orderByValue != null) {
          orderBy(orderByValue);
        }
        Integer perPageValue = instance.getPerPage();
        if (perPageValue != null) {
          perPage(perPageValue);
        }
        Integer pageValue = instance.getPage();
        if (pageValue != null) {
          page(pageValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link _ListApplicationPackagesRequest#getApplicationId() applicationId} attribute.
     * @param applicationId The value for applicationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationId(String applicationId) {
      this.applicationId = Objects.requireNonNull(applicationId, "applicationId");
      initBits &= ~INIT_BIT_APPLICATION_ID;
      return this;
    }

    /**
     * Adds one element to {@link _ListApplicationPackagesRequest#getPackageIds() packageIds} list.
     * @param element A packageIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder packageId(String element) {
      this.packageIds.add(Objects.requireNonNull(element, "packageIds element"));
      return this;
    }

    /**
     * Adds elements to {@link _ListApplicationPackagesRequest#getPackageIds() packageIds} list.
     * @param elements An array of packageIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder packageId(String... elements) {
      for (String element : elements) {
        this.packageIds.add(Objects.requireNonNull(element, "packageIds element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _ListApplicationPackagesRequest#getPackageIds() packageIds} list.
     * @param elements An iterable of packageIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder packageIds(Iterable<String> elements) {
      this.packageIds.clear();
      return addAllPackageIds(elements);
    }

    /**
     * Adds elements to {@link _ListApplicationPackagesRequest#getPackageIds() packageIds} list.
     * @param elements An iterable of packageIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllPackageIds(Iterable<String> elements) {
      for (String element : elements) {
        this.packageIds.add(Objects.requireNonNull(element, "packageIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link _ListApplicationPackagesRequest#getStates() states} list.
     * @param element A states element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder state(PackageState element) {
      this.states.add(Objects.requireNonNull(element, "states element"));
      return this;
    }

    /**
     * Adds elements to {@link _ListApplicationPackagesRequest#getStates() states} list.
     * @param elements An array of states elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder state(PackageState... elements) {
      for (PackageState element : elements) {
        this.states.add(Objects.requireNonNull(element, "states element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _ListApplicationPackagesRequest#getStates() states} list.
     * @param elements An iterable of states elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder states(Iterable<? extends PackageState> elements) {
      this.states.clear();
      return addAllStates(elements);
    }

    /**
     * Adds elements to {@link _ListApplicationPackagesRequest#getStates() states} list.
     * @param elements An iterable of states elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllStates(Iterable<? extends PackageState> elements) {
      for (PackageState element : elements) {
        this.states.add(Objects.requireNonNull(element, "states element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link _ListApplicationPackagesRequest#getTypes() types} list.
     * @param element A types element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder type(PackageType element) {
      this.types.add(Objects.requireNonNull(element, "types element"));
      return this;
    }

    /**
     * Adds elements to {@link _ListApplicationPackagesRequest#getTypes() types} list.
     * @param elements An array of types elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder type(PackageType... elements) {
      for (PackageType element : elements) {
        this.types.add(Objects.requireNonNull(element, "types element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _ListApplicationPackagesRequest#getTypes() types} list.
     * @param elements An iterable of types elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder types(Iterable<? extends PackageType> elements) {
      this.types.clear();
      return addAllTypes(elements);
    }

    /**
     * Adds elements to {@link _ListApplicationPackagesRequest#getTypes() types} list.
     * @param elements An iterable of types elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllTypes(Iterable<? extends PackageType> elements) {
      for (PackageType element : elements) {
        this.types.add(Objects.requireNonNull(element, "types element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _ListApplicationPackagesRequest#getOrderBy() orderBy} attribute.
     * @param orderBy The value for orderBy (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder orderBy(@Nullable String orderBy) {
      this.orderBy = orderBy;
      return this;
    }

    /**
     * Initializes the value for the {@link _ListApplicationPackagesRequest#getPage() page} attribute.
     * @param page The value for page (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder page(@Nullable Integer page) {
      this.page = page;
      return this;
    }

    /**
     * Initializes the value for the {@link _ListApplicationPackagesRequest#getPerPage() perPage} attribute.
     * @param perPage The value for perPage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder perPage(@Nullable Integer perPage) {
      this.perPage = perPage;
      return this;
    }

    /**
     * Builds a new {@link ListApplicationPackagesRequest ListApplicationPackagesRequest}.
     * @return An immutable instance of ListApplicationPackagesRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListApplicationPackagesRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ListApplicationPackagesRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_APPLICATION_ID) != 0) attributes.add("applicationId");
      return "Cannot build ListApplicationPackagesRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
