package org.cloudfoundry.client.v3.processes;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * A mapping of internal to external ports
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_PortMapping"})
public final class PortMapping extends org.cloudfoundry.client.v3.processes._PortMapping {
  private final Integer external;
  private final Integer internal;

  private PortMapping(PortMapping.Builder builder) {
    this.external = builder.external;
    this.internal = builder.internal;
  }

  /**
   * The external port
   */
  @JsonProperty("external")
  @Override
  public Integer getExternal() {
    return external;
  }

  /**
   * The internal port
   */
  @JsonProperty("internal")
  @Override
  public Integer getInternal() {
    return internal;
  }

  /**
   * This instance is equal to all instances of {@code PortMapping} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof PortMapping
        && equalTo((PortMapping) another);
  }

  private boolean equalTo(PortMapping another) {
    return external.equals(another.external)
        && internal.equals(another.internal);
  }

  /**
   * Computes a hash code from attributes: {@code external}, {@code internal}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + external.hashCode();
    h += (h << 5) + internal.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code PortMapping} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "PortMapping{"
        + "external=" + external
        + ", internal=" + internal
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.processes._PortMapping {
    Integer external;
    Integer internal;
    @JsonProperty("external")
    public void setExternal(Integer external) {
      this.external = external;
    }
    @JsonProperty("internal")
    public void setInternal(Integer internal) {
      this.internal = internal;
    }
    @Override
    public Integer getExternal() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getInternal() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static PortMapping fromJson(Json json) {
    PortMapping.Builder builder = PortMapping.builder();
    if (json.external != null) {
      builder.external(json.external);
    }
    if (json.internal != null) {
      builder.internal(json.internal);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link PortMapping PortMapping}.
   * @return A new PortMapping builder
   */
  public static PortMapping.Builder builder() {
    return new PortMapping.Builder();
  }

  /**
   * Builds instances of type {@link PortMapping PortMapping}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_EXTERNAL = 0x1L;
    private static final long INIT_BIT_INTERNAL = 0x2L;
    private long initBits = 0x3L;

    private Integer external;
    private Integer internal;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code PortMapping} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PortMapping instance) {
      return from((_PortMapping) instance);
    }

    /**
     * Copy abstract value type {@code _PortMapping} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_PortMapping instance) {
      Objects.requireNonNull(instance, "instance");
      external(instance.getExternal());
      internal(instance.getInternal());
      return this;
    }

    /**
     * Initializes the value for the {@link _PortMapping#getExternal() external} attribute.
     * @param external The value for external 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("external")
    public final Builder external(Integer external) {
      this.external = Objects.requireNonNull(external, "external");
      initBits &= ~INIT_BIT_EXTERNAL;
      return this;
    }

    /**
     * Initializes the value for the {@link _PortMapping#getInternal() internal} attribute.
     * @param internal The value for internal 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("internal")
    public final Builder internal(Integer internal) {
      this.internal = Objects.requireNonNull(internal, "internal");
      initBits &= ~INIT_BIT_INTERNAL;
      return this;
    }

    /**
     * Builds a new {@link PortMapping PortMapping}.
     * @return An immutable instance of PortMapping
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public PortMapping build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new PortMapping(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_EXTERNAL) != 0) attributes.add("external");
      if ((initBits & INIT_BIT_INTERNAL) != 0) attributes.add("internal");
      return "Cannot build PortMapping, some of required attributes are not set " + attributes;
    }
  }
}
