package org.cloudfoundry.client.v3.servicebindings;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request payload for the Get Service Binding operation.
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_GetServiceBindingRequest"})
public final class GetServiceBindingRequest
    extends org.cloudfoundry.client.v3.servicebindings._GetServiceBindingRequest {
  private final String serviceBindingId;

  private GetServiceBindingRequest(GetServiceBindingRequest.Builder builder) {
    this.serviceBindingId = builder.serviceBindingId;
  }

  /**
   * The service binding id
   */
  @Override
  public String getServiceBindingId() {
    return serviceBindingId;
  }

  /**
   * This instance is equal to all instances of {@code GetServiceBindingRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetServiceBindingRequest
        && equalTo((GetServiceBindingRequest) another);
  }

  private boolean equalTo(GetServiceBindingRequest another) {
    return serviceBindingId.equals(another.serviceBindingId);
  }

  /**
   * Computes a hash code from attributes: {@code serviceBindingId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + serviceBindingId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetServiceBindingRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetServiceBindingRequest{"
        + "serviceBindingId=" + serviceBindingId
        + "}";
  }

  /**
   * Creates a builder for {@link GetServiceBindingRequest GetServiceBindingRequest}.
   * @return A new GetServiceBindingRequest builder
   */
  public static GetServiceBindingRequest.Builder builder() {
    return new GetServiceBindingRequest.Builder();
  }

  /**
   * Builds instances of type {@link GetServiceBindingRequest GetServiceBindingRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_SERVICE_BINDING_ID = 0x1L;
    private long initBits = 0x1L;

    private String serviceBindingId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetServiceBindingRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetServiceBindingRequest instance) {
      return from((_GetServiceBindingRequest) instance);
    }

    /**
     * Copy abstract value type {@code _GetServiceBindingRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetServiceBindingRequest instance) {
      Objects.requireNonNull(instance, "instance");
      serviceBindingId(instance.getServiceBindingId());
      return this;
    }

    /**
     * Initializes the value for the {@link _GetServiceBindingRequest#getServiceBindingId() serviceBindingId} attribute.
     * @param serviceBindingId The value for serviceBindingId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceBindingId(String serviceBindingId) {
      this.serviceBindingId = Objects.requireNonNull(serviceBindingId, "serviceBindingId");
      initBits &= ~INIT_BIT_SERVICE_BINDING_ID;
      return this;
    }

    /**
     * Builds a new {@link GetServiceBindingRequest GetServiceBindingRequest}.
     * @return An immutable instance of GetServiceBindingRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetServiceBindingRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetServiceBindingRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_SERVICE_BINDING_ID) != 0) attributes.add("serviceBindingId");
      return "Cannot build GetServiceBindingRequest, some of required attributes are not set " + attributes;
    }
  }
}
