package org.cloudfoundry.client.v3.tasks;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request payload for the Cancel Task endpoint
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_CancelTaskRequest"})
public final class CancelTaskRequest extends org.cloudfoundry.client.v3.tasks._CancelTaskRequest {
  private final String taskId;

  private CancelTaskRequest(CancelTaskRequest.Builder builder) {
    this.taskId = builder.taskId;
  }

  /**
   * The task id
   */
  @Override
  public String getTaskId() {
    return taskId;
  }

  /**
   * This instance is equal to all instances of {@code CancelTaskRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CancelTaskRequest
        && equalTo((CancelTaskRequest) another);
  }

  private boolean equalTo(CancelTaskRequest another) {
    return taskId.equals(another.taskId);
  }

  /**
   * Computes a hash code from attributes: {@code taskId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + taskId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CancelTaskRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CancelTaskRequest{"
        + "taskId=" + taskId
        + "}";
  }

  /**
   * Creates a builder for {@link CancelTaskRequest CancelTaskRequest}.
   * @return A new CancelTaskRequest builder
   */
  public static CancelTaskRequest.Builder builder() {
    return new CancelTaskRequest.Builder();
  }

  /**
   * Builds instances of type {@link CancelTaskRequest CancelTaskRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_TASK_ID = 0x1L;
    private long initBits = 0x1L;

    private String taskId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CancelTaskRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CancelTaskRequest instance) {
      return from((_CancelTaskRequest) instance);
    }

    /**
     * Copy abstract value type {@code _CancelTaskRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CancelTaskRequest instance) {
      Objects.requireNonNull(instance, "instance");
      taskId(instance.getTaskId());
      return this;
    }

    /**
     * Initializes the value for the {@link _CancelTaskRequest#getTaskId() taskId} attribute.
     * @param taskId The value for taskId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder taskId(String taskId) {
      this.taskId = Objects.requireNonNull(taskId, "taskId");
      initBits &= ~INIT_BIT_TASK_ID;
      return this;
    }

    /**
     * Builds a new {@link CancelTaskRequest CancelTaskRequest}.
     * @return An immutable instance of CancelTaskRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CancelTaskRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CancelTaskRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_TASK_ID) != 0) attributes.add("taskId");
      return "Cannot build CancelTaskRequest, some of required attributes are not set " + attributes;
    }
  }
}
