package org.cloudfoundry.client.v3.tasks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.PaginatedRequest;

/**
 * The request payload for the List Applications operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_ListTasksRequest"})
public final class ListTasksRequest extends org.cloudfoundry.client.v3.tasks._ListTasksRequest {
  private final List<String> applicationIds;
  private final List<String> names;
  private final List<String> organizationIds;
  private final List<String> spaceIds;
  private final List<TaskState> states;
  private final List<String> taskIds;
  private final @Nullable String orderBy;
  private final @Nullable Integer page;
  private final @Nullable Integer perPage;

  private ListTasksRequest(ListTasksRequest.Builder builder) {
    this.applicationIds = createUnmodifiableList(true, builder.applicationIds);
    this.names = createUnmodifiableList(true, builder.names);
    this.organizationIds = createUnmodifiableList(true, builder.organizationIds);
    this.spaceIds = createUnmodifiableList(true, builder.spaceIds);
    this.states = createUnmodifiableList(true, builder.states);
    this.taskIds = createUnmodifiableList(true, builder.taskIds);
    this.orderBy = builder.orderBy;
    this.page = builder.page;
    this.perPage = builder.perPage;
  }

  /**
   * The application ids
   */
  @Override
  public List<String> getApplicationIds() {
    return applicationIds;
  }

  /**
   * The names
   */
  @Override
  public List<String> getNames() {
    return names;
  }

  /**
   * The organization ids
   */
  @Override
  public List<String> getOrganizationIds() {
    return organizationIds;
  }

  /**
   * The space ids
   */
  @Override
  public List<String> getSpaceIds() {
    return spaceIds;
  }

  /**
   * The states
   */
  @Override
  public List<TaskState> getStates() {
    return states;
  }

  /**
   * The ids
   */
  @Override
  public List<String> getTaskIds() {
    return taskIds;
  }

  /**
   * The order by
   */
  @Override
  public @Nullable String getOrderBy() {
    return orderBy;
  }

  /**
   * The page
   */
  @Override
  public @Nullable Integer getPage() {
    return page;
  }

  /**
   * The results per page
   */
  @Override
  public @Nullable Integer getPerPage() {
    return perPage;
  }

  /**
   * This instance is equal to all instances of {@code ListTasksRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListTasksRequest
        && equalTo((ListTasksRequest) another);
  }

  private boolean equalTo(ListTasksRequest another) {
    return applicationIds.equals(another.applicationIds)
        && names.equals(another.names)
        && organizationIds.equals(another.organizationIds)
        && spaceIds.equals(another.spaceIds)
        && states.equals(another.states)
        && taskIds.equals(another.taskIds)
        && Objects.equals(orderBy, another.orderBy)
        && Objects.equals(page, another.page)
        && Objects.equals(perPage, another.perPage);
  }

  /**
   * Computes a hash code from attributes: {@code applicationIds}, {@code names}, {@code organizationIds}, {@code spaceIds}, {@code states}, {@code taskIds}, {@code orderBy}, {@code page}, {@code perPage}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + applicationIds.hashCode();
    h += (h << 5) + names.hashCode();
    h += (h << 5) + organizationIds.hashCode();
    h += (h << 5) + spaceIds.hashCode();
    h += (h << 5) + states.hashCode();
    h += (h << 5) + taskIds.hashCode();
    h += (h << 5) + Objects.hashCode(orderBy);
    h += (h << 5) + Objects.hashCode(page);
    h += (h << 5) + Objects.hashCode(perPage);
    return h;
  }

  /**
   * Prints the immutable value {@code ListTasksRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListTasksRequest{"
        + "applicationIds=" + applicationIds
        + ", names=" + names
        + ", organizationIds=" + organizationIds
        + ", spaceIds=" + spaceIds
        + ", states=" + states
        + ", taskIds=" + taskIds
        + ", orderBy=" + orderBy
        + ", page=" + page
        + ", perPage=" + perPage
        + "}";
  }

  /**
   * Creates a builder for {@link ListTasksRequest ListTasksRequest}.
   * @return A new ListTasksRequest builder
   */
  public static ListTasksRequest.Builder builder() {
    return new ListTasksRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListTasksRequest ListTasksRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private List<String> applicationIds = new ArrayList<String>();
    private List<String> names = new ArrayList<String>();
    private List<String> organizationIds = new ArrayList<String>();
    private List<String> spaceIds = new ArrayList<String>();
    private List<TaskState> states = new ArrayList<TaskState>();
    private List<String> taskIds = new ArrayList<String>();
    private String orderBy;
    private Integer page;
    private Integer perPage;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.PaginatedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListTasksRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListTasksRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListTasksRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ListTasksRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof PaginatedRequest) {
        PaginatedRequest instance = (PaginatedRequest) object;
        String orderByValue = instance.getOrderBy();
        if (orderByValue != null) {
          orderBy(orderByValue);
        }
        Integer perPageValue = instance.getPerPage();
        if (perPageValue != null) {
          perPage(perPageValue);
        }
        Integer pageValue = instance.getPage();
        if (pageValue != null) {
          page(pageValue);
        }
      }
      if (object instanceof org.cloudfoundry.client.v3.tasks._ListTasksRequest) {
        org.cloudfoundry.client.v3.tasks._ListTasksRequest instance = (org.cloudfoundry.client.v3.tasks._ListTasksRequest) object;
        addAllNames(instance.getNames());
        addAllSpaceIds(instance.getSpaceIds());
        addAllTaskIds(instance.getTaskIds());
        addAllOrganizationIds(instance.getOrganizationIds());
        addAllApplicationIds(instance.getApplicationIds());
        addAllStates(instance.getStates());
      }
    }

    /**
     * Adds one element to {@link _ListTasksRequest#getApplicationIds() applicationIds} list.
     * @param element A applicationIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationId(String element) {
      this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
      return this;
    }

    /**
     * Adds elements to {@link _ListTasksRequest#getApplicationIds() applicationIds} list.
     * @param elements An array of applicationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationId(String... elements) {
      for (String element : elements) {
        this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _ListTasksRequest#getApplicationIds() applicationIds} list.
     * @param elements An iterable of applicationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationIds(Iterable<String> elements) {
      this.applicationIds.clear();
      return addAllApplicationIds(elements);
    }

    /**
     * Adds elements to {@link _ListTasksRequest#getApplicationIds() applicationIds} list.
     * @param elements An iterable of applicationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllApplicationIds(Iterable<String> elements) {
      for (String element : elements) {
        this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link _ListTasksRequest#getNames() names} list.
     * @param element A names element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String element) {
      this.names.add(Objects.requireNonNull(element, "names element"));
      return this;
    }

    /**
     * Adds elements to {@link _ListTasksRequest#getNames() names} list.
     * @param elements An array of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String... elements) {
      for (String element : elements) {
        this.names.add(Objects.requireNonNull(element, "names element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _ListTasksRequest#getNames() names} list.
     * @param elements An iterable of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder names(Iterable<String> elements) {
      this.names.clear();
      return addAllNames(elements);
    }

    /**
     * Adds elements to {@link _ListTasksRequest#getNames() names} list.
     * @param elements An iterable of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllNames(Iterable<String> elements) {
      for (String element : elements) {
        this.names.add(Objects.requireNonNull(element, "names element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link _ListTasksRequest#getOrganizationIds() organizationIds} list.
     * @param element A organizationIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(String element) {
      this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
      return this;
    }

    /**
     * Adds elements to {@link _ListTasksRequest#getOrganizationIds() organizationIds} list.
     * @param elements An array of organizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(String... elements) {
      for (String element : elements) {
        this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _ListTasksRequest#getOrganizationIds() organizationIds} list.
     * @param elements An iterable of organizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationIds(Iterable<String> elements) {
      this.organizationIds.clear();
      return addAllOrganizationIds(elements);
    }

    /**
     * Adds elements to {@link _ListTasksRequest#getOrganizationIds() organizationIds} list.
     * @param elements An iterable of organizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllOrganizationIds(Iterable<String> elements) {
      for (String element : elements) {
        this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link _ListTasksRequest#getSpaceIds() spaceIds} list.
     * @param element A spaceIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(String element) {
      this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
      return this;
    }

    /**
     * Adds elements to {@link _ListTasksRequest#getSpaceIds() spaceIds} list.
     * @param elements An array of spaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(String... elements) {
      for (String element : elements) {
        this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _ListTasksRequest#getSpaceIds() spaceIds} list.
     * @param elements An iterable of spaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceIds(Iterable<String> elements) {
      this.spaceIds.clear();
      return addAllSpaceIds(elements);
    }

    /**
     * Adds elements to {@link _ListTasksRequest#getSpaceIds() spaceIds} list.
     * @param elements An iterable of spaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSpaceIds(Iterable<String> elements) {
      for (String element : elements) {
        this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link _ListTasksRequest#getStates() states} list.
     * @param element A states element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder state(TaskState element) {
      this.states.add(Objects.requireNonNull(element, "states element"));
      return this;
    }

    /**
     * Adds elements to {@link _ListTasksRequest#getStates() states} list.
     * @param elements An array of states elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder state(TaskState... elements) {
      for (TaskState element : elements) {
        this.states.add(Objects.requireNonNull(element, "states element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _ListTasksRequest#getStates() states} list.
     * @param elements An iterable of states elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder states(Iterable<? extends TaskState> elements) {
      this.states.clear();
      return addAllStates(elements);
    }

    /**
     * Adds elements to {@link _ListTasksRequest#getStates() states} list.
     * @param elements An iterable of states elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllStates(Iterable<? extends TaskState> elements) {
      for (TaskState element : elements) {
        this.states.add(Objects.requireNonNull(element, "states element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link _ListTasksRequest#getTaskIds() taskIds} list.
     * @param element A taskIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder taskId(String element) {
      this.taskIds.add(Objects.requireNonNull(element, "taskIds element"));
      return this;
    }

    /**
     * Adds elements to {@link _ListTasksRequest#getTaskIds() taskIds} list.
     * @param elements An array of taskIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder taskId(String... elements) {
      for (String element : elements) {
        this.taskIds.add(Objects.requireNonNull(element, "taskIds element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _ListTasksRequest#getTaskIds() taskIds} list.
     * @param elements An iterable of taskIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder taskIds(Iterable<String> elements) {
      this.taskIds.clear();
      return addAllTaskIds(elements);
    }

    /**
     * Adds elements to {@link _ListTasksRequest#getTaskIds() taskIds} list.
     * @param elements An iterable of taskIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllTaskIds(Iterable<String> elements) {
      for (String element : elements) {
        this.taskIds.add(Objects.requireNonNull(element, "taskIds element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _ListTasksRequest#getOrderBy() orderBy} attribute.
     * @param orderBy The value for orderBy (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder orderBy(@Nullable String orderBy) {
      this.orderBy = orderBy;
      return this;
    }

    /**
     * Initializes the value for the {@link _ListTasksRequest#getPage() page} attribute.
     * @param page The value for page (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder page(@Nullable Integer page) {
      this.page = page;
      return this;
    }

    /**
     * Initializes the value for the {@link _ListTasksRequest#getPerPage() perPage} attribute.
     * @param perPage The value for perPage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder perPage(@Nullable Integer perPage) {
      this.perPage = perPage;
      return this;
    }

    /**
     * Builds a new {@link ListTasksRequest ListTasksRequest}.
     * @return An immutable instance of ListTasksRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListTasksRequest build() {
      return new ListTasksRequest(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
