package org.cloudfoundry.networking.v1.policies;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The payload for Policy responses
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_Policy"})
public final class Policy extends org.cloudfoundry.networking.v1.policies._Policy {
  private final Destination destination;
  private final Source source;

  private Policy(Policy.Builder builder) {
    this.destination = builder.destination;
    this.source = builder.source;
  }

  /**
   * Destination for the Policy
   */
  @JsonProperty("destination")
  @Override
  public Destination getDestination() {
    return destination;
  }

  /**
   * Source for the Policy
   */
  @JsonProperty("source")
  @Override
  public Source getSource() {
    return source;
  }

  /**
   * This instance is equal to all instances of {@code Policy} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Policy
        && equalTo((Policy) another);
  }

  private boolean equalTo(Policy another) {
    return destination.equals(another.destination)
        && source.equals(another.source);
  }

  /**
   * Computes a hash code from attributes: {@code destination}, {@code source}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + destination.hashCode();
    h += (h << 5) + source.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Policy} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Policy{"
        + "destination=" + destination
        + ", source=" + source
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.networking.v1.policies._Policy {
    Destination destination;
    Source source;
    @JsonProperty("destination")
    public void setDestination(Destination destination) {
      this.destination = destination;
    }
    @JsonProperty("source")
    public void setSource(Source source) {
      this.source = source;
    }
    @Override
    public Destination getDestination() { throw new UnsupportedOperationException(); }
    @Override
    public Source getSource() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static Policy fromJson(Json json) {
    Policy.Builder builder = Policy.builder();
    if (json.destination != null) {
      builder.destination(json.destination);
    }
    if (json.source != null) {
      builder.source(json.source);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Policy Policy}.
   * @return A new Policy builder
   */
  public static Policy.Builder builder() {
    return new Policy.Builder();
  }

  /**
   * Builds instances of type {@link Policy Policy}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_DESTINATION = 0x1L;
    private static final long INIT_BIT_SOURCE = 0x2L;
    private long initBits = 0x3L;

    private Destination destination;
    private Source source;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Policy} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Policy instance) {
      return from((_Policy) instance);
    }

    /**
     * Copy abstract value type {@code _Policy} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Policy instance) {
      Objects.requireNonNull(instance, "instance");
      destination(instance.getDestination());
      source(instance.getSource());
      return this;
    }

    /**
     * Initializes the value for the {@link _Policy#getDestination() destination} attribute.
     * @param destination The value for destination 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("destination")
    public final Builder destination(Destination destination) {
      this.destination = Objects.requireNonNull(destination, "destination");
      initBits &= ~INIT_BIT_DESTINATION;
      return this;
    }

    /**
     * Initializes the value for the {@link _Policy#getSource() source} attribute.
     * @param source The value for source 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("source")
    public final Builder source(Source source) {
      this.source = Objects.requireNonNull(source, "source");
      initBits &= ~INIT_BIT_SOURCE;
      return this;
    }

    /**
     * Builds a new {@link Policy Policy}.
     * @return An immutable instance of Policy
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Policy build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new Policy(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_DESTINATION) != 0) attributes.add("destination");
      if ((initBits & INIT_BIT_SOURCE) != 0) attributes.add("source");
      return "Cannot build Policy, some of required attributes are not set " + attributes;
    }
  }
}
