package org.cloudfoundry.networking.v1.tags;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The response payload for the List Tags operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_ListTagsResponse"})
public final class ListTagsResponse extends org.cloudfoundry.networking.v1.tags._ListTagsResponse {
  private final List<Tag> tags;

  private ListTagsResponse(ListTagsResponse.Builder builder) {
    this.tags = createUnmodifiableList(true, builder.tags);
  }

  /**
   * The policies
   */
  @JsonProperty("tags")
  @Override
  public List<Tag> getTags() {
    return tags;
  }

  /**
   * This instance is equal to all instances of {@code ListTagsResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListTagsResponse
        && equalTo((ListTagsResponse) another);
  }

  private boolean equalTo(ListTagsResponse another) {
    return tags.equals(another.tags);
  }

  /**
   * Computes a hash code from attributes: {@code tags}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + tags.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ListTagsResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListTagsResponse{"
        + "tags=" + tags
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.networking.v1.tags._ListTagsResponse {
    List<Tag> tags = Collections.emptyList();
    @JsonProperty("tags")
    public void setTags(List<Tag> tags) {
      this.tags = tags;
    }
    @Override
    public List<Tag> getTags() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ListTagsResponse fromJson(Json json) {
    ListTagsResponse.Builder builder = ListTagsResponse.builder();
    if (json.tags != null) {
      builder.addAllTags(json.tags);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ListTagsResponse ListTagsResponse}.
   * @return A new ListTagsResponse builder
   */
  public static ListTagsResponse.Builder builder() {
    return new ListTagsResponse.Builder();
  }

  /**
   * Builds instances of type {@link ListTagsResponse ListTagsResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private List<Tag> tags = new ArrayList<Tag>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListTagsResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListTagsResponse instance) {
      return from((_ListTagsResponse) instance);
    }

    /**
     * Copy abstract value type {@code _ListTagsResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ListTagsResponse instance) {
      Objects.requireNonNull(instance, "instance");
      addAllTags(instance.getTags());
      return this;
    }

    /**
     * Adds one element to {@link _ListTagsResponse#getTags() tags} list.
     * @param element A tags element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tag(Tag element) {
      this.tags.add(Objects.requireNonNull(element, "tags element"));
      return this;
    }

    /**
     * Adds elements to {@link _ListTagsResponse#getTags() tags} list.
     * @param elements An array of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tag(Tag... elements) {
      for (Tag element : elements) {
        this.tags.add(Objects.requireNonNull(element, "tags element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _ListTagsResponse#getTags() tags} list.
     * @param elements An iterable of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("tags")
    public final Builder tags(Iterable<? extends Tag> elements) {
      this.tags.clear();
      return addAllTags(elements);
    }

    /**
     * Adds elements to {@link _ListTagsResponse#getTags() tags} list.
     * @param elements An iterable of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllTags(Iterable<? extends Tag> elements) {
      for (Tag element : elements) {
        this.tags.add(Objects.requireNonNull(element, "tags element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ListTagsResponse ListTagsResponse}.
     * @return An immutable instance of ListTagsResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListTagsResponse build() {
      return new ListTagsResponse(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
