package org.cloudfoundry.uaa.identityzones;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The payload for the identity zone client lockout policy
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_ClientLockoutPolicy"})
public final class ClientLockoutPolicy extends org.cloudfoundry.uaa.identityzones._ClientLockoutPolicy {
  private final Integer countFailuresWithin;
  private final Integer lockoutAfterFailures;
  private final Integer lockoutPeriodSeconds;

  private ClientLockoutPolicy(ClientLockoutPolicy.Builder builder) {
    this.countFailuresWithin = builder.countFailuresWithin;
    this.lockoutAfterFailures = builder.lockoutAfterFailures;
    this.lockoutPeriodSeconds = builder.lockoutPeriodSeconds;
  }

  /**
   * Number of seconds in which {@code lockoutAfterFailures} failures must occur in order for account to be locked
   */
  @JsonProperty("countFailuresWithin")
  @Override
  public Integer getCountFailuresWithin() {
    return countFailuresWithin;
  }

  /**
   * Number of allowed failures before account is locked
   */
  @JsonProperty("lockoutAfterFailures")
  @Override
  public Integer getLockoutAfterFailures() {
    return lockoutAfterFailures;
  }

  /**
   * Number of seconds to lock out an account when lockoutAfterFailures failures is exceeded
   */
  @JsonProperty("lockoutPeriodSeconds")
  @Override
  public Integer getLockoutPeriodSeconds() {
    return lockoutPeriodSeconds;
  }

  /**
   * This instance is equal to all instances of {@code ClientLockoutPolicy} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ClientLockoutPolicy
        && equalTo((ClientLockoutPolicy) another);
  }

  private boolean equalTo(ClientLockoutPolicy another) {
    return countFailuresWithin.equals(another.countFailuresWithin)
        && lockoutAfterFailures.equals(another.lockoutAfterFailures)
        && lockoutPeriodSeconds.equals(another.lockoutPeriodSeconds);
  }

  /**
   * Computes a hash code from attributes: {@code countFailuresWithin}, {@code lockoutAfterFailures}, {@code lockoutPeriodSeconds}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + countFailuresWithin.hashCode();
    h += (h << 5) + lockoutAfterFailures.hashCode();
    h += (h << 5) + lockoutPeriodSeconds.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ClientLockoutPolicy} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ClientLockoutPolicy{"
        + "countFailuresWithin=" + countFailuresWithin
        + ", lockoutAfterFailures=" + lockoutAfterFailures
        + ", lockoutPeriodSeconds=" + lockoutPeriodSeconds
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.identityzones._ClientLockoutPolicy {
    Integer countFailuresWithin;
    Integer lockoutAfterFailures;
    Integer lockoutPeriodSeconds;
    @JsonProperty("countFailuresWithin")
    public void setCountFailuresWithin(Integer countFailuresWithin) {
      this.countFailuresWithin = countFailuresWithin;
    }
    @JsonProperty("lockoutAfterFailures")
    public void setLockoutAfterFailures(Integer lockoutAfterFailures) {
      this.lockoutAfterFailures = lockoutAfterFailures;
    }
    @JsonProperty("lockoutPeriodSeconds")
    public void setLockoutPeriodSeconds(Integer lockoutPeriodSeconds) {
      this.lockoutPeriodSeconds = lockoutPeriodSeconds;
    }
    @Override
    public Integer getCountFailuresWithin() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getLockoutAfterFailures() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getLockoutPeriodSeconds() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ClientLockoutPolicy fromJson(Json json) {
    ClientLockoutPolicy.Builder builder = ClientLockoutPolicy.builder();
    if (json.countFailuresWithin != null) {
      builder.countFailuresWithin(json.countFailuresWithin);
    }
    if (json.lockoutAfterFailures != null) {
      builder.lockoutAfterFailures(json.lockoutAfterFailures);
    }
    if (json.lockoutPeriodSeconds != null) {
      builder.lockoutPeriodSeconds(json.lockoutPeriodSeconds);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ClientLockoutPolicy ClientLockoutPolicy}.
   * @return A new ClientLockoutPolicy builder
   */
  public static ClientLockoutPolicy.Builder builder() {
    return new ClientLockoutPolicy.Builder();
  }

  /**
   * Builds instances of type {@link ClientLockoutPolicy ClientLockoutPolicy}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_COUNT_FAILURES_WITHIN = 0x1L;
    private static final long INIT_BIT_LOCKOUT_AFTER_FAILURES = 0x2L;
    private static final long INIT_BIT_LOCKOUT_PERIOD_SECONDS = 0x4L;
    private long initBits = 0x7L;

    private Integer countFailuresWithin;
    private Integer lockoutAfterFailures;
    private Integer lockoutPeriodSeconds;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ClientLockoutPolicy} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ClientLockoutPolicy instance) {
      return from((_ClientLockoutPolicy) instance);
    }

    /**
     * Copy abstract value type {@code _ClientLockoutPolicy} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ClientLockoutPolicy instance) {
      Objects.requireNonNull(instance, "instance");
      countFailuresWithin(instance.getCountFailuresWithin());
      lockoutAfterFailures(instance.getLockoutAfterFailures());
      lockoutPeriodSeconds(instance.getLockoutPeriodSeconds());
      return this;
    }

    /**
     * Initializes the value for the {@link _ClientLockoutPolicy#getCountFailuresWithin() countFailuresWithin} attribute.
     * @param countFailuresWithin The value for countFailuresWithin 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("countFailuresWithin")
    public final Builder countFailuresWithin(Integer countFailuresWithin) {
      this.countFailuresWithin = Objects.requireNonNull(countFailuresWithin, "countFailuresWithin");
      initBits &= ~INIT_BIT_COUNT_FAILURES_WITHIN;
      return this;
    }

    /**
     * Initializes the value for the {@link _ClientLockoutPolicy#getLockoutAfterFailures() lockoutAfterFailures} attribute.
     * @param lockoutAfterFailures The value for lockoutAfterFailures 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("lockoutAfterFailures")
    public final Builder lockoutAfterFailures(Integer lockoutAfterFailures) {
      this.lockoutAfterFailures = Objects.requireNonNull(lockoutAfterFailures, "lockoutAfterFailures");
      initBits &= ~INIT_BIT_LOCKOUT_AFTER_FAILURES;
      return this;
    }

    /**
     * Initializes the value for the {@link _ClientLockoutPolicy#getLockoutPeriodSeconds() lockoutPeriodSeconds} attribute.
     * @param lockoutPeriodSeconds The value for lockoutPeriodSeconds 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("lockoutPeriodSeconds")
    public final Builder lockoutPeriodSeconds(Integer lockoutPeriodSeconds) {
      this.lockoutPeriodSeconds = Objects.requireNonNull(lockoutPeriodSeconds, "lockoutPeriodSeconds");
      initBits &= ~INIT_BIT_LOCKOUT_PERIOD_SECONDS;
      return this;
    }

    /**
     * Builds a new {@link ClientLockoutPolicy ClientLockoutPolicy}.
     * @return An immutable instance of ClientLockoutPolicy
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ClientLockoutPolicy build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ClientLockoutPolicy(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_COUNT_FAILURES_WITHIN) != 0) attributes.add("countFailuresWithin");
      if ((initBits & INIT_BIT_LOCKOUT_AFTER_FAILURES) != 0) attributes.add("lockoutAfterFailures");
      if ((initBits & INIT_BIT_LOCKOUT_PERIOD_SECONDS) != 0) attributes.add("lockoutPeriodSeconds");
      return "Cannot build ClientLockoutPolicy, some of required attributes are not set " + attributes;
    }
  }
}
