package org.cloudfoundry.uaa.identityzones;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The payload for the key
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_Key"})
public final class Key extends org.cloudfoundry.uaa.identityzones._Key {
  private final String certificate;

  private Key(Key.Builder builder) {
    this.certificate = builder.certificate;
  }

  /**
   * The certificate
   */
  @JsonProperty("certificate")
  @Override
  public String getCertificate() {
    return certificate;
  }

  /**
   * This instance is equal to all instances of {@code Key} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Key
        && equalTo((Key) another);
  }

  private boolean equalTo(Key another) {
    return certificate.equals(another.certificate);
  }

  /**
   * Computes a hash code from attributes: {@code certificate}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + certificate.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Key} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Key{"
        + "certificate=" + certificate
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.identityzones._Key {
    String certificate;
    @JsonProperty("certificate")
    public void setCertificate(String certificate) {
      this.certificate = certificate;
    }
    @Override
    public String getCertificate() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static Key fromJson(Json json) {
    Key.Builder builder = Key.builder();
    if (json.certificate != null) {
      builder.certificate(json.certificate);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Key Key}.
   * @return A new Key builder
   */
  public static Key.Builder builder() {
    return new Key.Builder();
  }

  /**
   * Builds instances of type {@link Key Key}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_CERTIFICATE = 0x1L;
    private long initBits = 0x1L;

    private String certificate;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Key} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Key instance) {
      return from((_Key) instance);
    }

    /**
     * Copy abstract value type {@code _Key} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Key instance) {
      Objects.requireNonNull(instance, "instance");
      certificate(instance.getCertificate());
      return this;
    }

    /**
     * Initializes the value for the {@link _Key#getCertificate() certificate} attribute.
     * @param certificate The value for certificate 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("certificate")
    public final Builder certificate(String certificate) {
      this.certificate = Objects.requireNonNull(certificate, "certificate");
      initBits &= ~INIT_BIT_CERTIFICATE;
      return this;
    }

    /**
     * Builds a new {@link Key Key}.
     * @return An immutable instance of Key
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Key build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new Key(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_CERTIFICATE) != 0) attributes.add("certificate");
      return "Cannot build Key, some of required attributes are not set " + attributes;
    }
  }
}
