package org.cloudfoundry.client.v2.applications;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The response payload for the Get Application Statistics operation.
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_ApplicationStatisticsResponse"})
public final class ApplicationStatisticsResponse
    extends org.cloudfoundry.client.v2.applications._ApplicationStatisticsResponse {
  private final Map<String, InstanceStatistics> instances;

  private ApplicationStatisticsResponse(ApplicationStatisticsResponse.Builder builder) {
    this.instances = createUnmodifiableMap(false, false, builder.instances);
  }

  /**
   * The instances
   */
  @JsonProperty("instances")
  @Override
  public Map<String, InstanceStatistics> getInstances() {
    return instances;
  }

  /**
   * This instance is equal to all instances of {@code ApplicationStatisticsResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ApplicationStatisticsResponse
        && equalTo((ApplicationStatisticsResponse) another);
  }

  private boolean equalTo(ApplicationStatisticsResponse another) {
    return instances.equals(another.instances);
  }

  /**
   * Computes a hash code from attributes: {@code instances}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + instances.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ApplicationStatisticsResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ApplicationStatisticsResponse{"
        + "instances=" + instances
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.applications._ApplicationStatisticsResponse {
    Map<String, InstanceStatistics> instances;
    @JsonProperty("instances")
    public void setInstances(Map<String, InstanceStatistics> instances) {
      this.instances = instances;
    }
    @Override
    public Map<String, InstanceStatistics> getInstances() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ApplicationStatisticsResponse fromJson(Json json) {
    ApplicationStatisticsResponse.Builder builder = ApplicationStatisticsResponse.builder();
    if (json.instances != null) {
      builder.putAllInstances(json.instances);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ApplicationStatisticsResponse ApplicationStatisticsResponse}.
   * @return A new ApplicationStatisticsResponse builder
   */
  public static ApplicationStatisticsResponse.Builder builder() {
    return new ApplicationStatisticsResponse.Builder();
  }

  /**
   * Builds instances of type {@link ApplicationStatisticsResponse ApplicationStatisticsResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private Map<String, InstanceStatistics> instances = new LinkedHashMap<String, InstanceStatistics>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ApplicationStatisticsResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ApplicationStatisticsResponse instance) {
      return from((_ApplicationStatisticsResponse) instance);
    }

    /**
     * Copy abstract value type {@code _ApplicationStatisticsResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ApplicationStatisticsResponse instance) {
      Objects.requireNonNull(instance, "instance");
      putAllInstances(instance.getInstances());
      return this;
    }

    /**
     * Put one entry to the {@link _ApplicationStatisticsResponse#getInstances() instances} map.
     * @param key The key in the instances map
     * @param value The associated value in the instances map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder instance(String key, InstanceStatistics value) {
      this.instances.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link _ApplicationStatisticsResponse#getInstances() instances} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder instance(Map.Entry<String, ? extends InstanceStatistics> entry) {
      String k = entry.getKey();
      InstanceStatistics v = entry.getValue();
      this.instances.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link _ApplicationStatisticsResponse#getInstances() instances} map. Nulls are not permitted
     * @param instances The entries that will be added to the instances map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("instances")
    public final Builder instances(Map<String, ? extends InstanceStatistics> instances) {
      this.instances.clear();
      return putAllInstances(instances);
    }

    /**
     * Put all mappings from the specified map as entries to {@link _ApplicationStatisticsResponse#getInstances() instances} map. Nulls are not permitted
     * @param instances The entries that will be added to the instances map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllInstances(Map<String, ? extends InstanceStatistics> instances) {
      for (Map.Entry<String, ? extends InstanceStatistics> entry : instances.entrySet()) {
        String k = entry.getKey();
        InstanceStatistics v = entry.getValue();
        this.instances.put(k, v);
      }
      return this;
    }

    /**
     * Builds a new {@link ApplicationStatisticsResponse ApplicationStatisticsResponse}.
     * @return An immutable instance of ApplicationStatisticsResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ApplicationStatisticsResponse build() {
      return new ApplicationStatisticsResponse(this);
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
