package org.cloudfoundry.client.v2.applications;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request payload for the Remove Route from the Application operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_RemoveApplicationRouteRequest"})
public final class RemoveApplicationRouteRequest
    extends org.cloudfoundry.client.v2.applications._RemoveApplicationRouteRequest {
  private final String applicationId;
  private final String routeId;

  private RemoveApplicationRouteRequest(RemoveApplicationRouteRequest.Builder builder) {
    this.applicationId = builder.applicationId;
    this.routeId = builder.routeId;
  }

  /**
   * The application id
   */
  @Override
  public String getApplicationId() {
    return applicationId;
  }

  /**
   * The route id
   */
  @Override
  public String getRouteId() {
    return routeId;
  }

  /**
   * This instance is equal to all instances of {@code RemoveApplicationRouteRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof RemoveApplicationRouteRequest
        && equalTo((RemoveApplicationRouteRequest) another);
  }

  private boolean equalTo(RemoveApplicationRouteRequest another) {
    return applicationId.equals(another.applicationId)
        && routeId.equals(another.routeId);
  }

  /**
   * Computes a hash code from attributes: {@code applicationId}, {@code routeId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + applicationId.hashCode();
    h = h * 17 + routeId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RemoveApplicationRouteRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RemoveApplicationRouteRequest{"
        + "applicationId=" + applicationId
        + ", routeId=" + routeId
        + "}";
  }

  /**
   * Creates a builder for {@link RemoveApplicationRouteRequest RemoveApplicationRouteRequest}.
   * @return A new RemoveApplicationRouteRequest builder
   */
  public static RemoveApplicationRouteRequest.Builder builder() {
    return new RemoveApplicationRouteRequest.Builder();
  }

  /**
   * Builds instances of type {@link RemoveApplicationRouteRequest RemoveApplicationRouteRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_APPLICATION_ID = 0x1L;
    private static final long INIT_BIT_ROUTE_ID = 0x2L;
    private long initBits = 0x3L;

    private String applicationId;
    private String routeId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RemoveApplicationRouteRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RemoveApplicationRouteRequest instance) {
      return from((_RemoveApplicationRouteRequest) instance);
    }

    /**
     * Copy abstract value type {@code _RemoveApplicationRouteRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_RemoveApplicationRouteRequest instance) {
      Objects.requireNonNull(instance, "instance");
      applicationId(instance.getApplicationId());
      routeId(instance.getRouteId());
      return this;
    }

    /**
     * Initializes the value for the {@link _RemoveApplicationRouteRequest#getApplicationId() applicationId} attribute.
     * @param applicationId The value for applicationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationId(String applicationId) {
      this.applicationId = Objects.requireNonNull(applicationId, "applicationId");
      initBits &= ~INIT_BIT_APPLICATION_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _RemoveApplicationRouteRequest#getRouteId() routeId} attribute.
     * @param routeId The value for routeId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder routeId(String routeId) {
      this.routeId = Objects.requireNonNull(routeId, "routeId");
      initBits &= ~INIT_BIT_ROUTE_ID;
      return this;
    }

    /**
     * Builds a new {@link RemoveApplicationRouteRequest RemoveApplicationRouteRequest}.
     * @return An immutable instance of RemoveApplicationRouteRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public RemoveApplicationRouteRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new RemoveApplicationRouteRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_APPLICATION_ID) != 0) attributes.add("applicationId");
      if ((initBits & INIT_BIT_ROUTE_ID) != 0) attributes.add("routeId");
      return "Cannot build RemoveApplicationRouteRequest, some of required attributes are not set " + attributes;
    }
  }
}
