package org.cloudfoundry.client.v2.applications;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * Request payload for the Upload Application request.
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_UploadApplicationRequest"})
public final class UploadApplicationRequest
    extends org.cloudfoundry.client.v2.applications._UploadApplicationRequest {
  private final Path application;
  private final String applicationId;
  private final @Nullable Boolean async;
  private final List<Resource> resources;

  private UploadApplicationRequest(UploadApplicationRequest.Builder builder) {
    this.application = builder.application;
    this.applicationId = builder.applicationId;
    this.async = builder.async;
    this.resources = createUnmodifiableList(true, builder.resources);
  }

  /**
   * A binary zip file containing the application bits
   */
  @Override
  public Path getApplication() {
    return application;
  }

  /**
   * The application id
   */
  @Override
  public String getApplicationId() {
    return applicationId;
  }

  /**
   * If true, a new asynchronous job is submitted to persist the bits and the job id is included in the response
   */
  @Override
  public @Nullable Boolean getAsync() {
    return async;
  }

  /**
   * Fingerprints of the application bits that have previously been pushed to Cloud Foundry
   */
  @Override
  public List<Resource> getResources() {
    return resources;
  }

  /**
   * This instance is equal to all instances of {@code UploadApplicationRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UploadApplicationRequest
        && equalTo((UploadApplicationRequest) another);
  }

  private boolean equalTo(UploadApplicationRequest another) {
    return application.equals(another.application)
        && applicationId.equals(another.applicationId)
        && Objects.equals(async, another.async)
        && resources.equals(another.resources);
  }

  /**
   * Computes a hash code from attributes: {@code application}, {@code applicationId}, {@code async}, {@code resources}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + application.hashCode();
    h = h * 17 + applicationId.hashCode();
    h = h * 17 + Objects.hashCode(async);
    h = h * 17 + resources.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UploadApplicationRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UploadApplicationRequest{"
        + "application=" + application
        + ", applicationId=" + applicationId
        + ", async=" + async
        + ", resources=" + resources
        + "}";
  }

  /**
   * Creates a builder for {@link UploadApplicationRequest UploadApplicationRequest}.
   * @return A new UploadApplicationRequest builder
   */
  public static UploadApplicationRequest.Builder builder() {
    return new UploadApplicationRequest.Builder();
  }

  /**
   * Builds instances of type {@link UploadApplicationRequest UploadApplicationRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_APPLICATION = 0x1L;
    private static final long INIT_BIT_APPLICATION_ID = 0x2L;
    private long initBits = 0x3L;

    private Path application;
    private String applicationId;
    private Boolean async;
    private List<Resource> resources = new ArrayList<Resource>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UploadApplicationRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UploadApplicationRequest instance) {
      return from((_UploadApplicationRequest) instance);
    }

    /**
     * Copy abstract value type {@code _UploadApplicationRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UploadApplicationRequest instance) {
      Objects.requireNonNull(instance, "instance");
      application(instance.getApplication());
      applicationId(instance.getApplicationId());
      Boolean asyncValue = instance.getAsync();
      if (asyncValue != null) {
        async(asyncValue);
      }
      addAllResources(instance.getResources());
      return this;
    }

    /**
     * Initializes the value for the {@link _UploadApplicationRequest#getApplication() application} attribute.
     * @param application The value for application 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder application(Path application) {
      this.application = Objects.requireNonNull(application, "application");
      initBits &= ~INIT_BIT_APPLICATION;
      return this;
    }

    /**
     * Initializes the value for the {@link _UploadApplicationRequest#getApplicationId() applicationId} attribute.
     * @param applicationId The value for applicationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationId(String applicationId) {
      this.applicationId = Objects.requireNonNull(applicationId, "applicationId");
      initBits &= ~INIT_BIT_APPLICATION_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _UploadApplicationRequest#getAsync() async} attribute.
     * @param async The value for async (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder async(@Nullable Boolean async) {
      this.async = async;
      return this;
    }

    /**
     * Adds one element to {@link _UploadApplicationRequest#getResources() resources} list.
     * @param element A resources element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder resource(Resource element) {
      this.resources.add(Objects.requireNonNull(element, "resources element"));
      return this;
    }

    /**
     * Adds elements to {@link _UploadApplicationRequest#getResources() resources} list.
     * @param elements An array of resources elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder resource(Resource... elements) {
      for (Resource element : elements) {
        this.resources.add(Objects.requireNonNull(element, "resources element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _UploadApplicationRequest#getResources() resources} list.
     * @param elements An iterable of resources elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder resources(Iterable<? extends Resource> elements) {
      this.resources.clear();
      return addAllResources(elements);
    }

    /**
     * Adds elements to {@link _UploadApplicationRequest#getResources() resources} list.
     * @param elements An iterable of resources elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllResources(Iterable<? extends Resource> elements) {
      for (Resource element : elements) {
        this.resources.add(Objects.requireNonNull(element, "resources element"));
      }
      return this;
    }

    /**
     * Builds a new {@link UploadApplicationRequest UploadApplicationRequest}.
     * @return An immutable instance of UploadApplicationRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UploadApplicationRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UploadApplicationRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_APPLICATION) != 0) attributes.add("application");
      if ((initBits & INIT_BIT_APPLICATION_ID) != 0) attributes.add("applicationId");
      return "Cannot build UploadApplicationRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
