package org.cloudfoundry.client.v2.organizations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.OrderDirection;
import org.cloudfoundry.client.v2.PaginatedRequest;

/**
 * The request payload for the List all Billing Managers for the Organization operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_ListOrganizationBillingManagersRequest"})
public final class ListOrganizationBillingManagersRequest
    extends org.cloudfoundry.client.v2.organizations._ListOrganizationBillingManagersRequest {
  private final @Nullable List<String> auditedOrganizationIds;
  private final @Nullable List<String> auditedSpaceIds;
  private final @Nullable List<String> billingManagedOrganizationIds;
  private final @Nullable List<String> managedOrganizationIds;
  private final @Nullable List<String> managedSpaceIds;
  private final String organizationId;
  private final @Nullable List<String> spaceIds;
  private final @Nullable OrderDirection orderDirection;
  private final @Nullable Integer page;
  private final @Nullable Integer resultsPerPage;

  private ListOrganizationBillingManagersRequest(ListOrganizationBillingManagersRequest.Builder builder) {
    this.auditedOrganizationIds = builder.auditedOrganizationIds == null ? null : createUnmodifiableList(true, builder.auditedOrganizationIds);
    this.auditedSpaceIds = builder.auditedSpaceIds == null ? null : createUnmodifiableList(true, builder.auditedSpaceIds);
    this.billingManagedOrganizationIds = builder.billingManagedOrganizationIds == null ? null : createUnmodifiableList(true, builder.billingManagedOrganizationIds);
    this.managedOrganizationIds = builder.managedOrganizationIds == null ? null : createUnmodifiableList(true, builder.managedOrganizationIds);
    this.managedSpaceIds = builder.managedSpaceIds == null ? null : createUnmodifiableList(true, builder.managedSpaceIds);
    this.organizationId = builder.organizationId;
    this.spaceIds = builder.spaceIds == null ? null : createUnmodifiableList(true, builder.spaceIds);
    this.orderDirection = builder.orderDirection;
    this.page = builder.page;
    this.resultsPerPage = builder.resultsPerPage;
  }

  /**
   * The audited organization ids
   */
  @Override
  public @Nullable List<String> getAuditedOrganizationIds() {
    return auditedOrganizationIds;
  }

  /**
   * The audited space ids
   */
  @Override
  public @Nullable List<String> getAuditedSpaceIds() {
    return auditedSpaceIds;
  }

  /**
   * The billing managed organization ids
   */
  @Override
  public @Nullable List<String> getBillingManagedOrganizationIds() {
    return billingManagedOrganizationIds;
  }

  /**
   * The managed organization ids
   */
  @Override
  public @Nullable List<String> getManagedOrganizationIds() {
    return managedOrganizationIds;
  }

  /**
   * The managed space ids
   */
  @Override
  public @Nullable List<String> getManagedSpaceIds() {
    return managedSpaceIds;
  }

  /**
   * The organization id
   */
  @Override
  public String getOrganizationId() {
    return organizationId;
  }

  /**
   * The space ids
   */
  @Override
  public @Nullable List<String> getSpaceIds() {
    return spaceIds;
  }

  /**
   * The order direction
   */
  @Override
  public @Nullable OrderDirection getOrderDirection() {
    return orderDirection;
  }

  /**
   * The page
   */
  @Override
  public @Nullable Integer getPage() {
    return page;
  }

  /**
   * The results per page
   */
  @Override
  public @Nullable Integer getResultsPerPage() {
    return resultsPerPage;
  }

  /**
   * This instance is equal to all instances of {@code ListOrganizationBillingManagersRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListOrganizationBillingManagersRequest
        && equalTo((ListOrganizationBillingManagersRequest) another);
  }

  private boolean equalTo(ListOrganizationBillingManagersRequest another) {
    return Objects.equals(auditedOrganizationIds, another.auditedOrganizationIds)
        && Objects.equals(auditedSpaceIds, another.auditedSpaceIds)
        && Objects.equals(billingManagedOrganizationIds, another.billingManagedOrganizationIds)
        && Objects.equals(managedOrganizationIds, another.managedOrganizationIds)
        && Objects.equals(managedSpaceIds, another.managedSpaceIds)
        && organizationId.equals(another.organizationId)
        && Objects.equals(spaceIds, another.spaceIds)
        && Objects.equals(orderDirection, another.orderDirection)
        && Objects.equals(page, another.page)
        && Objects.equals(resultsPerPage, another.resultsPerPage);
  }

  /**
   * Computes a hash code from attributes: {@code auditedOrganizationIds}, {@code auditedSpaceIds}, {@code billingManagedOrganizationIds}, {@code managedOrganizationIds}, {@code managedSpaceIds}, {@code organizationId}, {@code spaceIds}, {@code orderDirection}, {@code page}, {@code resultsPerPage}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(auditedOrganizationIds);
    h = h * 17 + Objects.hashCode(auditedSpaceIds);
    h = h * 17 + Objects.hashCode(billingManagedOrganizationIds);
    h = h * 17 + Objects.hashCode(managedOrganizationIds);
    h = h * 17 + Objects.hashCode(managedSpaceIds);
    h = h * 17 + organizationId.hashCode();
    h = h * 17 + Objects.hashCode(spaceIds);
    h = h * 17 + Objects.hashCode(orderDirection);
    h = h * 17 + Objects.hashCode(page);
    h = h * 17 + Objects.hashCode(resultsPerPage);
    return h;
  }

  /**
   * Prints the immutable value {@code ListOrganizationBillingManagersRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListOrganizationBillingManagersRequest{"
        + "auditedOrganizationIds=" + auditedOrganizationIds
        + ", auditedSpaceIds=" + auditedSpaceIds
        + ", billingManagedOrganizationIds=" + billingManagedOrganizationIds
        + ", managedOrganizationIds=" + managedOrganizationIds
        + ", managedSpaceIds=" + managedSpaceIds
        + ", organizationId=" + organizationId
        + ", spaceIds=" + spaceIds
        + ", orderDirection=" + orderDirection
        + ", page=" + page
        + ", resultsPerPage=" + resultsPerPage
        + "}";
  }

  /**
   * Creates a builder for {@link ListOrganizationBillingManagersRequest ListOrganizationBillingManagersRequest}.
   * @return A new ListOrganizationBillingManagersRequest builder
   */
  public static ListOrganizationBillingManagersRequest.Builder builder() {
    return new ListOrganizationBillingManagersRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListOrganizationBillingManagersRequest ListOrganizationBillingManagersRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_ORGANIZATION_ID = 0x1L;
    private long initBits = 0x1L;

    private List<String> auditedOrganizationIds = null;
    private List<String> auditedSpaceIds = null;
    private List<String> billingManagedOrganizationIds = null;
    private List<String> managedOrganizationIds = null;
    private List<String> managedSpaceIds = null;
    private String organizationId;
    private List<String> spaceIds = null;
    private OrderDirection orderDirection;
    private Integer page;
    private Integer resultsPerPage;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v2.PaginatedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListOrganizationBillingManagersRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListOrganizationBillingManagersRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListOrganizationBillingManagersRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ListOrganizationBillingManagersRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof PaginatedRequest) {
        PaginatedRequest instance = (PaginatedRequest) object;
        OrderDirection orderDirectionValue = instance.getOrderDirection();
        if (orderDirectionValue != null) {
          orderDirection(orderDirectionValue);
        }
        Integer resultsPerPageValue = instance.getResultsPerPage();
        if (resultsPerPageValue != null) {
          resultsPerPage(resultsPerPageValue);
        }
        Integer pageValue = instance.getPage();
        if (pageValue != null) {
          page(pageValue);
        }
      }
      if (object instanceof org.cloudfoundry.client.v2.organizations._ListOrganizationBillingManagersRequest) {
        org.cloudfoundry.client.v2.organizations._ListOrganizationBillingManagersRequest instance = (org.cloudfoundry.client.v2.organizations._ListOrganizationBillingManagersRequest) object;
        organizationId(instance.getOrganizationId());
        List<String> auditedOrganizationIdsValue = instance.getAuditedOrganizationIds();
        if (auditedOrganizationIdsValue != null) {
          addAllAuditedOrganizationIds(auditedOrganizationIdsValue);
        }
        List<String> managedOrganizationIdsValue = instance.getManagedOrganizationIds();
        if (managedOrganizationIdsValue != null) {
          addAllManagedOrganizationIds(managedOrganizationIdsValue);
        }
        List<String> auditedSpaceIdsValue = instance.getAuditedSpaceIds();
        if (auditedSpaceIdsValue != null) {
          addAllAuditedSpaceIds(auditedSpaceIdsValue);
        }
        List<String> spaceIdsValue = instance.getSpaceIds();
        if (spaceIdsValue != null) {
          addAllSpaceIds(spaceIdsValue);
        }
        List<String> billingManagedOrganizationIdsValue = instance.getBillingManagedOrganizationIds();
        if (billingManagedOrganizationIdsValue != null) {
          addAllBillingManagedOrganizationIds(billingManagedOrganizationIdsValue);
        }
        List<String> managedSpaceIdsValue = instance.getManagedSpaceIds();
        if (managedSpaceIdsValue != null) {
          addAllManagedSpaceIds(managedSpaceIdsValue);
        }
      }
    }

    /**
     * Adds one element to {@link _ListOrganizationBillingManagersRequest#getAuditedOrganizationIds() auditedOrganizationIds} list.
     * @param element A auditedOrganizationIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder auditedOrganizationId(String element) {
      if (this.auditedOrganizationIds == null) {
        this.auditedOrganizationIds = new ArrayList<String>();
      }
      this.auditedOrganizationIds.add(Objects.requireNonNull(element, "auditedOrganizationIds element"));
      return this;
    }

    /**
     * Adds elements to {@link _ListOrganizationBillingManagersRequest#getAuditedOrganizationIds() auditedOrganizationIds} list.
     * @param elements An array of auditedOrganizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder auditedOrganizationId(String... elements) {
      if (this.auditedOrganizationIds == null) {
        this.auditedOrganizationIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.auditedOrganizationIds.add(Objects.requireNonNull(element, "auditedOrganizationIds element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _ListOrganizationBillingManagersRequest#getAuditedOrganizationIds() auditedOrganizationIds} list.
     * @param elements An iterable of auditedOrganizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder auditedOrganizationIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.auditedOrganizationIds = null;
        return this;
      }
      this.auditedOrganizationIds = new ArrayList<String>();
      return addAllAuditedOrganizationIds(elements);
    }

    /**
     * Adds elements to {@link _ListOrganizationBillingManagersRequest#getAuditedOrganizationIds() auditedOrganizationIds} list.
     * @param elements An iterable of auditedOrganizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllAuditedOrganizationIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "auditedOrganizationIds element");
      if (this.auditedOrganizationIds == null) {
        this.auditedOrganizationIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.auditedOrganizationIds.add(Objects.requireNonNull(element, "auditedOrganizationIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link _ListOrganizationBillingManagersRequest#getAuditedSpaceIds() auditedSpaceIds} list.
     * @param element A auditedSpaceIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder auditedSpaceId(String element) {
      if (this.auditedSpaceIds == null) {
        this.auditedSpaceIds = new ArrayList<String>();
      }
      this.auditedSpaceIds.add(Objects.requireNonNull(element, "auditedSpaceIds element"));
      return this;
    }

    /**
     * Adds elements to {@link _ListOrganizationBillingManagersRequest#getAuditedSpaceIds() auditedSpaceIds} list.
     * @param elements An array of auditedSpaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder auditedSpaceId(String... elements) {
      if (this.auditedSpaceIds == null) {
        this.auditedSpaceIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.auditedSpaceIds.add(Objects.requireNonNull(element, "auditedSpaceIds element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _ListOrganizationBillingManagersRequest#getAuditedSpaceIds() auditedSpaceIds} list.
     * @param elements An iterable of auditedSpaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder auditedSpaceIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.auditedSpaceIds = null;
        return this;
      }
      this.auditedSpaceIds = new ArrayList<String>();
      return addAllAuditedSpaceIds(elements);
    }

    /**
     * Adds elements to {@link _ListOrganizationBillingManagersRequest#getAuditedSpaceIds() auditedSpaceIds} list.
     * @param elements An iterable of auditedSpaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllAuditedSpaceIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "auditedSpaceIds element");
      if (this.auditedSpaceIds == null) {
        this.auditedSpaceIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.auditedSpaceIds.add(Objects.requireNonNull(element, "auditedSpaceIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link _ListOrganizationBillingManagersRequest#getBillingManagedOrganizationIds() billingManagedOrganizationIds} list.
     * @param element A billingManagedOrganizationIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder billingManagedOrganizationId(String element) {
      if (this.billingManagedOrganizationIds == null) {
        this.billingManagedOrganizationIds = new ArrayList<String>();
      }
      this.billingManagedOrganizationIds.add(Objects.requireNonNull(element, "billingManagedOrganizationIds element"));
      return this;
    }

    /**
     * Adds elements to {@link _ListOrganizationBillingManagersRequest#getBillingManagedOrganizationIds() billingManagedOrganizationIds} list.
     * @param elements An array of billingManagedOrganizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder billingManagedOrganizationId(String... elements) {
      if (this.billingManagedOrganizationIds == null) {
        this.billingManagedOrganizationIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.billingManagedOrganizationIds.add(Objects.requireNonNull(element, "billingManagedOrganizationIds element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _ListOrganizationBillingManagersRequest#getBillingManagedOrganizationIds() billingManagedOrganizationIds} list.
     * @param elements An iterable of billingManagedOrganizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder billingManagedOrganizationIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.billingManagedOrganizationIds = null;
        return this;
      }
      this.billingManagedOrganizationIds = new ArrayList<String>();
      return addAllBillingManagedOrganizationIds(elements);
    }

    /**
     * Adds elements to {@link _ListOrganizationBillingManagersRequest#getBillingManagedOrganizationIds() billingManagedOrganizationIds} list.
     * @param elements An iterable of billingManagedOrganizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllBillingManagedOrganizationIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "billingManagedOrganizationIds element");
      if (this.billingManagedOrganizationIds == null) {
        this.billingManagedOrganizationIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.billingManagedOrganizationIds.add(Objects.requireNonNull(element, "billingManagedOrganizationIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link _ListOrganizationBillingManagersRequest#getManagedOrganizationIds() managedOrganizationIds} list.
     * @param element A managedOrganizationIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder managedOrganizationId(String element) {
      if (this.managedOrganizationIds == null) {
        this.managedOrganizationIds = new ArrayList<String>();
      }
      this.managedOrganizationIds.add(Objects.requireNonNull(element, "managedOrganizationIds element"));
      return this;
    }

    /**
     * Adds elements to {@link _ListOrganizationBillingManagersRequest#getManagedOrganizationIds() managedOrganizationIds} list.
     * @param elements An array of managedOrganizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder managedOrganizationId(String... elements) {
      if (this.managedOrganizationIds == null) {
        this.managedOrganizationIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.managedOrganizationIds.add(Objects.requireNonNull(element, "managedOrganizationIds element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _ListOrganizationBillingManagersRequest#getManagedOrganizationIds() managedOrganizationIds} list.
     * @param elements An iterable of managedOrganizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder managedOrganizationIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.managedOrganizationIds = null;
        return this;
      }
      this.managedOrganizationIds = new ArrayList<String>();
      return addAllManagedOrganizationIds(elements);
    }

    /**
     * Adds elements to {@link _ListOrganizationBillingManagersRequest#getManagedOrganizationIds() managedOrganizationIds} list.
     * @param elements An iterable of managedOrganizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllManagedOrganizationIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "managedOrganizationIds element");
      if (this.managedOrganizationIds == null) {
        this.managedOrganizationIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.managedOrganizationIds.add(Objects.requireNonNull(element, "managedOrganizationIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link _ListOrganizationBillingManagersRequest#getManagedSpaceIds() managedSpaceIds} list.
     * @param element A managedSpaceIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder managedSpaceId(String element) {
      if (this.managedSpaceIds == null) {
        this.managedSpaceIds = new ArrayList<String>();
      }
      this.managedSpaceIds.add(Objects.requireNonNull(element, "managedSpaceIds element"));
      return this;
    }

    /**
     * Adds elements to {@link _ListOrganizationBillingManagersRequest#getManagedSpaceIds() managedSpaceIds} list.
     * @param elements An array of managedSpaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder managedSpaceId(String... elements) {
      if (this.managedSpaceIds == null) {
        this.managedSpaceIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.managedSpaceIds.add(Objects.requireNonNull(element, "managedSpaceIds element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _ListOrganizationBillingManagersRequest#getManagedSpaceIds() managedSpaceIds} list.
     * @param elements An iterable of managedSpaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder managedSpaceIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.managedSpaceIds = null;
        return this;
      }
      this.managedSpaceIds = new ArrayList<String>();
      return addAllManagedSpaceIds(elements);
    }

    /**
     * Adds elements to {@link _ListOrganizationBillingManagersRequest#getManagedSpaceIds() managedSpaceIds} list.
     * @param elements An iterable of managedSpaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllManagedSpaceIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "managedSpaceIds element");
      if (this.managedSpaceIds == null) {
        this.managedSpaceIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.managedSpaceIds.add(Objects.requireNonNull(element, "managedSpaceIds element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _ListOrganizationBillingManagersRequest#getOrganizationId() organizationId} attribute.
     * @param organizationId The value for organizationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(String organizationId) {
      this.organizationId = Objects.requireNonNull(organizationId, "organizationId");
      initBits &= ~INIT_BIT_ORGANIZATION_ID;
      return this;
    }

    /**
     * Adds one element to {@link _ListOrganizationBillingManagersRequest#getSpaceIds() spaceIds} list.
     * @param element A spaceIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(String element) {
      if (this.spaceIds == null) {
        this.spaceIds = new ArrayList<String>();
      }
      this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
      return this;
    }

    /**
     * Adds elements to {@link _ListOrganizationBillingManagersRequest#getSpaceIds() spaceIds} list.
     * @param elements An array of spaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(String... elements) {
      if (this.spaceIds == null) {
        this.spaceIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _ListOrganizationBillingManagersRequest#getSpaceIds() spaceIds} list.
     * @param elements An iterable of spaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.spaceIds = null;
        return this;
      }
      this.spaceIds = new ArrayList<String>();
      return addAllSpaceIds(elements);
    }

    /**
     * Adds elements to {@link _ListOrganizationBillingManagersRequest#getSpaceIds() spaceIds} list.
     * @param elements An iterable of spaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSpaceIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "spaceIds element");
      if (this.spaceIds == null) {
        this.spaceIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _ListOrganizationBillingManagersRequest#getOrderDirection() orderDirection} attribute.
     * @param orderDirection The value for orderDirection (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder orderDirection(@Nullable OrderDirection orderDirection) {
      this.orderDirection = orderDirection;
      return this;
    }

    /**
     * Initializes the value for the {@link _ListOrganizationBillingManagersRequest#getPage() page} attribute.
     * @param page The value for page (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder page(@Nullable Integer page) {
      this.page = page;
      return this;
    }

    /**
     * Initializes the value for the {@link _ListOrganizationBillingManagersRequest#getResultsPerPage() resultsPerPage} attribute.
     * @param resultsPerPage The value for resultsPerPage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder resultsPerPage(@Nullable Integer resultsPerPage) {
      this.resultsPerPage = resultsPerPage;
      return this;
    }

    /**
     * Builds a new {@link ListOrganizationBillingManagersRequest ListOrganizationBillingManagersRequest}.
     * @return An immutable instance of ListOrganizationBillingManagersRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListOrganizationBillingManagersRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ListOrganizationBillingManagersRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_ORGANIZATION_ID) != 0) attributes.add("organizationId");
      return "Cannot build ListOrganizationBillingManagersRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
