package org.cloudfoundry.client.v2.organizations;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.OrderDirection;
import org.cloudfoundry.client.v2.PaginatedRequest;

/**
 * The request payload for the List all Space Quota Definitions for the Organization operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_ListOrganizationSpaceQuotaDefinitionsRequest"})
public final class ListOrganizationSpaceQuotaDefinitionsRequest
    extends org.cloudfoundry.client.v2.organizations._ListOrganizationSpaceQuotaDefinitionsRequest {
  private final String organizationId;
  private final @Nullable OrderDirection orderDirection;
  private final @Nullable Integer page;
  private final @Nullable Integer resultsPerPage;

  private ListOrganizationSpaceQuotaDefinitionsRequest(ListOrganizationSpaceQuotaDefinitionsRequest.Builder builder) {
    this.organizationId = builder.organizationId;
    this.orderDirection = builder.orderDirection;
    this.page = builder.page;
    this.resultsPerPage = builder.resultsPerPage;
  }

  /**
   * The organization id
   */
  @Override
  public String getOrganizationId() {
    return organizationId;
  }

  /**
   * The order direction
   */
  @Override
  public @Nullable OrderDirection getOrderDirection() {
    return orderDirection;
  }

  /**
   * The page
   */
  @Override
  public @Nullable Integer getPage() {
    return page;
  }

  /**
   * The results per page
   */
  @Override
  public @Nullable Integer getResultsPerPage() {
    return resultsPerPage;
  }

  /**
   * This instance is equal to all instances of {@code ListOrganizationSpaceQuotaDefinitionsRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListOrganizationSpaceQuotaDefinitionsRequest
        && equalTo((ListOrganizationSpaceQuotaDefinitionsRequest) another);
  }

  private boolean equalTo(ListOrganizationSpaceQuotaDefinitionsRequest another) {
    return organizationId.equals(another.organizationId)
        && Objects.equals(orderDirection, another.orderDirection)
        && Objects.equals(page, another.page)
        && Objects.equals(resultsPerPage, another.resultsPerPage);
  }

  /**
   * Computes a hash code from attributes: {@code organizationId}, {@code orderDirection}, {@code page}, {@code resultsPerPage}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + organizationId.hashCode();
    h = h * 17 + Objects.hashCode(orderDirection);
    h = h * 17 + Objects.hashCode(page);
    h = h * 17 + Objects.hashCode(resultsPerPage);
    return h;
  }

  /**
   * Prints the immutable value {@code ListOrganizationSpaceQuotaDefinitionsRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListOrganizationSpaceQuotaDefinitionsRequest{"
        + "organizationId=" + organizationId
        + ", orderDirection=" + orderDirection
        + ", page=" + page
        + ", resultsPerPage=" + resultsPerPage
        + "}";
  }

  /**
   * Creates a builder for {@link ListOrganizationSpaceQuotaDefinitionsRequest ListOrganizationSpaceQuotaDefinitionsRequest}.
   * @return A new ListOrganizationSpaceQuotaDefinitionsRequest builder
   */
  public static ListOrganizationSpaceQuotaDefinitionsRequest.Builder builder() {
    return new ListOrganizationSpaceQuotaDefinitionsRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListOrganizationSpaceQuotaDefinitionsRequest ListOrganizationSpaceQuotaDefinitionsRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_ORGANIZATION_ID = 0x1L;
    private long initBits = 0x1L;

    private String organizationId;
    private OrderDirection orderDirection;
    private Integer page;
    private Integer resultsPerPage;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v2.PaginatedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListOrganizationSpaceQuotaDefinitionsRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListOrganizationSpaceQuotaDefinitionsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListOrganizationSpaceQuotaDefinitionsRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ListOrganizationSpaceQuotaDefinitionsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof PaginatedRequest) {
        PaginatedRequest instance = (PaginatedRequest) object;
        OrderDirection orderDirectionValue = instance.getOrderDirection();
        if (orderDirectionValue != null) {
          orderDirection(orderDirectionValue);
        }
        Integer resultsPerPageValue = instance.getResultsPerPage();
        if (resultsPerPageValue != null) {
          resultsPerPage(resultsPerPageValue);
        }
        Integer pageValue = instance.getPage();
        if (pageValue != null) {
          page(pageValue);
        }
      }
      if (object instanceof org.cloudfoundry.client.v2.organizations._ListOrganizationSpaceQuotaDefinitionsRequest) {
        org.cloudfoundry.client.v2.organizations._ListOrganizationSpaceQuotaDefinitionsRequest instance = (org.cloudfoundry.client.v2.organizations._ListOrganizationSpaceQuotaDefinitionsRequest) object;
        organizationId(instance.getOrganizationId());
      }
    }

    /**
     * Initializes the value for the {@link _ListOrganizationSpaceQuotaDefinitionsRequest#getOrganizationId() organizationId} attribute.
     * @param organizationId The value for organizationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(String organizationId) {
      this.organizationId = Objects.requireNonNull(organizationId, "organizationId");
      initBits &= ~INIT_BIT_ORGANIZATION_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _ListOrganizationSpaceQuotaDefinitionsRequest#getOrderDirection() orderDirection} attribute.
     * @param orderDirection The value for orderDirection (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder orderDirection(@Nullable OrderDirection orderDirection) {
      this.orderDirection = orderDirection;
      return this;
    }

    /**
     * Initializes the value for the {@link _ListOrganizationSpaceQuotaDefinitionsRequest#getPage() page} attribute.
     * @param page The value for page (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder page(@Nullable Integer page) {
      this.page = page;
      return this;
    }

    /**
     * Initializes the value for the {@link _ListOrganizationSpaceQuotaDefinitionsRequest#getResultsPerPage() resultsPerPage} attribute.
     * @param resultsPerPage The value for resultsPerPage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder resultsPerPage(@Nullable Integer resultsPerPage) {
      this.resultsPerPage = resultsPerPage;
      return this;
    }

    /**
     * Builds a new {@link ListOrganizationSpaceQuotaDefinitionsRequest ListOrganizationSpaceQuotaDefinitionsRequest}.
     * @return An immutable instance of ListOrganizationSpaceQuotaDefinitionsRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListOrganizationSpaceQuotaDefinitionsRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ListOrganizationSpaceQuotaDefinitionsRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_ORGANIZATION_ID) != 0) attributes.add("organizationId");
      return "Cannot build ListOrganizationSpaceQuotaDefinitionsRequest, some of required attributes are not set " + attributes;
    }
  }
}
