package org.cloudfoundry.client.v2.organizations;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request payload for the Disassociate User with the Organization by Username operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_RemoveOrganizationUserByUsernameRequest"})
public final class RemoveOrganizationUserByUsernameRequest
    extends org.cloudfoundry.client.v2.organizations._RemoveOrganizationUserByUsernameRequest {
  private final String organizationId;
  private final String username;

  private RemoveOrganizationUserByUsernameRequest(RemoveOrganizationUserByUsernameRequest.Builder builder) {
    this.organizationId = builder.organizationId;
    this.username = builder.username;
  }

  /**
   * The organization id
   */
  @Override
  public String getOrganizationId() {
    return organizationId;
  }

  /**
   * The username
   */
  @Override
  public String getUsername() {
    return username;
  }

  /**
   * This instance is equal to all instances of {@code RemoveOrganizationUserByUsernameRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof RemoveOrganizationUserByUsernameRequest
        && equalTo((RemoveOrganizationUserByUsernameRequest) another);
  }

  private boolean equalTo(RemoveOrganizationUserByUsernameRequest another) {
    return organizationId.equals(another.organizationId)
        && username.equals(another.username);
  }

  /**
   * Computes a hash code from attributes: {@code organizationId}, {@code username}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + organizationId.hashCode();
    h = h * 17 + username.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RemoveOrganizationUserByUsernameRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RemoveOrganizationUserByUsernameRequest{"
        + "organizationId=" + organizationId
        + ", username=" + username
        + "}";
  }

  /**
   * Creates a builder for {@link RemoveOrganizationUserByUsernameRequest RemoveOrganizationUserByUsernameRequest}.
   * @return A new RemoveOrganizationUserByUsernameRequest builder
   */
  public static RemoveOrganizationUserByUsernameRequest.Builder builder() {
    return new RemoveOrganizationUserByUsernameRequest.Builder();
  }

  /**
   * Builds instances of type {@link RemoveOrganizationUserByUsernameRequest RemoveOrganizationUserByUsernameRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_ORGANIZATION_ID = 0x1L;
    private static final long INIT_BIT_USERNAME = 0x2L;
    private long initBits = 0x3L;

    private String organizationId;
    private String username;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RemoveOrganizationUserByUsernameRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RemoveOrganizationUserByUsernameRequest instance) {
      return from((_RemoveOrganizationUserByUsernameRequest) instance);
    }

    /**
     * Copy abstract value type {@code _RemoveOrganizationUserByUsernameRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_RemoveOrganizationUserByUsernameRequest instance) {
      Objects.requireNonNull(instance, "instance");
      organizationId(instance.getOrganizationId());
      username(instance.getUsername());
      return this;
    }

    /**
     * Initializes the value for the {@link _RemoveOrganizationUserByUsernameRequest#getOrganizationId() organizationId} attribute.
     * @param organizationId The value for organizationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(String organizationId) {
      this.organizationId = Objects.requireNonNull(organizationId, "organizationId");
      initBits &= ~INIT_BIT_ORGANIZATION_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _RemoveOrganizationUserByUsernameRequest#getUsername() username} attribute.
     * @param username The value for username 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder username(String username) {
      this.username = Objects.requireNonNull(username, "username");
      initBits &= ~INIT_BIT_USERNAME;
      return this;
    }

    /**
     * Builds a new {@link RemoveOrganizationUserByUsernameRequest RemoveOrganizationUserByUsernameRequest}.
     * @return An immutable instance of RemoveOrganizationUserByUsernameRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public RemoveOrganizationUserByUsernameRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new RemoveOrganizationUserByUsernameRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_ORGANIZATION_ID) != 0) attributes.add("organizationId");
      if ((initBits & INIT_BIT_USERNAME) != 0) attributes.add("username");
      return "Cannot build RemoveOrganizationUserByUsernameRequest, some of required attributes are not set " + attributes;
    }
  }
}
