package org.cloudfoundry.client.v2.privatedomains;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The request payload for the Delete a Particular Private Domain operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_DeletePrivateDomainRequest"})
public final class DeletePrivateDomainRequest
    extends org.cloudfoundry.client.v2.privatedomains._DeletePrivateDomainRequest {
  private final @Nullable Boolean async;
  private final String privateDomainId;

  private DeletePrivateDomainRequest(DeletePrivateDomainRequest.Builder builder) {
    this.async = builder.async;
    this.privateDomainId = builder.privateDomainId;
  }

  /**
   * The async
   */
  @Override
  public @Nullable Boolean getAsync() {
    return async;
  }

  /**
   * The private domain id
   */
  @Override
  public String getPrivateDomainId() {
    return privateDomainId;
  }

  /**
   * This instance is equal to all instances of {@code DeletePrivateDomainRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof DeletePrivateDomainRequest
        && equalTo((DeletePrivateDomainRequest) another);
  }

  private boolean equalTo(DeletePrivateDomainRequest another) {
    return Objects.equals(async, another.async)
        && privateDomainId.equals(another.privateDomainId);
  }

  /**
   * Computes a hash code from attributes: {@code async}, {@code privateDomainId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(async);
    h = h * 17 + privateDomainId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DeletePrivateDomainRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DeletePrivateDomainRequest{"
        + "async=" + async
        + ", privateDomainId=" + privateDomainId
        + "}";
  }

  /**
   * Creates a builder for {@link DeletePrivateDomainRequest DeletePrivateDomainRequest}.
   * @return A new DeletePrivateDomainRequest builder
   */
  public static DeletePrivateDomainRequest.Builder builder() {
    return new DeletePrivateDomainRequest.Builder();
  }

  /**
   * Builds instances of type {@link DeletePrivateDomainRequest DeletePrivateDomainRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_PRIVATE_DOMAIN_ID = 0x1L;
    private long initBits = 0x1L;

    private Boolean async;
    private String privateDomainId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DeletePrivateDomainRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DeletePrivateDomainRequest instance) {
      return from((_DeletePrivateDomainRequest) instance);
    }

    /**
     * Copy abstract value type {@code _DeletePrivateDomainRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_DeletePrivateDomainRequest instance) {
      Objects.requireNonNull(instance, "instance");
      Boolean asyncValue = instance.getAsync();
      if (asyncValue != null) {
        async(asyncValue);
      }
      privateDomainId(instance.getPrivateDomainId());
      return this;
    }

    /**
     * Initializes the value for the {@link _DeletePrivateDomainRequest#getAsync() async} attribute.
     * @param async The value for async (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder async(@Nullable Boolean async) {
      this.async = async;
      return this;
    }

    /**
     * Initializes the value for the {@link _DeletePrivateDomainRequest#getPrivateDomainId() privateDomainId} attribute.
     * @param privateDomainId The value for privateDomainId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder privateDomainId(String privateDomainId) {
      this.privateDomainId = Objects.requireNonNull(privateDomainId, "privateDomainId");
      initBits &= ~INIT_BIT_PRIVATE_DOMAIN_ID;
      return this;
    }

    /**
     * Builds a new {@link DeletePrivateDomainRequest DeletePrivateDomainRequest}.
     * @return An immutable instance of DeletePrivateDomainRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public DeletePrivateDomainRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new DeletePrivateDomainRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_PRIVATE_DOMAIN_ID) != 0) attributes.add("privateDomainId");
      return "Cannot build DeletePrivateDomainRequest, some of required attributes are not set " + attributes;
    }
  }
}
