package org.cloudfoundry.client.v2.routes;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The request payload for the Update a Route operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_UpdateRouteRequest"})
public final class UpdateRouteRequest extends org.cloudfoundry.client.v2.routes._UpdateRouteRequest {
  private final @Nullable String domainId;
  private final @Nullable String host;
  private final @Nullable String path;
  private final @Nullable Integer port;
  private final String routeId;
  private final @Nullable String spaceId;

  private UpdateRouteRequest(UpdateRouteRequest.Builder builder) {
    this.domainId = builder.domainId;
    this.host = builder.host;
    this.path = builder.path;
    this.port = builder.port;
    this.routeId = builder.routeId;
    this.spaceId = builder.spaceId;
  }

  /**
   * The domain id
   */
  @Override
  public @Nullable String getDomainId() {
    return domainId;
  }

  /**
   * The host
   */
  @Override
  public @Nullable String getHost() {
    return host;
  }

  /**
   * The path
   */
  @Override
  public @Nullable String getPath() {
    return path;
  }

  /**
   * The port
   */
  @Override
  public @Nullable Integer getPort() {
    return port;
  }

  /**
   * The route id
   */
  @Override
  public String getRouteId() {
    return routeId;
  }

  /**
   * The space id
   */
  @Override
  public @Nullable String getSpaceId() {
    return spaceId;
  }

  /**
   * This instance is equal to all instances of {@code UpdateRouteRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateRouteRequest
        && equalTo((UpdateRouteRequest) another);
  }

  private boolean equalTo(UpdateRouteRequest another) {
    return Objects.equals(domainId, another.domainId)
        && Objects.equals(host, another.host)
        && Objects.equals(path, another.path)
        && Objects.equals(port, another.port)
        && routeId.equals(another.routeId)
        && Objects.equals(spaceId, another.spaceId);
  }

  /**
   * Computes a hash code from attributes: {@code domainId}, {@code host}, {@code path}, {@code port}, {@code routeId}, {@code spaceId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(domainId);
    h = h * 17 + Objects.hashCode(host);
    h = h * 17 + Objects.hashCode(path);
    h = h * 17 + Objects.hashCode(port);
    h = h * 17 + routeId.hashCode();
    h = h * 17 + Objects.hashCode(spaceId);
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateRouteRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateRouteRequest{"
        + "domainId=" + domainId
        + ", host=" + host
        + ", path=" + path
        + ", port=" + port
        + ", routeId=" + routeId
        + ", spaceId=" + spaceId
        + "}";
  }

  /**
   * Creates a builder for {@link UpdateRouteRequest UpdateRouteRequest}.
   * @return A new UpdateRouteRequest builder
   */
  public static UpdateRouteRequest.Builder builder() {
    return new UpdateRouteRequest.Builder();
  }

  /**
   * Builds instances of type {@link UpdateRouteRequest UpdateRouteRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_ROUTE_ID = 0x1L;
    private long initBits = 0x1L;

    private String domainId;
    private String host;
    private String path;
    private Integer port;
    private String routeId;
    private String spaceId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateRouteRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateRouteRequest instance) {
      return from((_UpdateRouteRequest) instance);
    }

    /**
     * Copy abstract value type {@code _UpdateRouteRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UpdateRouteRequest instance) {
      Objects.requireNonNull(instance, "instance");
      String domainIdValue = instance.getDomainId();
      if (domainIdValue != null) {
        domainId(domainIdValue);
      }
      String hostValue = instance.getHost();
      if (hostValue != null) {
        host(hostValue);
      }
      String pathValue = instance.getPath();
      if (pathValue != null) {
        path(pathValue);
      }
      Integer portValue = instance.getPort();
      if (portValue != null) {
        port(portValue);
      }
      routeId(instance.getRouteId());
      String spaceIdValue = instance.getSpaceId();
      if (spaceIdValue != null) {
        spaceId(spaceIdValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateRouteRequest#getDomainId() domainId} attribute.
     * @param domainId The value for domainId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder domainId(@Nullable String domainId) {
      this.domainId = domainId;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateRouteRequest#getHost() host} attribute.
     * @param host The value for host (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder host(@Nullable String host) {
      this.host = host;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateRouteRequest#getPath() path} attribute.
     * @param path The value for path (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder path(@Nullable String path) {
      this.path = path;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateRouteRequest#getPort() port} attribute.
     * @param port The value for port (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder port(@Nullable Integer port) {
      this.port = port;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateRouteRequest#getRouteId() routeId} attribute.
     * @param routeId The value for routeId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder routeId(String routeId) {
      this.routeId = Objects.requireNonNull(routeId, "routeId");
      initBits &= ~INIT_BIT_ROUTE_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateRouteRequest#getSpaceId() spaceId} attribute.
     * @param spaceId The value for spaceId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(@Nullable String spaceId) {
      this.spaceId = spaceId;
      return this;
    }

    /**
     * Builds a new {@link UpdateRouteRequest UpdateRouteRequest}.
     * @return An immutable instance of UpdateRouteRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateRouteRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UpdateRouteRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_ROUTE_ID) != 0) attributes.add("routeId");
      return "Cannot build UpdateRouteRequest, some of required attributes are not set " + attributes;
    }
  }
}
