package org.cloudfoundry.client.v2.securitygroups;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request payload for the Remove Space from the Security Group operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_RemoveSecurityGroupSpaceRequest"})
public final class RemoveSecurityGroupSpaceRequest
    extends org.cloudfoundry.client.v2.securitygroups._RemoveSecurityGroupSpaceRequest {
  private final String securityGroupId;
  private final String spaceId;

  private RemoveSecurityGroupSpaceRequest(RemoveSecurityGroupSpaceRequest.Builder builder) {
    this.securityGroupId = builder.securityGroupId;
    this.spaceId = builder.spaceId;
  }

  /**
   * The security group id
   */
  @Override
  public String getSecurityGroupId() {
    return securityGroupId;
  }

  /**
   * The space id
   */
  @Override
  public String getSpaceId() {
    return spaceId;
  }

  /**
   * This instance is equal to all instances of {@code RemoveSecurityGroupSpaceRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof RemoveSecurityGroupSpaceRequest
        && equalTo((RemoveSecurityGroupSpaceRequest) another);
  }

  private boolean equalTo(RemoveSecurityGroupSpaceRequest another) {
    return securityGroupId.equals(another.securityGroupId)
        && spaceId.equals(another.spaceId);
  }

  /**
   * Computes a hash code from attributes: {@code securityGroupId}, {@code spaceId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + securityGroupId.hashCode();
    h = h * 17 + spaceId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RemoveSecurityGroupSpaceRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RemoveSecurityGroupSpaceRequest{"
        + "securityGroupId=" + securityGroupId
        + ", spaceId=" + spaceId
        + "}";
  }

  /**
   * Creates a builder for {@link RemoveSecurityGroupSpaceRequest RemoveSecurityGroupSpaceRequest}.
   * @return A new RemoveSecurityGroupSpaceRequest builder
   */
  public static RemoveSecurityGroupSpaceRequest.Builder builder() {
    return new RemoveSecurityGroupSpaceRequest.Builder();
  }

  /**
   * Builds instances of type {@link RemoveSecurityGroupSpaceRequest RemoveSecurityGroupSpaceRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_SECURITY_GROUP_ID = 0x1L;
    private static final long INIT_BIT_SPACE_ID = 0x2L;
    private long initBits = 0x3L;

    private String securityGroupId;
    private String spaceId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RemoveSecurityGroupSpaceRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RemoveSecurityGroupSpaceRequest instance) {
      return from((_RemoveSecurityGroupSpaceRequest) instance);
    }

    /**
     * Copy abstract value type {@code _RemoveSecurityGroupSpaceRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_RemoveSecurityGroupSpaceRequest instance) {
      Objects.requireNonNull(instance, "instance");
      securityGroupId(instance.getSecurityGroupId());
      spaceId(instance.getSpaceId());
      return this;
    }

    /**
     * Initializes the value for the {@link _RemoveSecurityGroupSpaceRequest#getSecurityGroupId() securityGroupId} attribute.
     * @param securityGroupId The value for securityGroupId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder securityGroupId(String securityGroupId) {
      this.securityGroupId = Objects.requireNonNull(securityGroupId, "securityGroupId");
      initBits &= ~INIT_BIT_SECURITY_GROUP_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _RemoveSecurityGroupSpaceRequest#getSpaceId() spaceId} attribute.
     * @param spaceId The value for spaceId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(String spaceId) {
      this.spaceId = Objects.requireNonNull(spaceId, "spaceId");
      initBits &= ~INIT_BIT_SPACE_ID;
      return this;
    }

    /**
     * Builds a new {@link RemoveSecurityGroupSpaceRequest RemoveSecurityGroupSpaceRequest}.
     * @return An immutable instance of RemoveSecurityGroupSpaceRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public RemoveSecurityGroupSpaceRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new RemoveSecurityGroupSpaceRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_SECURITY_GROUP_ID) != 0) attributes.add("securityGroupId");
      if ((initBits & INIT_BIT_SPACE_ID) != 0) attributes.add("spaceId");
      return "Cannot build RemoveSecurityGroupSpaceRequest, some of required attributes are not set " + attributes;
    }
  }
}
