package org.cloudfoundry.client.v2.serviceinstances;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The request payload for the Delete Service Instance operation.
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_DeleteServiceInstanceRequest"})
public final class DeleteServiceInstanceRequest
    extends org.cloudfoundry.client.v2.serviceinstances._DeleteServiceInstanceRequest {
  private final @Nullable Boolean acceptsIncomplete;
  private final @Nullable Boolean async;
  private final @Nullable Boolean purge;
  private final @Nullable Boolean recursive;
  private final String serviceInstanceId;

  private DeleteServiceInstanceRequest(DeleteServiceInstanceRequest.Builder builder) {
    this.acceptsIncomplete = builder.acceptsIncomplete;
    this.async = builder.async;
    this.purge = builder.purge;
    this.recursive = builder.recursive;
    this.serviceInstanceId = builder.serviceInstanceId;
  }

  /**
   * The accept incomplete flag
   */
  @Override
  public @Nullable Boolean getAcceptsIncomplete() {
    return acceptsIncomplete;
  }

  /**
   * The async flag
   */
  @Override
  public @Nullable Boolean getAsync() {
    return async;
  }

  /**
   * The purge flag
   */
  @Override
  public @Nullable Boolean getPurge() {
    return purge;
  }

  /**
   * The recursive flag
   */
  @Override
  public @Nullable Boolean getRecursive() {
    return recursive;
  }

  /**
   * The service instance id
   */
  @Override
  public String getServiceInstanceId() {
    return serviceInstanceId;
  }

  /**
   * This instance is equal to all instances of {@code DeleteServiceInstanceRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof DeleteServiceInstanceRequest
        && equalTo((DeleteServiceInstanceRequest) another);
  }

  private boolean equalTo(DeleteServiceInstanceRequest another) {
    return Objects.equals(acceptsIncomplete, another.acceptsIncomplete)
        && Objects.equals(async, another.async)
        && Objects.equals(purge, another.purge)
        && Objects.equals(recursive, another.recursive)
        && serviceInstanceId.equals(another.serviceInstanceId);
  }

  /**
   * Computes a hash code from attributes: {@code acceptsIncomplete}, {@code async}, {@code purge}, {@code recursive}, {@code serviceInstanceId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(acceptsIncomplete);
    h = h * 17 + Objects.hashCode(async);
    h = h * 17 + Objects.hashCode(purge);
    h = h * 17 + Objects.hashCode(recursive);
    h = h * 17 + serviceInstanceId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DeleteServiceInstanceRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DeleteServiceInstanceRequest{"
        + "acceptsIncomplete=" + acceptsIncomplete
        + ", async=" + async
        + ", purge=" + purge
        + ", recursive=" + recursive
        + ", serviceInstanceId=" + serviceInstanceId
        + "}";
  }

  /**
   * Creates a builder for {@link DeleteServiceInstanceRequest DeleteServiceInstanceRequest}.
   * @return A new DeleteServiceInstanceRequest builder
   */
  public static DeleteServiceInstanceRequest.Builder builder() {
    return new DeleteServiceInstanceRequest.Builder();
  }

  /**
   * Builds instances of type {@link DeleteServiceInstanceRequest DeleteServiceInstanceRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_SERVICE_INSTANCE_ID = 0x1L;
    private long initBits = 0x1L;

    private Boolean acceptsIncomplete;
    private Boolean async;
    private Boolean purge;
    private Boolean recursive;
    private String serviceInstanceId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DeleteServiceInstanceRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DeleteServiceInstanceRequest instance) {
      return from((_DeleteServiceInstanceRequest) instance);
    }

    /**
     * Copy abstract value type {@code _DeleteServiceInstanceRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_DeleteServiceInstanceRequest instance) {
      Objects.requireNonNull(instance, "instance");
      Boolean acceptsIncompleteValue = instance.getAcceptsIncomplete();
      if (acceptsIncompleteValue != null) {
        acceptsIncomplete(acceptsIncompleteValue);
      }
      Boolean asyncValue = instance.getAsync();
      if (asyncValue != null) {
        async(asyncValue);
      }
      Boolean purgeValue = instance.getPurge();
      if (purgeValue != null) {
        purge(purgeValue);
      }
      Boolean recursiveValue = instance.getRecursive();
      if (recursiveValue != null) {
        recursive(recursiveValue);
      }
      serviceInstanceId(instance.getServiceInstanceId());
      return this;
    }

    /**
     * Initializes the value for the {@link _DeleteServiceInstanceRequest#getAcceptsIncomplete() acceptsIncomplete} attribute.
     * @param acceptsIncomplete The value for acceptsIncomplete (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder acceptsIncomplete(@Nullable Boolean acceptsIncomplete) {
      this.acceptsIncomplete = acceptsIncomplete;
      return this;
    }

    /**
     * Initializes the value for the {@link _DeleteServiceInstanceRequest#getAsync() async} attribute.
     * @param async The value for async (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder async(@Nullable Boolean async) {
      this.async = async;
      return this;
    }

    /**
     * Initializes the value for the {@link _DeleteServiceInstanceRequest#getPurge() purge} attribute.
     * @param purge The value for purge (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder purge(@Nullable Boolean purge) {
      this.purge = purge;
      return this;
    }

    /**
     * Initializes the value for the {@link _DeleteServiceInstanceRequest#getRecursive() recursive} attribute.
     * @param recursive The value for recursive (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder recursive(@Nullable Boolean recursive) {
      this.recursive = recursive;
      return this;
    }

    /**
     * Initializes the value for the {@link _DeleteServiceInstanceRequest#getServiceInstanceId() serviceInstanceId} attribute.
     * @param serviceInstanceId The value for serviceInstanceId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceInstanceId(String serviceInstanceId) {
      this.serviceInstanceId = Objects.requireNonNull(serviceInstanceId, "serviceInstanceId");
      initBits &= ~INIT_BIT_SERVICE_INSTANCE_ID;
      return this;
    }

    /**
     * Builds a new {@link DeleteServiceInstanceRequest DeleteServiceInstanceRequest}.
     * @return An immutable instance of DeleteServiceInstanceRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public DeleteServiceInstanceRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new DeleteServiceInstanceRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_SERVICE_INSTANCE_ID) != 0) attributes.add("serviceInstanceId");
      return "Cannot build DeleteServiceInstanceRequest, some of required attributes are not set " + attributes;
    }
  }
}
