package org.cloudfoundry.client.v2.serviceinstances;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The service payload
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_Service"})
public final class Service extends org.cloudfoundry.client.v2.serviceinstances._Service {
  private final @Nullable String id;
  private final @Nullable String label;
  private final @Nullable String provider;
  private final @Nullable String version;

  private Service(Service.Builder builder) {
    this.id = builder.id;
    this.label = builder.label;
    this.provider = builder.provider;
    this.version = builder.version;
  }

  /**
   * The id
   */
  @JsonProperty("guid")
  @Override
  public @Nullable String getId() {
    return id;
  }

  /**
   * The label
   */
  @JsonProperty("label")
  @Override
  public @Nullable String getLabel() {
    return label;
  }

  /**
   * The provider
   */
  @JsonProperty("provider")
  @Override
  public @Nullable String getProvider() {
    return provider;
  }

  /**
   * The version
   */
  @JsonProperty("version")
  @Override
  public @Nullable String getVersion() {
    return version;
  }

  /**
   * This instance is equal to all instances of {@code Service} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Service
        && equalTo((Service) another);
  }

  private boolean equalTo(Service another) {
    return Objects.equals(id, another.id)
        && Objects.equals(label, another.label)
        && Objects.equals(provider, another.provider)
        && Objects.equals(version, another.version);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code label}, {@code provider}, {@code version}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(id);
    h = h * 17 + Objects.hashCode(label);
    h = h * 17 + Objects.hashCode(provider);
    h = h * 17 + Objects.hashCode(version);
    return h;
  }

  /**
   * Prints the immutable value {@code Service} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Service{"
        + "id=" + id
        + ", label=" + label
        + ", provider=" + provider
        + ", version=" + version
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.serviceinstances._Service {
    String id;
    String label;
    String provider;
    String version;
    @JsonProperty("guid")
    public void setId(@Nullable String id) {
      this.id = id;
    }
    @JsonProperty("label")
    public void setLabel(@Nullable String label) {
      this.label = label;
    }
    @JsonProperty("provider")
    public void setProvider(@Nullable String provider) {
      this.provider = provider;
    }
    @JsonProperty("version")
    public void setVersion(@Nullable String version) {
      this.version = version;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getLabel() { throw new UnsupportedOperationException(); }
    @Override
    public String getProvider() { throw new UnsupportedOperationException(); }
    @Override
    public String getVersion() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static Service fromJson(Json json) {
    Service.Builder builder = Service.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.label != null) {
      builder.label(json.label);
    }
    if (json.provider != null) {
      builder.provider(json.provider);
    }
    if (json.version != null) {
      builder.version(json.version);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Service Service}.
   * @return A new Service builder
   */
  public static Service.Builder builder() {
    return new Service.Builder();
  }

  /**
   * Builds instances of type {@link Service Service}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private String id;
    private String label;
    private String provider;
    private String version;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Service} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Service instance) {
      return from((_Service) instance);
    }

    /**
     * Copy abstract value type {@code _Service} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Service instance) {
      Objects.requireNonNull(instance, "instance");
      String idValue = instance.getId();
      if (idValue != null) {
        id(idValue);
      }
      String labelValue = instance.getLabel();
      if (labelValue != null) {
        label(labelValue);
      }
      String providerValue = instance.getProvider();
      if (providerValue != null) {
        provider(providerValue);
      }
      String versionValue = instance.getVersion();
      if (versionValue != null) {
        version(versionValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _Service#getId() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("guid")
    public final Builder id(@Nullable String id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link _Service#getLabel() label} attribute.
     * @param label The value for label (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("label")
    public final Builder label(@Nullable String label) {
      this.label = label;
      return this;
    }

    /**
     * Initializes the value for the {@link _Service#getProvider() provider} attribute.
     * @param provider The value for provider (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("provider")
    public final Builder provider(@Nullable String provider) {
      this.provider = provider;
      return this;
    }

    /**
     * Initializes the value for the {@link _Service#getVersion() version} attribute.
     * @param version The value for version (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("version")
    public final Builder version(@Nullable String version) {
      this.version = version;
      return this;
    }

    /**
     * Builds a new {@link Service Service}.
     * @return An immutable instance of Service
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Service build() {
      return new Service(this);
    }
  }
}
