package org.cloudfoundry.client.v2.serviceusageevents;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request payload for the Get Service Usage Events operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_GetServiceUsageEventRequest"})
public final class GetServiceUsageEventRequest
    extends org.cloudfoundry.client.v2.serviceusageevents._GetServiceUsageEventRequest {
  private final String serviceUsageEventId;

  private GetServiceUsageEventRequest(GetServiceUsageEventRequest.Builder builder) {
    this.serviceUsageEventId = builder.serviceUsageEventId;
  }

  /**
   * The service usage event id
   */
  @Override
  public String getServiceUsageEventId() {
    return serviceUsageEventId;
  }

  /**
   * This instance is equal to all instances of {@code GetServiceUsageEventRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetServiceUsageEventRequest
        && equalTo((GetServiceUsageEventRequest) another);
  }

  private boolean equalTo(GetServiceUsageEventRequest another) {
    return serviceUsageEventId.equals(another.serviceUsageEventId);
  }

  /**
   * Computes a hash code from attributes: {@code serviceUsageEventId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + serviceUsageEventId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetServiceUsageEventRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetServiceUsageEventRequest{"
        + "serviceUsageEventId=" + serviceUsageEventId
        + "}";
  }

  /**
   * Creates a builder for {@link GetServiceUsageEventRequest GetServiceUsageEventRequest}.
   * @return A new GetServiceUsageEventRequest builder
   */
  public static GetServiceUsageEventRequest.Builder builder() {
    return new GetServiceUsageEventRequest.Builder();
  }

  /**
   * Builds instances of type {@link GetServiceUsageEventRequest GetServiceUsageEventRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_SERVICE_USAGE_EVENT_ID = 0x1L;
    private long initBits = 0x1L;

    private String serviceUsageEventId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetServiceUsageEventRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetServiceUsageEventRequest instance) {
      return from((_GetServiceUsageEventRequest) instance);
    }

    /**
     * Copy abstract value type {@code _GetServiceUsageEventRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetServiceUsageEventRequest instance) {
      Objects.requireNonNull(instance, "instance");
      serviceUsageEventId(instance.getServiceUsageEventId());
      return this;
    }

    /**
     * Initializes the value for the {@link _GetServiceUsageEventRequest#getServiceUsageEventId() serviceUsageEventId} attribute.
     * @param serviceUsageEventId The value for serviceUsageEventId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceUsageEventId(String serviceUsageEventId) {
      this.serviceUsageEventId = Objects.requireNonNull(serviceUsageEventId, "serviceUsageEventId");
      initBits &= ~INIT_BIT_SERVICE_USAGE_EVENT_ID;
      return this;
    }

    /**
     * Builds a new {@link GetServiceUsageEventRequest GetServiceUsageEventRequest}.
     * @return An immutable instance of GetServiceUsageEventRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetServiceUsageEventRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetServiceUsageEventRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_SERVICE_USAGE_EVENT_ID) != 0) attributes.add("serviceUsageEventId");
      return "Cannot build GetServiceUsageEventRequest, some of required attributes are not set " + attributes;
    }
  }
}
