package org.cloudfoundry.client.v2.spaces;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request payload for the Associate Auditor with the Space operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_AssociateSpaceAuditorRequest"})
public final class AssociateSpaceAuditorRequest
    extends org.cloudfoundry.client.v2.spaces._AssociateSpaceAuditorRequest {
  private final String auditorId;
  private final String spaceId;

  private AssociateSpaceAuditorRequest(AssociateSpaceAuditorRequest.Builder builder) {
    this.auditorId = builder.auditorId;
    this.spaceId = builder.spaceId;
  }

  /**
   * The auditor id
   */
  @Override
  public String getAuditorId() {
    return auditorId;
  }

  /**
   * The space id
   */
  @Override
  public String getSpaceId() {
    return spaceId;
  }

  /**
   * This instance is equal to all instances of {@code AssociateSpaceAuditorRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof AssociateSpaceAuditorRequest
        && equalTo((AssociateSpaceAuditorRequest) another);
  }

  private boolean equalTo(AssociateSpaceAuditorRequest another) {
    return auditorId.equals(another.auditorId)
        && spaceId.equals(another.spaceId);
  }

  /**
   * Computes a hash code from attributes: {@code auditorId}, {@code spaceId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + auditorId.hashCode();
    h = h * 17 + spaceId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code AssociateSpaceAuditorRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "AssociateSpaceAuditorRequest{"
        + "auditorId=" + auditorId
        + ", spaceId=" + spaceId
        + "}";
  }

  /**
   * Creates a builder for {@link AssociateSpaceAuditorRequest AssociateSpaceAuditorRequest}.
   * @return A new AssociateSpaceAuditorRequest builder
   */
  public static AssociateSpaceAuditorRequest.Builder builder() {
    return new AssociateSpaceAuditorRequest.Builder();
  }

  /**
   * Builds instances of type {@link AssociateSpaceAuditorRequest AssociateSpaceAuditorRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_AUDITOR_ID = 0x1L;
    private static final long INIT_BIT_SPACE_ID = 0x2L;
    private long initBits = 0x3L;

    private String auditorId;
    private String spaceId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AssociateSpaceAuditorRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AssociateSpaceAuditorRequest instance) {
      return from((_AssociateSpaceAuditorRequest) instance);
    }

    /**
     * Copy abstract value type {@code _AssociateSpaceAuditorRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_AssociateSpaceAuditorRequest instance) {
      Objects.requireNonNull(instance, "instance");
      auditorId(instance.getAuditorId());
      spaceId(instance.getSpaceId());
      return this;
    }

    /**
     * Initializes the value for the {@link _AssociateSpaceAuditorRequest#getAuditorId() auditorId} attribute.
     * @param auditorId The value for auditorId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder auditorId(String auditorId) {
      this.auditorId = Objects.requireNonNull(auditorId, "auditorId");
      initBits &= ~INIT_BIT_AUDITOR_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _AssociateSpaceAuditorRequest#getSpaceId() spaceId} attribute.
     * @param spaceId The value for spaceId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(String spaceId) {
      this.spaceId = Objects.requireNonNull(spaceId, "spaceId");
      initBits &= ~INIT_BIT_SPACE_ID;
      return this;
    }

    /**
     * Builds a new {@link AssociateSpaceAuditorRequest AssociateSpaceAuditorRequest}.
     * @return An immutable instance of AssociateSpaceAuditorRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public AssociateSpaceAuditorRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new AssociateSpaceAuditorRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_AUDITOR_ID) != 0) attributes.add("auditorId");
      if ((initBits & INIT_BIT_SPACE_ID) != 0) attributes.add("spaceId");
      return "Cannot build AssociateSpaceAuditorRequest, some of required attributes are not set " + attributes;
    }
  }
}
