package org.cloudfoundry.client.v2.spaces;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request payload for the Associate Developer with the Space operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_AssociateSpaceDeveloperRequest"})
public final class AssociateSpaceDeveloperRequest
    extends org.cloudfoundry.client.v2.spaces._AssociateSpaceDeveloperRequest {
  private final String developerId;
  private final String spaceId;

  private AssociateSpaceDeveloperRequest(AssociateSpaceDeveloperRequest.Builder builder) {
    this.developerId = builder.developerId;
    this.spaceId = builder.spaceId;
  }

  /**
   * The developer id
   */
  @Override
  public String getDeveloperId() {
    return developerId;
  }

  /**
   * The space id
   */
  @Override
  public String getSpaceId() {
    return spaceId;
  }

  /**
   * This instance is equal to all instances of {@code AssociateSpaceDeveloperRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof AssociateSpaceDeveloperRequest
        && equalTo((AssociateSpaceDeveloperRequest) another);
  }

  private boolean equalTo(AssociateSpaceDeveloperRequest another) {
    return developerId.equals(another.developerId)
        && spaceId.equals(another.spaceId);
  }

  /**
   * Computes a hash code from attributes: {@code developerId}, {@code spaceId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + developerId.hashCode();
    h = h * 17 + spaceId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code AssociateSpaceDeveloperRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "AssociateSpaceDeveloperRequest{"
        + "developerId=" + developerId
        + ", spaceId=" + spaceId
        + "}";
  }

  /**
   * Creates a builder for {@link AssociateSpaceDeveloperRequest AssociateSpaceDeveloperRequest}.
   * @return A new AssociateSpaceDeveloperRequest builder
   */
  public static AssociateSpaceDeveloperRequest.Builder builder() {
    return new AssociateSpaceDeveloperRequest.Builder();
  }

  /**
   * Builds instances of type {@link AssociateSpaceDeveloperRequest AssociateSpaceDeveloperRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_DEVELOPER_ID = 0x1L;
    private static final long INIT_BIT_SPACE_ID = 0x2L;
    private long initBits = 0x3L;

    private String developerId;
    private String spaceId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AssociateSpaceDeveloperRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AssociateSpaceDeveloperRequest instance) {
      return from((_AssociateSpaceDeveloperRequest) instance);
    }

    /**
     * Copy abstract value type {@code _AssociateSpaceDeveloperRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_AssociateSpaceDeveloperRequest instance) {
      Objects.requireNonNull(instance, "instance");
      developerId(instance.getDeveloperId());
      spaceId(instance.getSpaceId());
      return this;
    }

    /**
     * Initializes the value for the {@link _AssociateSpaceDeveloperRequest#getDeveloperId() developerId} attribute.
     * @param developerId The value for developerId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder developerId(String developerId) {
      this.developerId = Objects.requireNonNull(developerId, "developerId");
      initBits &= ~INIT_BIT_DEVELOPER_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _AssociateSpaceDeveloperRequest#getSpaceId() spaceId} attribute.
     * @param spaceId The value for spaceId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(String spaceId) {
      this.spaceId = Objects.requireNonNull(spaceId, "spaceId");
      initBits &= ~INIT_BIT_SPACE_ID;
      return this;
    }

    /**
     * Builds a new {@link AssociateSpaceDeveloperRequest AssociateSpaceDeveloperRequest}.
     * @return An immutable instance of AssociateSpaceDeveloperRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public AssociateSpaceDeveloperRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new AssociateSpaceDeveloperRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_DEVELOPER_ID) != 0) attributes.add("developerId");
      if ((initBits & INIT_BIT_SPACE_ID) != 0) attributes.add("spaceId");
      return "Cannot build AssociateSpaceDeveloperRequest, some of required attributes are not set " + attributes;
    }
  }
}
