package org.cloudfoundry.client.v3.applications;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request payload for the Delete Application Process Instance operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_TerminateApplicationInstanceRequest"})
public final class TerminateApplicationInstanceRequest
    extends org.cloudfoundry.client.v3.applications._TerminateApplicationInstanceRequest {
  private final String applicationId;
  private final String index;
  private final String type;

  private TerminateApplicationInstanceRequest(TerminateApplicationInstanceRequest.Builder builder) {
    this.applicationId = builder.applicationId;
    this.index = builder.index;
    this.type = builder.type;
  }

  /**
   * The application id
   */
  @Override
  public String getApplicationId() {
    return applicationId;
  }

  /**
   * The index
   */
  @Override
  public String getIndex() {
    return index;
  }

  /**
   * The type
   */
  @Override
  public String getType() {
    return type;
  }

  /**
   * This instance is equal to all instances of {@code TerminateApplicationInstanceRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof TerminateApplicationInstanceRequest
        && equalTo((TerminateApplicationInstanceRequest) another);
  }

  private boolean equalTo(TerminateApplicationInstanceRequest another) {
    return applicationId.equals(another.applicationId)
        && index.equals(another.index)
        && type.equals(another.type);
  }

  /**
   * Computes a hash code from attributes: {@code applicationId}, {@code index}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + applicationId.hashCode();
    h = h * 17 + index.hashCode();
    h = h * 17 + type.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code TerminateApplicationInstanceRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "TerminateApplicationInstanceRequest{"
        + "applicationId=" + applicationId
        + ", index=" + index
        + ", type=" + type
        + "}";
  }

  /**
   * Creates a builder for {@link TerminateApplicationInstanceRequest TerminateApplicationInstanceRequest}.
   * @return A new TerminateApplicationInstanceRequest builder
   */
  public static TerminateApplicationInstanceRequest.Builder builder() {
    return new TerminateApplicationInstanceRequest.Builder();
  }

  /**
   * Builds instances of type {@link TerminateApplicationInstanceRequest TerminateApplicationInstanceRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_APPLICATION_ID = 0x1L;
    private static final long INIT_BIT_INDEX = 0x2L;
    private static final long INIT_BIT_TYPE = 0x4L;
    private long initBits = 0x7L;

    private String applicationId;
    private String index;
    private String type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code TerminateApplicationInstanceRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(TerminateApplicationInstanceRequest instance) {
      return from((_TerminateApplicationInstanceRequest) instance);
    }

    /**
     * Copy abstract value type {@code _TerminateApplicationInstanceRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_TerminateApplicationInstanceRequest instance) {
      Objects.requireNonNull(instance, "instance");
      applicationId(instance.getApplicationId());
      index(instance.getIndex());
      type(instance.getType());
      return this;
    }

    /**
     * Initializes the value for the {@link _TerminateApplicationInstanceRequest#getApplicationId() applicationId} attribute.
     * @param applicationId The value for applicationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationId(String applicationId) {
      this.applicationId = Objects.requireNonNull(applicationId, "applicationId");
      initBits &= ~INIT_BIT_APPLICATION_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _TerminateApplicationInstanceRequest#getIndex() index} attribute.
     * @param index The value for index 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder index(String index) {
      this.index = Objects.requireNonNull(index, "index");
      initBits &= ~INIT_BIT_INDEX;
      return this;
    }

    /**
     * Initializes the value for the {@link _TerminateApplicationInstanceRequest#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder type(String type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Builds a new {@link TerminateApplicationInstanceRequest TerminateApplicationInstanceRequest}.
     * @return An immutable instance of TerminateApplicationInstanceRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public TerminateApplicationInstanceRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new TerminateApplicationInstanceRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_APPLICATION_ID) != 0) attributes.add("applicationId");
      if ((initBits & INIT_BIT_INDEX) != 0) attributes.add("index");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build TerminateApplicationInstanceRequest, some of required attributes are not set " + attributes;
    }
  }
}
