package org.cloudfoundry.client.v3.processes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The request payload for the Update Process operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_UpdateProcessRequest"})
public final class UpdateProcessRequest extends org.cloudfoundry.client.v3.processes._UpdateProcessRequest {
  private final String command;
  private final @Nullable HealthCheck healthCheck;
  private final @Nullable List<Integer> ports;
  private final String processId;

  private UpdateProcessRequest(UpdateProcessRequest.Builder builder) {
    this.command = builder.command;
    this.healthCheck = builder.healthCheck;
    this.ports = builder.ports == null ? null : createUnmodifiableList(true, builder.ports);
    this.processId = builder.processId;
  }

  /**
   * The command
   */
  @Override
  public String getCommand() {
    return command;
  }

  /**
   * The health check
   */
  @Override
  public @Nullable HealthCheck getHealthCheck() {
    return healthCheck;
  }

  /**
   * The ports
   */
  @Override
  public @Nullable List<Integer> getPorts() {
    return ports;
  }

  /**
   * The process id
   */
  @Override
  public String getProcessId() {
    return processId;
  }

  /**
   * This instance is equal to all instances of {@code UpdateProcessRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateProcessRequest
        && equalTo((UpdateProcessRequest) another);
  }

  private boolean equalTo(UpdateProcessRequest another) {
    return command.equals(another.command)
        && Objects.equals(healthCheck, another.healthCheck)
        && Objects.equals(ports, another.ports)
        && processId.equals(another.processId);
  }

  /**
   * Computes a hash code from attributes: {@code command}, {@code healthCheck}, {@code ports}, {@code processId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + command.hashCode();
    h = h * 17 + Objects.hashCode(healthCheck);
    h = h * 17 + Objects.hashCode(ports);
    h = h * 17 + processId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateProcessRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateProcessRequest{"
        + "command=" + command
        + ", healthCheck=" + healthCheck
        + ", ports=" + ports
        + ", processId=" + processId
        + "}";
  }

  /**
   * Creates a builder for {@link UpdateProcessRequest UpdateProcessRequest}.
   * @return A new UpdateProcessRequest builder
   */
  public static UpdateProcessRequest.Builder builder() {
    return new UpdateProcessRequest.Builder();
  }

  /**
   * Builds instances of type {@link UpdateProcessRequest UpdateProcessRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_COMMAND = 0x1L;
    private static final long INIT_BIT_PROCESS_ID = 0x2L;
    private long initBits = 0x3L;

    private String command;
    private HealthCheck healthCheck;
    private List<Integer> ports = null;
    private String processId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateProcessRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateProcessRequest instance) {
      return from((_UpdateProcessRequest) instance);
    }

    /**
     * Copy abstract value type {@code _UpdateProcessRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UpdateProcessRequest instance) {
      Objects.requireNonNull(instance, "instance");
      command(instance.getCommand());
      HealthCheck healthCheckValue = instance.getHealthCheck();
      if (healthCheckValue != null) {
        healthCheck(healthCheckValue);
      }
      List<Integer> portsValue = instance.getPorts();
      if (portsValue != null) {
        addAllPorts(portsValue);
      }
      processId(instance.getProcessId());
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateProcessRequest#getCommand() command} attribute.
     * @param command The value for command 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder command(String command) {
      this.command = Objects.requireNonNull(command, "command");
      initBits &= ~INIT_BIT_COMMAND;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateProcessRequest#getHealthCheck() healthCheck} attribute.
     * @param healthCheck The value for healthCheck (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder healthCheck(@Nullable HealthCheck healthCheck) {
      this.healthCheck = healthCheck;
      return this;
    }

    /**
     * Adds one element to {@link _UpdateProcessRequest#getPorts() ports} list.
     * @param element A ports element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder port(int element) {
      if (this.ports == null) {
        this.ports = new ArrayList<Integer>();
      }
      this.ports.add(element);
      return this;
    }

    /**
     * Adds elements to {@link _UpdateProcessRequest#getPorts() ports} list.
     * @param elements An array of ports elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder port(int... elements) {
      if (this.ports == null) {
        this.ports = new ArrayList<Integer>();
      }
      for (int element : elements) {
        this.ports.add(element);
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _UpdateProcessRequest#getPorts() ports} list.
     * @param elements An iterable of ports elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder ports(@Nullable Iterable<Integer> elements) {
      if (elements == null) {
        this.ports = null;
        return this;
      }
      this.ports = new ArrayList<Integer>();
      return addAllPorts(elements);
    }

    /**
     * Adds elements to {@link _UpdateProcessRequest#getPorts() ports} list.
     * @param elements An iterable of ports elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllPorts(Iterable<Integer> elements) {
      Objects.requireNonNull(elements, "ports element");
      if (this.ports == null) {
        this.ports = new ArrayList<Integer>();
      }
      for (int element : elements) {
        this.ports.add(Objects.requireNonNull(element, "ports element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateProcessRequest#getProcessId() processId} attribute.
     * @param processId The value for processId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder processId(String processId) {
      this.processId = Objects.requireNonNull(processId, "processId");
      initBits &= ~INIT_BIT_PROCESS_ID;
      return this;
    }

    /**
     * Builds a new {@link UpdateProcessRequest UpdateProcessRequest}.
     * @return An immutable instance of UpdateProcessRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateProcessRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UpdateProcessRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_COMMAND) != 0) attributes.add("command");
      if ((initBits & INIT_BIT_PROCESS_ID) != 0) attributes.add("processId");
      return "Cannot build UpdateProcessRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
