package org.cloudfoundry.routing.v1.tcproutes;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request payload for the Delete TCP Routes operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_DeleteTcpRoutesRequest"})
public final class DeleteTcpRoutesRequest
    extends org.cloudfoundry.routing.v1.tcproutes._DeleteTcpRoutesRequest {
  private final List<TcpRouteDeletion> tcpRoutes;

  private DeleteTcpRoutesRequest(DeleteTcpRoutesRequest.Builder builder) {
    this.tcpRoutes = createUnmodifiableList(true, builder.tcpRoutes);
  }

  /**
   * The TCP Routes
   */
  @JsonProperty("tcpRoutes")
  @Override
  public List<TcpRouteDeletion> getTcpRoutes() {
    return tcpRoutes;
  }

  /**
   * This instance is equal to all instances of {@code DeleteTcpRoutesRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof DeleteTcpRoutesRequest
        && equalTo((DeleteTcpRoutesRequest) another);
  }

  private boolean equalTo(DeleteTcpRoutesRequest another) {
    return tcpRoutes.equals(another.tcpRoutes);
  }

  /**
   * Computes a hash code from attributes: {@code tcpRoutes}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + tcpRoutes.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DeleteTcpRoutesRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DeleteTcpRoutesRequest{"
        + "tcpRoutes=" + tcpRoutes
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.routing.v1.tcproutes._DeleteTcpRoutesRequest {
    List<TcpRouteDeletion> tcpRoutes = Collections.emptyList();
    @JsonProperty("tcpRoutes")
    public void setTcpRoutes(List<TcpRouteDeletion> tcpRoutes) {
      this.tcpRoutes = tcpRoutes;
    }
    @Override
    public List<TcpRouteDeletion> getTcpRoutes() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static DeleteTcpRoutesRequest fromJson(Json json) {
    DeleteTcpRoutesRequest.Builder builder = DeleteTcpRoutesRequest.builder();
    if (json.tcpRoutes != null) {
      builder.addAllTcpRoutes(json.tcpRoutes);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link DeleteTcpRoutesRequest DeleteTcpRoutesRequest}.
   * @return A new DeleteTcpRoutesRequest builder
   */
  public static DeleteTcpRoutesRequest.Builder builder() {
    return new DeleteTcpRoutesRequest.Builder();
  }

  /**
   * Builds instances of type {@link DeleteTcpRoutesRequest DeleteTcpRoutesRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private List<TcpRouteDeletion> tcpRoutes = new ArrayList<TcpRouteDeletion>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DeleteTcpRoutesRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DeleteTcpRoutesRequest instance) {
      return from((_DeleteTcpRoutesRequest) instance);
    }

    /**
     * Copy abstract value type {@code _DeleteTcpRoutesRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_DeleteTcpRoutesRequest instance) {
      Objects.requireNonNull(instance, "instance");
      addAllTcpRoutes(instance.getTcpRoutes());
      return this;
    }

    /**
     * Adds one element to {@link _DeleteTcpRoutesRequest#getTcpRoutes() tcpRoutes} list.
     * @param element A tcpRoutes element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tcpRoute(TcpRouteDeletion element) {
      this.tcpRoutes.add(Objects.requireNonNull(element, "tcpRoutes element"));
      return this;
    }

    /**
     * Adds elements to {@link _DeleteTcpRoutesRequest#getTcpRoutes() tcpRoutes} list.
     * @param elements An array of tcpRoutes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tcpRoute(TcpRouteDeletion... elements) {
      for (TcpRouteDeletion element : elements) {
        this.tcpRoutes.add(Objects.requireNonNull(element, "tcpRoutes element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _DeleteTcpRoutesRequest#getTcpRoutes() tcpRoutes} list.
     * @param elements An iterable of tcpRoutes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("tcpRoutes")
    public final Builder tcpRoutes(Iterable<? extends TcpRouteDeletion> elements) {
      this.tcpRoutes.clear();
      return addAllTcpRoutes(elements);
    }

    /**
     * Adds elements to {@link _DeleteTcpRoutesRequest#getTcpRoutes() tcpRoutes} list.
     * @param elements An iterable of tcpRoutes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllTcpRoutes(Iterable<? extends TcpRouteDeletion> elements) {
      for (TcpRouteDeletion element : elements) {
        this.tcpRoutes.add(Objects.requireNonNull(element, "tcpRoutes element"));
      }
      return this;
    }

    /**
     * Builds a new {@link DeleteTcpRoutesRequest DeleteTcpRoutesRequest}.
     * @return An immutable instance of DeleteTcpRoutesRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public DeleteTcpRoutesRequest build() {
      return new DeleteTcpRoutesRequest(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
