package org.cloudfoundry.routing.v1.tcproutes;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.routing.v1.ModificationTag;

/**
 * The payload for TCP Route responses
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_TcpRoute"})
public final class TcpRoute extends org.cloudfoundry.routing.v1.tcproutes._TcpRoute {
  private final String backendIp;
  private final Integer backendPort;
  private final ModificationTag modificationTag;
  private final Integer port;
  private final String routerGroupId;
  private final Integer ttl;

  private TcpRoute(TcpRoute.Builder builder) {
    this.backendIp = builder.backendIp;
    this.backendPort = builder.backendPort;
    this.modificationTag = builder.modificationTag;
    this.port = builder.port;
    this.routerGroupId = builder.routerGroupId;
    this.ttl = builder.ttl;
  }

  /**
   * IP address of backend.
   */
  @JsonProperty("backend_ip")
  @Override
  public String getBackendIp() {
    return backendIp;
  }

  /**
   * Backend port.
   */
  @JsonProperty("backend_port")
  @Override
  public Integer getBackendPort() {
    return backendPort;
  }

  /**
   * Modification Tag for the route.
   */
  @JsonProperty("modification_tag")
  @Override
  public ModificationTag getModificationTag() {
    return modificationTag;
  }

  /**
   * External facing port for the TCP route.
   */
  @JsonProperty("port")
  @Override
  public Integer getPort() {
    return port;
  }

  /**
   * ID of the router group associated with this route.
   */
  @JsonProperty("router_group_guid")
  @Override
  public String getRouterGroupId() {
    return routerGroupId;
  }

  /**
   * Time to live, in seconds.
   */
  @JsonProperty("ttl")
  @Override
  public Integer getTtl() {
    return ttl;
  }

  /**
   * This instance is equal to all instances of {@code TcpRoute} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof TcpRoute
        && equalTo((TcpRoute) another);
  }

  private boolean equalTo(TcpRoute another) {
    return backendIp.equals(another.backendIp)
        && backendPort.equals(another.backendPort)
        && modificationTag.equals(another.modificationTag)
        && port.equals(another.port)
        && routerGroupId.equals(another.routerGroupId)
        && ttl.equals(another.ttl);
  }

  /**
   * Computes a hash code from attributes: {@code backendIp}, {@code backendPort}, {@code modificationTag}, {@code port}, {@code routerGroupId}, {@code ttl}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + backendIp.hashCode();
    h = h * 17 + backendPort.hashCode();
    h = h * 17 + modificationTag.hashCode();
    h = h * 17 + port.hashCode();
    h = h * 17 + routerGroupId.hashCode();
    h = h * 17 + ttl.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code TcpRoute} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "TcpRoute{"
        + "backendIp=" + backendIp
        + ", backendPort=" + backendPort
        + ", modificationTag=" + modificationTag
        + ", port=" + port
        + ", routerGroupId=" + routerGroupId
        + ", ttl=" + ttl
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.routing.v1.tcproutes._TcpRoute {
    String backendIp;
    Integer backendPort;
    ModificationTag modificationTag;
    Integer port;
    String routerGroupId;
    Integer ttl;
    @JsonProperty("backend_ip")
    public void setBackendIp(String backendIp) {
      this.backendIp = backendIp;
    }
    @JsonProperty("backend_port")
    public void setBackendPort(Integer backendPort) {
      this.backendPort = backendPort;
    }
    @JsonProperty("modification_tag")
    public void setModificationTag(ModificationTag modificationTag) {
      this.modificationTag = modificationTag;
    }
    @JsonProperty("port")
    public void setPort(Integer port) {
      this.port = port;
    }
    @JsonProperty("router_group_guid")
    public void setRouterGroupId(String routerGroupId) {
      this.routerGroupId = routerGroupId;
    }
    @JsonProperty("ttl")
    public void setTtl(Integer ttl) {
      this.ttl = ttl;
    }
    @Override
    public String getBackendIp() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getBackendPort() { throw new UnsupportedOperationException(); }
    @Override
    public ModificationTag getModificationTag() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getPort() { throw new UnsupportedOperationException(); }
    @Override
    public String getRouterGroupId() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getTtl() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static TcpRoute fromJson(Json json) {
    TcpRoute.Builder builder = TcpRoute.builder();
    if (json.backendIp != null) {
      builder.backendIp(json.backendIp);
    }
    if (json.backendPort != null) {
      builder.backendPort(json.backendPort);
    }
    if (json.modificationTag != null) {
      builder.modificationTag(json.modificationTag);
    }
    if (json.port != null) {
      builder.port(json.port);
    }
    if (json.routerGroupId != null) {
      builder.routerGroupId(json.routerGroupId);
    }
    if (json.ttl != null) {
      builder.ttl(json.ttl);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link TcpRoute TcpRoute}.
   * @return A new TcpRoute builder
   */
  public static TcpRoute.Builder builder() {
    return new TcpRoute.Builder();
  }

  /**
   * Builds instances of type {@link TcpRoute TcpRoute}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_BACKEND_IP = 0x1L;
    private static final long INIT_BIT_BACKEND_PORT = 0x2L;
    private static final long INIT_BIT_MODIFICATION_TAG = 0x4L;
    private static final long INIT_BIT_PORT = 0x8L;
    private static final long INIT_BIT_ROUTER_GROUP_ID = 0x10L;
    private static final long INIT_BIT_TTL = 0x20L;
    private long initBits = 0x3fL;

    private String backendIp;
    private Integer backendPort;
    private ModificationTag modificationTag;
    private Integer port;
    private String routerGroupId;
    private Integer ttl;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.routing.v1.tcproutes.AbstractTcpRoute} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractTcpRoute instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code TcpRoute} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(TcpRoute instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _TcpRoute} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_TcpRoute instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof AbstractTcpRoute) {
        AbstractTcpRoute instance = (AbstractTcpRoute) object;
        routerGroupId(instance.getRouterGroupId());
        backendPort(instance.getBackendPort());
        port(instance.getPort());
        backendIp(instance.getBackendIp());
        ttl(instance.getTtl());
        modificationTag(instance.getModificationTag());
      }
    }

    /**
     * Initializes the value for the {@link _TcpRoute#getBackendIp() backendIp} attribute.
     * @param backendIp The value for backendIp 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("backend_ip")
    public final Builder backendIp(String backendIp) {
      this.backendIp = Objects.requireNonNull(backendIp, "backendIp");
      initBits &= ~INIT_BIT_BACKEND_IP;
      return this;
    }

    /**
     * Initializes the value for the {@link _TcpRoute#getBackendPort() backendPort} attribute.
     * @param backendPort The value for backendPort 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("backend_port")
    public final Builder backendPort(Integer backendPort) {
      this.backendPort = Objects.requireNonNull(backendPort, "backendPort");
      initBits &= ~INIT_BIT_BACKEND_PORT;
      return this;
    }

    /**
     * Initializes the value for the {@link _TcpRoute#getModificationTag() modificationTag} attribute.
     * @param modificationTag The value for modificationTag 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("modification_tag")
    public final Builder modificationTag(ModificationTag modificationTag) {
      this.modificationTag = Objects.requireNonNull(modificationTag, "modificationTag");
      initBits &= ~INIT_BIT_MODIFICATION_TAG;
      return this;
    }

    /**
     * Initializes the value for the {@link _TcpRoute#getPort() port} attribute.
     * @param port The value for port 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("port")
    public final Builder port(Integer port) {
      this.port = Objects.requireNonNull(port, "port");
      initBits &= ~INIT_BIT_PORT;
      return this;
    }

    /**
     * Initializes the value for the {@link _TcpRoute#getRouterGroupId() routerGroupId} attribute.
     * @param routerGroupId The value for routerGroupId 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("router_group_guid")
    public final Builder routerGroupId(String routerGroupId) {
      this.routerGroupId = Objects.requireNonNull(routerGroupId, "routerGroupId");
      initBits &= ~INIT_BIT_ROUTER_GROUP_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _TcpRoute#getTtl() ttl} attribute.
     * @param ttl The value for ttl 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("ttl")
    public final Builder ttl(Integer ttl) {
      this.ttl = Objects.requireNonNull(ttl, "ttl");
      initBits &= ~INIT_BIT_TTL;
      return this;
    }

    /**
     * Builds a new {@link TcpRoute TcpRoute}.
     * @return An immutable instance of TcpRoute
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public TcpRoute build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new TcpRoute(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_BACKEND_IP) != 0) attributes.add("backendIp");
      if ((initBits & INIT_BIT_BACKEND_PORT) != 0) attributes.add("backendPort");
      if ((initBits & INIT_BIT_MODIFICATION_TAG) != 0) attributes.add("modificationTag");
      if ((initBits & INIT_BIT_PORT) != 0) attributes.add("port");
      if ((initBits & INIT_BIT_ROUTER_GROUP_ID) != 0) attributes.add("routerGroupId");
      if ((initBits & INIT_BIT_TTL) != 0) attributes.add("ttl");
      return "Cannot build TcpRoute, some of required attributes are not set " + attributes;
    }
  }
}
