package org.cloudfoundry.uaa.clients;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.IdentityZoned;

/**
 * The request payload for Update Metadata
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_UpdateMetadataRequest"})
public final class UpdateMetadataRequest extends org.cloudfoundry.uaa.clients._UpdateMetadataRequest {
  private final @Nullable String appIcon;
  private final @Nullable String appLaunchUrl;
  private final String clientId;
  private final @Nullable String clientName;
  private final @Nullable Boolean showOnHomePage;
  private final @Nullable String identityZoneId;

  private UpdateMetadataRequest(UpdateMetadataRequest.Builder builder) {
    this.appIcon = builder.appIcon;
    this.appLaunchUrl = builder.appLaunchUrl;
    this.clientId = builder.clientId;
    this.clientName = builder.clientName;
    this.showOnHomePage = builder.showOnHomePage;
    this.identityZoneId = builder.identityZoneId;
  }

  /**
   * Base64 encoded image file
   */
  @Override
  public @Nullable String getAppIcon() {
    return appIcon;
  }

  /**
   * URL to which the app is linked
   */
  @Override
  public @Nullable String getAppLaunchUrl() {
    return appLaunchUrl;
  }

  /**
   * Client identifier, unique within identity zone
   */
  @Override
  public String getClientId() {
    return clientId;
  }

  /**
   * Client name
   */
  @Override
  public @Nullable String getClientName() {
    return clientName;
  }

  /**
   * Flag to control visibility on home page
   */
  @Override
  public @Nullable Boolean getShowOnHomePage() {
    return showOnHomePage;
  }

  /**
   * Returns the identity zone id
   * @return the identity zone id
   */
  @Override
  public @Nullable String getIdentityZoneId() {
    return identityZoneId;
  }

  /**
   * This instance is equal to all instances of {@code UpdateMetadataRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateMetadataRequest
        && equalTo((UpdateMetadataRequest) another);
  }

  private boolean equalTo(UpdateMetadataRequest another) {
    return Objects.equals(appIcon, another.appIcon)
        && Objects.equals(appLaunchUrl, another.appLaunchUrl)
        && clientId.equals(another.clientId)
        && Objects.equals(clientName, another.clientName)
        && Objects.equals(showOnHomePage, another.showOnHomePage)
        && Objects.equals(identityZoneId, another.identityZoneId);
  }

  /**
   * Computes a hash code from attributes: {@code appIcon}, {@code appLaunchUrl}, {@code clientId}, {@code clientName}, {@code showOnHomePage}, {@code identityZoneId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(appIcon);
    h = h * 17 + Objects.hashCode(appLaunchUrl);
    h = h * 17 + clientId.hashCode();
    h = h * 17 + Objects.hashCode(clientName);
    h = h * 17 + Objects.hashCode(showOnHomePage);
    h = h * 17 + Objects.hashCode(identityZoneId);
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateMetadataRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateMetadataRequest{"
        + "appIcon=" + appIcon
        + ", appLaunchUrl=" + appLaunchUrl
        + ", clientId=" + clientId
        + ", clientName=" + clientName
        + ", showOnHomePage=" + showOnHomePage
        + ", identityZoneId=" + identityZoneId
        + "}";
  }

  /**
   * Creates a builder for {@link UpdateMetadataRequest UpdateMetadataRequest}.
   * @return A new UpdateMetadataRequest builder
   */
  public static UpdateMetadataRequest.Builder builder() {
    return new UpdateMetadataRequest.Builder();
  }

  /**
   * Builds instances of type {@link UpdateMetadataRequest UpdateMetadataRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_CLIENT_ID = 0x1L;
    private long initBits = 0x1L;

    private String appIcon;
    private String appLaunchUrl;
    private String clientId;
    private String clientName;
    private Boolean showOnHomePage;
    private String identityZoneId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.IdentityZoned} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(IdentityZoned instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateMetadataRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateMetadataRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _UpdateMetadataRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UpdateMetadataRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof IdentityZoned) {
        IdentityZoned instance = (IdentityZoned) object;
        String identityZoneIdValue = instance.getIdentityZoneId();
        if (identityZoneIdValue != null) {
          identityZoneId(identityZoneIdValue);
        }
      }
      if (object instanceof org.cloudfoundry.uaa.clients._UpdateMetadataRequest) {
        org.cloudfoundry.uaa.clients._UpdateMetadataRequest instance = (org.cloudfoundry.uaa.clients._UpdateMetadataRequest) object;
        String appIconValue = instance.getAppIcon();
        if (appIconValue != null) {
          appIcon(appIconValue);
        }
        clientId(instance.getClientId());
        Boolean showOnHomePageValue = instance.getShowOnHomePage();
        if (showOnHomePageValue != null) {
          showOnHomePage(showOnHomePageValue);
        }
        String clientNameValue = instance.getClientName();
        if (clientNameValue != null) {
          clientName(clientNameValue);
        }
        String appLaunchUrlValue = instance.getAppLaunchUrl();
        if (appLaunchUrlValue != null) {
          appLaunchUrl(appLaunchUrlValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link _UpdateMetadataRequest#getAppIcon() appIcon} attribute.
     * @param appIcon The value for appIcon (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder appIcon(@Nullable String appIcon) {
      this.appIcon = appIcon;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateMetadataRequest#getAppLaunchUrl() appLaunchUrl} attribute.
     * @param appLaunchUrl The value for appLaunchUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder appLaunchUrl(@Nullable String appLaunchUrl) {
      this.appLaunchUrl = appLaunchUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateMetadataRequest#getClientId() clientId} attribute.
     * @param clientId The value for clientId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder clientId(String clientId) {
      this.clientId = Objects.requireNonNull(clientId, "clientId");
      initBits &= ~INIT_BIT_CLIENT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateMetadataRequest#getClientName() clientName} attribute.
     * @param clientName The value for clientName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder clientName(@Nullable String clientName) {
      this.clientName = clientName;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateMetadataRequest#getShowOnHomePage() showOnHomePage} attribute.
     * @param showOnHomePage The value for showOnHomePage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder showOnHomePage(@Nullable Boolean showOnHomePage) {
      this.showOnHomePage = showOnHomePage;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateMetadataRequest#getIdentityZoneId() identityZoneId} attribute.
     * @param identityZoneId The value for identityZoneId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneId(@Nullable String identityZoneId) {
      this.identityZoneId = identityZoneId;
      return this;
    }

    /**
     * Builds a new {@link UpdateMetadataRequest UpdateMetadataRequest}.
     * @return An immutable instance of UpdateMetadataRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateMetadataRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UpdateMetadataRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_CLIENT_ID) != 0) attributes.add("clientId");
      return "Cannot build UpdateMetadataRequest, some of required attributes are not set " + attributes;
    }
  }
}
