package org.cloudfoundry.uaa.groups;

import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.IdentityZoned;
import org.cloudfoundry.uaa.PaginatedAndSortedByRequest;
import org.cloudfoundry.uaa.PaginatedAndSortedRequest;
import org.cloudfoundry.uaa.SortOrder;

/**
 * The request payload for the list groups operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_ListGroupsRequest"})
public final class ListGroupsRequest extends org.cloudfoundry.uaa.groups._ListGroupsRequest {
  private final @Nullable String sortBy;
  private final @Nullable Integer count;
  private final @Nullable String filter;
  private final @Nullable SortOrder sortOrder;
  private final @Nullable Integer startIndex;
  private final @Nullable String identityZoneId;

  private ListGroupsRequest(ListGroupsRequest.Builder builder) {
    this.sortBy = builder.sortBy;
    this.count = builder.count;
    this.filter = builder.filter;
    this.sortOrder = builder.sortOrder;
    this.startIndex = builder.startIndex;
    this.identityZoneId = builder.identityZoneId;
  }

  /**
   * The sort by
   */
  @Override
  public @Nullable String getSortBy() {
    return sortBy;
  }

  /**
   * The number of results per page
   */
  @Override
  public @Nullable Integer getCount() {
    return count;
  }

  /**
   * The filter
   */
  @Override
  public @Nullable String getFilter() {
    return filter;
  }

  /**
   * The sort order
   */
  @Override
  public @Nullable SortOrder getSortOrder() {
    return sortOrder;
  }

  /**
   * The start index
   */
  @Override
  public @Nullable Integer getStartIndex() {
    return startIndex;
  }

  /**
   * Returns the identity zone id
   * @return the identity zone id
   */
  @Override
  public @Nullable String getIdentityZoneId() {
    return identityZoneId;
  }

  /**
   * This instance is equal to all instances of {@code ListGroupsRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListGroupsRequest
        && equalTo((ListGroupsRequest) another);
  }

  private boolean equalTo(ListGroupsRequest another) {
    return Objects.equals(sortBy, another.sortBy)
        && Objects.equals(count, another.count)
        && Objects.equals(filter, another.filter)
        && Objects.equals(sortOrder, another.sortOrder)
        && Objects.equals(startIndex, another.startIndex)
        && Objects.equals(identityZoneId, another.identityZoneId);
  }

  /**
   * Computes a hash code from attributes: {@code sortBy}, {@code count}, {@code filter}, {@code sortOrder}, {@code startIndex}, {@code identityZoneId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(sortBy);
    h = h * 17 + Objects.hashCode(count);
    h = h * 17 + Objects.hashCode(filter);
    h = h * 17 + Objects.hashCode(sortOrder);
    h = h * 17 + Objects.hashCode(startIndex);
    h = h * 17 + Objects.hashCode(identityZoneId);
    return h;
  }

  /**
   * Prints the immutable value {@code ListGroupsRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListGroupsRequest{"
        + "sortBy=" + sortBy
        + ", count=" + count
        + ", filter=" + filter
        + ", sortOrder=" + sortOrder
        + ", startIndex=" + startIndex
        + ", identityZoneId=" + identityZoneId
        + "}";
  }

  /**
   * Creates a builder for {@link ListGroupsRequest ListGroupsRequest}.
   * @return A new ListGroupsRequest builder
   */
  public static ListGroupsRequest.Builder builder() {
    return new ListGroupsRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListGroupsRequest ListGroupsRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private String sortBy;
    private Integer count;
    private String filter;
    private SortOrder sortOrder;
    private Integer startIndex;
    private String identityZoneId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.PaginatedAndSortedByRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedAndSortedByRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.IdentityZoned} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(IdentityZoned instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.PaginatedAndSortedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedAndSortedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListGroupsRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListGroupsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListGroupsRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ListGroupsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof PaginatedAndSortedByRequest) {
        PaginatedAndSortedByRequest instance = (PaginatedAndSortedByRequest) object;
        String sortByValue = instance.getSortBy();
        if (sortByValue != null) {
          sortBy(sortByValue);
        }
      }
      if (object instanceof IdentityZoned) {
        IdentityZoned instance = (IdentityZoned) object;
        String identityZoneIdValue = instance.getIdentityZoneId();
        if (identityZoneIdValue != null) {
          identityZoneId(identityZoneIdValue);
        }
      }
      if (object instanceof PaginatedAndSortedRequest) {
        PaginatedAndSortedRequest instance = (PaginatedAndSortedRequest) object;
        String filterValue = instance.getFilter();
        if (filterValue != null) {
          filter(filterValue);
        }
        Integer countValue = instance.getCount();
        if (countValue != null) {
          count(countValue);
        }
        Integer startIndexValue = instance.getStartIndex();
        if (startIndexValue != null) {
          startIndex(startIndexValue);
        }
        SortOrder sortOrderValue = instance.getSortOrder();
        if (sortOrderValue != null) {
          sortOrder(sortOrderValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link _ListGroupsRequest#getSortBy() sortBy} attribute.
     * @param sortBy The value for sortBy (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder sortBy(@Nullable String sortBy) {
      this.sortBy = sortBy;
      return this;
    }

    /**
     * Initializes the value for the {@link _ListGroupsRequest#getCount() count} attribute.
     * @param count The value for count (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder count(@Nullable Integer count) {
      this.count = count;
      return this;
    }

    /**
     * Initializes the value for the {@link _ListGroupsRequest#getFilter() filter} attribute.
     * @param filter The value for filter (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder filter(@Nullable String filter) {
      this.filter = filter;
      return this;
    }

    /**
     * Initializes the value for the {@link _ListGroupsRequest#getSortOrder() sortOrder} attribute.
     * @param sortOrder The value for sortOrder (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder sortOrder(@Nullable SortOrder sortOrder) {
      this.sortOrder = sortOrder;
      return this;
    }

    /**
     * Initializes the value for the {@link _ListGroupsRequest#getStartIndex() startIndex} attribute.
     * @param startIndex The value for startIndex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder startIndex(@Nullable Integer startIndex) {
      this.startIndex = startIndex;
      return this;
    }

    /**
     * Initializes the value for the {@link _ListGroupsRequest#getIdentityZoneId() identityZoneId} attribute.
     * @param identityZoneId The value for identityZoneId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneId(@Nullable String identityZoneId) {
      this.identityZoneId = identityZoneId;
      return this;
    }

    /**
     * Builds a new {@link ListGroupsRequest ListGroupsRequest}.
     * @return An immutable instance of ListGroupsRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListGroupsRequest build() {
      return new ListGroupsRequest(this);
    }
  }
}
