package org.cloudfoundry.uaa.identityproviders;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The payload for the internal identity provider configuration
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_InternalConfiguration"})
public final class InternalConfiguration extends org.cloudfoundry.uaa.identityproviders._InternalConfiguration {
  private final @Nullable Boolean disableInternalUserManagement;
  private final @Nullable List<String> emailDomains;
  private final @Nullable LockoutPolicy lockoutPolicy;
  private final @Nullable PasswordPolicy passwordPolicy;
  private final @Nullable String providerDescription;

  private InternalConfiguration(InternalConfiguration.Builder builder) {
    this.disableInternalUserManagement = builder.disableInternalUserManagement;
    this.emailDomains = builder.emailDomains == null ? null : createUnmodifiableList(true, builder.emailDomains);
    this.lockoutPolicy = builder.lockoutPolicy;
    this.passwordPolicy = builder.passwordPolicy;
    this.providerDescription = builder.providerDescription;
  }

  /**
   * When set to true, user management is disabled for this provider, defaults to false
   */
  @JsonProperty("disableInternalUserManagement")
  @Override
  public @Nullable Boolean getDisableInternalUserManagement() {
    return disableInternalUserManagement;
  }

  /**
   * List of email domains associated with the provider for the purpose of associating users to the correct origin upon invitation. If empty list, no invitations are accepted. Wildcards supported.
   */
  @JsonProperty("emailDomain")
  @Override
  public @Nullable List<String> getEmailDomains() {
    return emailDomains;
  }

  /**
   * The lockout policy
   */
  @JsonProperty("lockoutPolicy")
  @Override
  public @Nullable LockoutPolicy getLockoutPolicy() {
    return lockoutPolicy;
  }

  /**
   * The password policy
   */
  @JsonProperty("passwordPolicy")
  @Override
  public @Nullable PasswordPolicy getPasswordPolicy() {
    return passwordPolicy;
  }

  /**
   * Human readable name/description of this provider
   */
  @JsonProperty("providerDescription")
  @Override
  public @Nullable String getProviderDescription() {
    return providerDescription;
  }

  /**
   * This instance is equal to all instances of {@code InternalConfiguration} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof InternalConfiguration
        && equalTo((InternalConfiguration) another);
  }

  private boolean equalTo(InternalConfiguration another) {
    return Objects.equals(disableInternalUserManagement, another.disableInternalUserManagement)
        && Objects.equals(emailDomains, another.emailDomains)
        && Objects.equals(lockoutPolicy, another.lockoutPolicy)
        && Objects.equals(passwordPolicy, another.passwordPolicy)
        && Objects.equals(providerDescription, another.providerDescription);
  }

  /**
   * Computes a hash code from attributes: {@code disableInternalUserManagement}, {@code emailDomains}, {@code lockoutPolicy}, {@code passwordPolicy}, {@code providerDescription}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(disableInternalUserManagement);
    h = h * 17 + Objects.hashCode(emailDomains);
    h = h * 17 + Objects.hashCode(lockoutPolicy);
    h = h * 17 + Objects.hashCode(passwordPolicy);
    h = h * 17 + Objects.hashCode(providerDescription);
    return h;
  }

  /**
   * Prints the immutable value {@code InternalConfiguration} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "InternalConfiguration{"
        + "disableInternalUserManagement=" + disableInternalUserManagement
        + ", emailDomains=" + emailDomains
        + ", lockoutPolicy=" + lockoutPolicy
        + ", passwordPolicy=" + passwordPolicy
        + ", providerDescription=" + providerDescription
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.identityproviders._InternalConfiguration {
    Boolean disableInternalUserManagement;
    List<String> emailDomains = null;
    LockoutPolicy lockoutPolicy;
    PasswordPolicy passwordPolicy;
    String providerDescription;
    @JsonProperty("disableInternalUserManagement")
    public void setDisableInternalUserManagement(@Nullable Boolean disableInternalUserManagement) {
      this.disableInternalUserManagement = disableInternalUserManagement;
    }
    @JsonProperty("emailDomain")
    public void setEmailDomains(@Nullable List<String> emailDomains) {
      this.emailDomains = emailDomains;
    }
    @JsonProperty("lockoutPolicy")
    public void setLockoutPolicy(@Nullable LockoutPolicy lockoutPolicy) {
      this.lockoutPolicy = lockoutPolicy;
    }
    @JsonProperty("passwordPolicy")
    public void setPasswordPolicy(@Nullable PasswordPolicy passwordPolicy) {
      this.passwordPolicy = passwordPolicy;
    }
    @JsonProperty("providerDescription")
    public void setProviderDescription(@Nullable String providerDescription) {
      this.providerDescription = providerDescription;
    }
    @Override
    public Boolean getDisableInternalUserManagement() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getEmailDomains() { throw new UnsupportedOperationException(); }
    @Override
    public LockoutPolicy getLockoutPolicy() { throw new UnsupportedOperationException(); }
    @Override
    public PasswordPolicy getPasswordPolicy() { throw new UnsupportedOperationException(); }
    @Override
    public String getProviderDescription() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static InternalConfiguration fromJson(Json json) {
    InternalConfiguration.Builder builder = InternalConfiguration.builder();
    if (json.disableInternalUserManagement != null) {
      builder.disableInternalUserManagement(json.disableInternalUserManagement);
    }
    if (json.emailDomains != null) {
      builder.addAllEmailDomains(json.emailDomains);
    }
    if (json.lockoutPolicy != null) {
      builder.lockoutPolicy(json.lockoutPolicy);
    }
    if (json.passwordPolicy != null) {
      builder.passwordPolicy(json.passwordPolicy);
    }
    if (json.providerDescription != null) {
      builder.providerDescription(json.providerDescription);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link InternalConfiguration InternalConfiguration}.
   * @return A new InternalConfiguration builder
   */
  public static InternalConfiguration.Builder builder() {
    return new InternalConfiguration.Builder();
  }

  /**
   * Builds instances of type {@link InternalConfiguration InternalConfiguration}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private Boolean disableInternalUserManagement;
    private List<String> emailDomains = null;
    private LockoutPolicy lockoutPolicy;
    private PasswordPolicy passwordPolicy;
    private String providerDescription;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.identityproviders.AbstractIdentityProviderConfiguration} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractIdentityProviderConfiguration instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code InternalConfiguration} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(InternalConfiguration instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _InternalConfiguration} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_InternalConfiguration instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof AbstractIdentityProviderConfiguration) {
        AbstractIdentityProviderConfiguration instance = (AbstractIdentityProviderConfiguration) object;
        if ((bits & 0x1L) == 0) {
          List<String> emailDomainsValue = instance.getEmailDomains();
          if (emailDomainsValue != null) {
            addAllEmailDomains(emailDomainsValue);
          }
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          String providerDescriptionValue = instance.getProviderDescription();
          if (providerDescriptionValue != null) {
            providerDescription(providerDescriptionValue);
          }
          bits |= 0x2L;
        }
      }
      if (object instanceof org.cloudfoundry.uaa.identityproviders._InternalConfiguration) {
        org.cloudfoundry.uaa.identityproviders._InternalConfiguration instance = (org.cloudfoundry.uaa.identityproviders._InternalConfiguration) object;
        if ((bits & 0x1L) == 0) {
          List<String> emailDomainsValue = instance.getEmailDomains();
          if (emailDomainsValue != null) {
            addAllEmailDomains(emailDomainsValue);
          }
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          String providerDescriptionValue = instance.getProviderDescription();
          if (providerDescriptionValue != null) {
            providerDescription(providerDescriptionValue);
          }
          bits |= 0x2L;
        }
        PasswordPolicy passwordPolicyValue = instance.getPasswordPolicy();
        if (passwordPolicyValue != null) {
          passwordPolicy(passwordPolicyValue);
        }
        LockoutPolicy lockoutPolicyValue = instance.getLockoutPolicy();
        if (lockoutPolicyValue != null) {
          lockoutPolicy(lockoutPolicyValue);
        }
        Boolean disableInternalUserManagementValue = instance.getDisableInternalUserManagement();
        if (disableInternalUserManagementValue != null) {
          disableInternalUserManagement(disableInternalUserManagementValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link _InternalConfiguration#getDisableInternalUserManagement() disableInternalUserManagement} attribute.
     * @param disableInternalUserManagement The value for disableInternalUserManagement (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("disableInternalUserManagement")
    public final Builder disableInternalUserManagement(@Nullable Boolean disableInternalUserManagement) {
      this.disableInternalUserManagement = disableInternalUserManagement;
      return this;
    }

    /**
     * Adds one element to {@link _InternalConfiguration#getEmailDomains() emailDomains} list.
     * @param element A emailDomains element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder emailDomain(String element) {
      if (this.emailDomains == null) {
        this.emailDomains = new ArrayList<String>();
      }
      this.emailDomains.add(Objects.requireNonNull(element, "emailDomains element"));
      return this;
    }

    /**
     * Adds elements to {@link _InternalConfiguration#getEmailDomains() emailDomains} list.
     * @param elements An array of emailDomains elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder emailDomain(String... elements) {
      if (this.emailDomains == null) {
        this.emailDomains = new ArrayList<String>();
      }
      for (String element : elements) {
        this.emailDomains.add(Objects.requireNonNull(element, "emailDomains element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _InternalConfiguration#getEmailDomains() emailDomains} list.
     * @param elements An iterable of emailDomains elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("emailDomain")
    public final Builder emailDomains(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.emailDomains = null;
        return this;
      }
      this.emailDomains = new ArrayList<String>();
      return addAllEmailDomains(elements);
    }

    /**
     * Adds elements to {@link _InternalConfiguration#getEmailDomains() emailDomains} list.
     * @param elements An iterable of emailDomains elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllEmailDomains(Iterable<String> elements) {
      Objects.requireNonNull(elements, "emailDomains element");
      if (this.emailDomains == null) {
        this.emailDomains = new ArrayList<String>();
      }
      for (String element : elements) {
        this.emailDomains.add(Objects.requireNonNull(element, "emailDomains element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _InternalConfiguration#getLockoutPolicy() lockoutPolicy} attribute.
     * @param lockoutPolicy The value for lockoutPolicy (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("lockoutPolicy")
    public final Builder lockoutPolicy(@Nullable LockoutPolicy lockoutPolicy) {
      this.lockoutPolicy = lockoutPolicy;
      return this;
    }

    /**
     * Initializes the value for the {@link _InternalConfiguration#getPasswordPolicy() passwordPolicy} attribute.
     * @param passwordPolicy The value for passwordPolicy (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("passwordPolicy")
    public final Builder passwordPolicy(@Nullable PasswordPolicy passwordPolicy) {
      this.passwordPolicy = passwordPolicy;
      return this;
    }

    /**
     * Initializes the value for the {@link _InternalConfiguration#getProviderDescription() providerDescription} attribute.
     * @param providerDescription The value for providerDescription (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("providerDescription")
    public final Builder providerDescription(@Nullable String providerDescription) {
      this.providerDescription = providerDescription;
      return this;
    }

    /**
     * Builds a new {@link InternalConfiguration InternalConfiguration}.
     * @return An immutable instance of InternalConfiguration
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public InternalConfiguration build() {
      return new InternalConfiguration(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
