package org.cloudfoundry.uaa.identityzones;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The payload for the identity zone links
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_Links"})
public final class Links extends org.cloudfoundry.uaa.identityzones._Links {
  private final @Nullable String homeRedirect;
  private final @Nullable LogoutLink logout;
  private final @Nullable SelfServiceLink selfService;

  private Links(Links.Builder builder) {
    this.homeRedirect = builder.homeRedirect;
    this.logout = builder.logout;
    this.selfService = builder.selfService;
  }

  /**
   * The URL redirect
   */
  @JsonProperty("homeRedirect")
  @Override
  public @Nullable String getHomeRedirect() {
    return homeRedirect;
  }

  /**
   * The logout link
   */
  @JsonProperty("logout")
  @Override
  public @Nullable LogoutLink getLogout() {
    return logout;
  }

  /**
   * The self service link
   */
  @JsonProperty("selfService")
  @Override
  public @Nullable SelfServiceLink getSelfService() {
    return selfService;
  }

  /**
   * This instance is equal to all instances of {@code Links} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Links
        && equalTo((Links) another);
  }

  private boolean equalTo(Links another) {
    return Objects.equals(homeRedirect, another.homeRedirect)
        && Objects.equals(logout, another.logout)
        && Objects.equals(selfService, another.selfService);
  }

  /**
   * Computes a hash code from attributes: {@code homeRedirect}, {@code logout}, {@code selfService}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(homeRedirect);
    h = h * 17 + Objects.hashCode(logout);
    h = h * 17 + Objects.hashCode(selfService);
    return h;
  }

  /**
   * Prints the immutable value {@code Links} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Links{"
        + "homeRedirect=" + homeRedirect
        + ", logout=" + logout
        + ", selfService=" + selfService
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.identityzones._Links {
    String homeRedirect;
    LogoutLink logout;
    SelfServiceLink selfService;
    @JsonProperty("homeRedirect")
    public void setHomeRedirect(@Nullable String homeRedirect) {
      this.homeRedirect = homeRedirect;
    }
    @JsonProperty("logout")
    public void setLogout(@Nullable LogoutLink logout) {
      this.logout = logout;
    }
    @JsonProperty("selfService")
    public void setSelfService(@Nullable SelfServiceLink selfService) {
      this.selfService = selfService;
    }
    @Override
    public String getHomeRedirect() { throw new UnsupportedOperationException(); }
    @Override
    public LogoutLink getLogout() { throw new UnsupportedOperationException(); }
    @Override
    public SelfServiceLink getSelfService() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static Links fromJson(Json json) {
    Links.Builder builder = Links.builder();
    if (json.homeRedirect != null) {
      builder.homeRedirect(json.homeRedirect);
    }
    if (json.logout != null) {
      builder.logout(json.logout);
    }
    if (json.selfService != null) {
      builder.selfService(json.selfService);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Links Links}.
   * @return A new Links builder
   */
  public static Links.Builder builder() {
    return new Links.Builder();
  }

  /**
   * Builds instances of type {@link Links Links}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private String homeRedirect;
    private LogoutLink logout;
    private SelfServiceLink selfService;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Links} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Links instance) {
      return from((_Links) instance);
    }

    /**
     * Copy abstract value type {@code _Links} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Links instance) {
      Objects.requireNonNull(instance, "instance");
      String homeRedirectValue = instance.getHomeRedirect();
      if (homeRedirectValue != null) {
        homeRedirect(homeRedirectValue);
      }
      LogoutLink logoutValue = instance.getLogout();
      if (logoutValue != null) {
        logout(logoutValue);
      }
      SelfServiceLink selfServiceValue = instance.getSelfService();
      if (selfServiceValue != null) {
        selfService(selfServiceValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _Links#getHomeRedirect() homeRedirect} attribute.
     * @param homeRedirect The value for homeRedirect (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("homeRedirect")
    public final Builder homeRedirect(@Nullable String homeRedirect) {
      this.homeRedirect = homeRedirect;
      return this;
    }

    /**
     * Initializes the value for the {@link _Links#getLogout() logout} attribute.
     * @param logout The value for logout (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("logout")
    public final Builder logout(@Nullable LogoutLink logout) {
      this.logout = logout;
      return this;
    }

    /**
     * Initializes the value for the {@link _Links#getSelfService() selfService} attribute.
     * @param selfService The value for selfService (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("selfService")
    public final Builder selfService(@Nullable SelfServiceLink selfService) {
      this.selfService = selfService;
      return this;
    }

    /**
     * Builds a new {@link Links Links}.
     * @return An immutable instance of Links
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Links build() {
      return new Links(this);
    }
  }
}
