package org.cloudfoundry.uaa.identityzones;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The request payload for the identity zone saml configuration
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_Prompt"})
public final class Prompt extends org.cloudfoundry.uaa.identityzones._Prompt {
  private final @Nullable String fieldName;
  private final @Nullable String fieldType;
  private final @Nullable String text;

  private Prompt(Prompt.Builder builder) {
    this.fieldName = builder.fieldName;
    this.fieldType = builder.fieldType;
    this.text = builder.text;
  }

  /**
   * Name of field.
   */
  @JsonProperty("name")
  @Override
  public @Nullable String getFieldName() {
    return fieldName;
  }

  /**
   * What kind of field this is (e.g. text or password)
   */
  @JsonProperty("type")
  @Override
  public @Nullable String getFieldType() {
    return fieldType;
  }

  /**
   * Actual text displayed on prompt for field.
   */
  @JsonProperty("text")
  @Override
  public @Nullable String getText() {
    return text;
  }

  /**
   * This instance is equal to all instances of {@code Prompt} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Prompt
        && equalTo((Prompt) another);
  }

  private boolean equalTo(Prompt another) {
    return Objects.equals(fieldName, another.fieldName)
        && Objects.equals(fieldType, another.fieldType)
        && Objects.equals(text, another.text);
  }

  /**
   * Computes a hash code from attributes: {@code fieldName}, {@code fieldType}, {@code text}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(fieldName);
    h = h * 17 + Objects.hashCode(fieldType);
    h = h * 17 + Objects.hashCode(text);
    return h;
  }

  /**
   * Prints the immutable value {@code Prompt} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Prompt{"
        + "fieldName=" + fieldName
        + ", fieldType=" + fieldType
        + ", text=" + text
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.identityzones._Prompt {
    String fieldName;
    String fieldType;
    String text;
    @JsonProperty("name")
    public void setFieldName(@Nullable String fieldName) {
      this.fieldName = fieldName;
    }
    @JsonProperty("type")
    public void setFieldType(@Nullable String fieldType) {
      this.fieldType = fieldType;
    }
    @JsonProperty("text")
    public void setText(@Nullable String text) {
      this.text = text;
    }
    @Override
    public String getFieldName() { throw new UnsupportedOperationException(); }
    @Override
    public String getFieldType() { throw new UnsupportedOperationException(); }
    @Override
    public String getText() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static Prompt fromJson(Json json) {
    Prompt.Builder builder = Prompt.builder();
    if (json.fieldName != null) {
      builder.fieldName(json.fieldName);
    }
    if (json.fieldType != null) {
      builder.fieldType(json.fieldType);
    }
    if (json.text != null) {
      builder.text(json.text);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Prompt Prompt}.
   * @return A new Prompt builder
   */
  public static Prompt.Builder builder() {
    return new Prompt.Builder();
  }

  /**
   * Builds instances of type {@link Prompt Prompt}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private String fieldName;
    private String fieldType;
    private String text;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Prompt} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Prompt instance) {
      return from((_Prompt) instance);
    }

    /**
     * Copy abstract value type {@code _Prompt} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Prompt instance) {
      Objects.requireNonNull(instance, "instance");
      String fieldNameValue = instance.getFieldName();
      if (fieldNameValue != null) {
        fieldName(fieldNameValue);
      }
      String fieldTypeValue = instance.getFieldType();
      if (fieldTypeValue != null) {
        fieldType(fieldTypeValue);
      }
      String textValue = instance.getText();
      if (textValue != null) {
        text(textValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _Prompt#getFieldName() fieldName} attribute.
     * @param fieldName The value for fieldName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder fieldName(@Nullable String fieldName) {
      this.fieldName = fieldName;
      return this;
    }

    /**
     * Initializes the value for the {@link _Prompt#getFieldType() fieldType} attribute.
     * @param fieldType The value for fieldType (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type")
    public final Builder fieldType(@Nullable String fieldType) {
      this.fieldType = fieldType;
      return this;
    }

    /**
     * Initializes the value for the {@link _Prompt#getText() text} attribute.
     * @param text The value for text (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("text")
    public final Builder text(@Nullable String text) {
      this.text = text;
      return this;
    }

    /**
     * Builds a new {@link Prompt Prompt}.
     * @return An immutable instance of Prompt
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Prompt build() {
      return new Prompt(this);
    }
  }
}
